/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.licence;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.gui.licence.PLicenceChangeListener;
import com.nokia.em.poseidon.plugin.object.ObjectRegistry;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryEvent;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryListener;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.services.licence.PLicenceListener;
import com.nokia.em.poseidon.services.licence.PLicenceMediator;
import com.nokia.em.poseidon.services.licence.PLicenceService;
import com.nokia.widgets.progress.models.ProgressBarModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PLicenceServiceImpl
implements PLicenceService,
PluginRegistryListener,
Service {
    private List<PLicenceMediator> myLicenceMediators;
    private Set<PLicenceListener> myLicenceListeners;
    private PLicenceChangeListener myLicenceChangeListener;
    private Collection<PLicence> myLicenceList;
    private Logger myLogger;
    private boolean mySWMonitoringEnabled = false;

    @Override
    public void addMediator(PLicenceMediator licenceMediator) {
        PLicenceMediator oldMediator = null;
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            if (!mediator.getElementType().equals(licenceMediator.getElementType())) continue;
            oldMediator = mediator;
        }
        if (oldMediator != null) {
            this.myLicenceMediators.remove(oldMediator);
        }
        this.myLicenceMediators.add(licenceMediator);
        this.myLogger.trace("New mediator added to Licence Management service " + licenceMediator.getElementType());
    }

    @Override
    public void requestLicences() {
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            mediator.requestLicences();
        }
        this.myLogger.debug("Licence Management service requested licences from mediators.");
    }

    @Override
    public void activateLicences(List<PLicence> licences) {
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            List<PLicence> filtered = this.filterLicences(licences, mediator);
            if (filtered.size() <= 0) continue;
            mediator.activateLicences(filtered);
        }
        this.myLogger.debug("Licence Management service sent activate licences command for mediators.");
    }

    @Override
    public void deactivateLicences(List<PLicence> licences) {
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            List<PLicence> filtered = this.filterLicences(licences, mediator);
            if (filtered.size() <= 0) continue;
            mediator.deactivateLicences(filtered);
        }
        this.myLogger.debug("Licence Management service sent deactivate licences command for mediators.");
    }

    @Override
    public boolean downloadLicence(PLicence licence, ProgressBarModel progressModel) {
        PLicenceMediator mediator = this.findMediator(licence);
        if (mediator != null) {
            mediator.downloadLicence(licence, progressModel);
            this.myLogger.debug("Licence Management service sent download licence " + licence.getSerialNumber() + " command");
            return true;
        }
        return false;
    }

    @Override
    public void uploadLicences(List<PLicence> licences, ProgressBarModel progressModel) {
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            List<PLicence> filtered = this.filterLicences(licences, mediator);
            if (filtered.size() <= 0) continue;
            mediator.uploadLicences(filtered, progressModel);
        }
        this.myLogger.debug("Licence Management service sent upload licences command.");
    }

    @Override
    public void deleteLicence(List<PLicence> licences, ProgressBarModel progressModel) {
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            List<PLicence> filtered = this.filterLicences(licences, mediator);
            if (filtered.size() <= 0) continue;
            mediator.deleteLicence(filtered, progressModel);
        }
        this.myLogger.debug("Licence Management service sent delete licences command.");
    }

    private List<PLicence> filterLicences(List<PLicence> licences, PLicenceMediator mediator) {
        ArrayList<PLicence> result = new ArrayList<PLicence>();
        for (PLicence licence : licences) {
            if (!this.acceptMediator(licence, mediator)) continue;
            result.add(licence);
        }
        return result;
    }

    @Override
    public boolean isActivateSupported(PLicence licence) {
        if (licence == null) {
            for (PLicenceMediator mediator : this.myLicenceMediators) {
                if (!mediator.isActivateSupported()) continue;
                return true;
            }
            return false;
        }
        PLicenceMediator mediator = this.findMediator(licence);
        if (mediator != null) {
            return mediator.isActivateSupported();
        }
        return false;
    }

    @Override
    public boolean isDeactivateSupported(PLicence licence) {
        if (licence == null) {
            for (PLicenceMediator mediator : this.myLicenceMediators) {
                if (!mediator.isDeactivateSupported()) continue;
                return true;
            }
            return false;
        }
        PLicenceMediator mediator = this.findMediator(licence);
        if (mediator != null) {
            return mediator.isDeactivateSupported();
        }
        return false;
    }

    @Override
    public boolean isDeleteSupported(PLicence licence) {
        if (licence == null) {
            for (PLicenceMediator mediator : this.myLicenceMediators) {
                if (!mediator.isDeleteSupported()) continue;
                return true;
            }
            return false;
        }
        PLicenceMediator mediator = this.findMediator(licence);
        if (mediator != null) {
            return mediator.isDeleteSupported();
        }
        return false;
    }

    @Override
    public boolean isUploadSupported(PLicence licence) {
        if (licence == null) {
            for (PLicenceMediator mediator : this.myLicenceMediators) {
                if (!mediator.isUploadSupported()) continue;
                return true;
            }
            return false;
        }
        PLicenceMediator mediator = this.findMediator(licence);
        if (mediator != null) {
            return mediator.isUploadSupported();
        }
        return false;
    }

    @Override
    public boolean isLicenceRemovedInUpload(PLicence licence) {
        PLicenceMediator mediator = this.findMediator(licence);
        if (mediator != null) {
            return mediator.isLicenceRemovedInUpload();
        }
        return false;
    }

    @Override
    public void addLicenceChangeListener(PLicenceChangeListener listener) {
        this.myLicenceChangeListener = listener;
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            mediator.addLicenceChangeListener(listener);
        }
        this.myLogger.trace("Added licence change listener to Licence Management service.");
    }

    private PLicenceMediator findMediator(PLicence licence) {
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            if (!this.acceptMediator(licence, mediator)) continue;
            return mediator;
        }
        return null;
    }

    protected boolean acceptMediator(PLicence licence, PLicenceMediator mediator) {
        return mediator.getElementType().equals(licence.getElementType());
    }

    @Override
    public boolean remoteServerVisible() {
        for (PLicenceMediator mediator : this.myLicenceMediators) {
            if (!mediator.remoteServerVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] areOperationsSupported(List<PLicence> selectedLicences) {
        boolean[] operationSupport = new boolean[]{true, true, true, true};
        boolean[] operationSupportTemp = null;
        for (PLicence lic : selectedLicences) {
            operationSupportTemp = this.areOperationsSupported(lic);
            operationSupport[0] = !operationSupportTemp[0] ? false : operationSupport[0];
            operationSupport[1] = !operationSupportTemp[1] ? false : operationSupport[1];
            operationSupport[2] = !operationSupportTemp[2] ? false : operationSupport[2];
            boolean bl = operationSupport[3] = !operationSupportTemp[3] ? false : operationSupport[3];
        }
        return operationSupport;
    }

    public boolean[] areOperationsSupported(PLicence licence) {
        PLicenceMediator mediator = this.findMediator(licence);
        if (mediator != null) {
            return mediator.areOperationsSupported();
        }
        return new boolean[4];
    }

    @Override
    public int getMediatorCount() {
        return this.myLicenceMediators.size();
    }

    @Override
    public Collection<PLicence> getLicences() {
        if (this.myLicenceChangeListener != null) {
            return this.myLicenceChangeListener.getLicences();
        }
        return this.myLicenceList;
    }

    @Override
    public Collection<PLicence> getLicences(String elementType) {
        Collection<PLicence> allLicences = this.myLicenceChangeListener == null ? this.myLicenceList : this.myLicenceChangeListener.getLicences();
        ArrayList<PLicence> elementLicences = new ArrayList<PLicence>();
        for (PLicence licence : allLicences) {
            if (!licence.getElementType().equals(elementType)) continue;
            elementLicences.add(licence);
        }
        return elementLicences;
    }

    @Override
    public Collection<PLicence> getFeatureLicences(String featureCode) {
        ArrayList<PLicence> featureLicences = new ArrayList<PLicence>();
        Collection<PLicence> allLicences = this.getLicences();
        for (PLicence licence : allLicences) {
            if (!licence.getFeatureCodes().contains(featureCode)) continue;
            featureLicences.add(licence);
        }
        return featureLicences;
    }

    @Override
    public void addLicenceListener(PLicenceListener listener) {
        if (listener != null) {
            this.myLicenceListeners.add(listener);
        }
        this.myLogger.trace("Added licence listener to Licence Management service.");
    }

    @Override
    public void removeLicenceListener(PLicenceListener listener) {
        this.myLicenceListeners.remove(listener);
        this.myLogger.trace("Removed licence listener from Licence Management service.");
    }

    @Override
    public void notifyLicencesUpdated(List<PLicence> licences) {
        for (PLicence licence : licences) {
            if (this.myLicenceList.contains(licence)) continue;
            this.myLicenceList.add(licence);
        }
        for (PLicenceListener listener : this.myLicenceListeners) {
            try {
                listener.licencesUpdated(licences);
            }
            catch (Exception e) {
                this.myLogger.error("Licence listener " + listener + " throws exception when updating licences.", e);
            }
        }
        this.myLogger.debug("Licence Management service notified licence listeners that licences are updated.");
    }

    @Override
    public void notifyLicenceDeleted(PLicence licence) {
        this.myLicenceList.remove(licence);
        for (PLicenceListener listener : this.myLicenceListeners) {
            try {
                listener.licenceDeleted(licence);
            }
            catch (Exception e) {
                this.myLogger.error("Licence listener " + listener + " throws exception when deleting licence.", e);
            }
        }
        this.myLogger.debug("Licence Management service notified licence listeners that licence is removed.");
    }

    @Override
    public void notifyLicenceDownloaded(PLicence licence) {
        for (PLicenceListener listener : this.myLicenceListeners) {
            try {
                listener.licenceDownloaded(licence);
            }
            catch (Exception e) {
                this.myLogger.error("Licence listener " + listener + " throws exception when licences downloaded.", e);
            }
        }
        this.myLogger.debug("Licence Management service notified licence listeners that licence is downloaded.");
    }

    @Override
    public void notifyLicenceActivated(PLicence licence) {
        for (PLicenceListener listener : this.myLicenceListeners) {
            try {
                listener.licenceActivated(licence);
            }
            catch (Exception e) {
                this.myLogger.error("Licence listener " + listener + " throws exception when licence activated.", e);
            }
        }
        this.myLogger.debug("Licence Management service notified licence listeners that licence is activated.");
    }

    @Override
    public void notifyLicenceDeactivated(PLicence licence) {
        for (PLicenceListener listener : this.myLicenceListeners) {
            try {
                listener.licenceDeactivated(licence);
            }
            catch (Exception e) {
                this.myLogger.error("Licence listener " + listener + " throws exception when licence deactivated.", e);
            }
        }
        this.myLogger.debug("Licence Management service notified licence listeners that licence is deactivated.");
    }

    @Override
    public void addLicences(List<PLicence> licences) {
        if (licences == null) {
            return;
        }
        for (PLicence licence : licences) {
            if (this.myLicenceList.contains(licence)) continue;
            this.myLicenceList.add(licence);
        }
        this.notifyLicencesUpdated(licences);
        this.myLogger.debug("Licences added to Licence Management service.");
    }

    @Override
    public void removeLicences() {
        for (PLicence licence : this.myLicenceList) {
            for (PLicenceListener listener : this.myLicenceListeners) {
                listener.licenceDeleted(licence);
            }
        }
        this.myLicenceList.clear();
        this.myLogger.debug("Licences removed from Licence Management service.");
    }

    @Override
    public void removeLicences(String elementType) {
        ArrayList<PLicence> removedLicences = new ArrayList<PLicence>();
        for (PLicence licence : this.myLicenceList) {
            if (!licence.getElementType().equals(elementType)) continue;
            removedLicences.add(licence);
        }
        for (PLicence remLicence : removedLicences) {
            this.myLicenceList.remove(remLicence);
            for (PLicenceListener listener : this.myLicenceListeners) {
                listener.licenceDeleted(remLicence);
            }
        }
        this.myLogger.debug("Licences removed from Licence Management service.");
    }

    @Override
    public void itemAdded(PluginRegistryEvent event) {
        Object service = event.getPlugin();
        if (service instanceof PLicenceMediator && !this.myLicenceMediators.contains(event.getPlugin())) {
            this.myLicenceMediators.add((PLicenceMediator)service);
        }
    }

    @Override
    public void itemRemoved(PluginRegistryEvent event) {
        this.myLicenceMediators.remove(event.getPlugin());
    }

    @Override
    public void start() {
        this.myLicenceList = new ArrayList<PLicence>();
        this.myLicenceMediators = new ArrayList<PLicenceMediator>();
        this.myLicenceListeners = new HashSet<PLicenceListener>();
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLicenceMediators = PoseidonRuntime.getRuntime().getObjects(PLicenceMediator.class);
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).addRegistryListener(this);
    }

    @Override
    public void stop() {
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).removeRegistryListener(this);
        this.myLicenceList.clear();
        this.myLicenceMediators.clear();
        this.myLicenceListeners.clear();
    }

    @Override
    public void setSWMonitoringEnabled(boolean enableSWMonitoring) {
        if (enableSWMonitoring ^ this.mySWMonitoringEnabled) {
            this.mySWMonitoringEnabled = enableSWMonitoring;
            this.notifyLicencesUpdated((ArrayList)this.myLicenceList);
        }
    }

    @Override
    public boolean isSWMonitoringEnabled() {
        return this.mySWMonitoringEnabled;
    }
}

