/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot;

import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressEvent;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressTask;
import com.nokia.em.poseidon.services.snapshot.event.SaveSnapshotServiceEvent;
import com.nokia.em.poseidon.services.snapshot.observer.manager.SnapshotSavingObserverManager;
import com.nokia.em.poseidon.services.snapshot.operations.PSnapshotCommonOperation;
import com.nokia.em.poseidon.snapshot.view.handler.ProgressHandler;
import java.util.List;
import java.util.Map;

public class CustomProgressHandler
implements ProgressHandler {
    private Map<PSnapshotCommonOperation, PStepProgressTask> myOperationToTasks;

    public CustomProgressHandler(Map<PSnapshotCommonOperation, PStepProgressTask> operationToTasks) {
        this.myOperationToTasks = operationToTasks;
    }

    @Override
    public void updateStepDescription(PSnapshotCommonOperation operation) {
        PStepProgressTask task = this.myOperationToTasks.get(operation);
        task.setOperationName(operation.getName());
        SnapshotSavingObserverManager.notifyListeners(new SaveSnapshotServiceEvent(SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.UPDATE_DESCRIPTION, new PStepProgressEvent(task)));
    }

    @Override
    public void taskUpdated(PStepProgressEvent event) {
        SnapshotSavingObserverManager.notifyListeners(new SaveSnapshotServiceEvent(SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.UPDATE_PROGRESS, event));
    }

    @Override
    public void operationCompleted(PStepProgressEvent event) {
        SnapshotSavingObserverManager.notifyListeners(new SaveSnapshotServiceEvent(SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.OPERATION_COMPLETED, event));
    }

    @Override
    public void setProgressTasks(List<PStepProgressTask> snapshotSavingProgressTasks) {
        SnapshotSavingObserverManager.notifyListeners(new SaveSnapshotServiceEvent(SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.UPDATE_TASK, snapshotSavingProgressTasks));
    }

    @Override
    public void taskStarted(PStepProgressEvent event) {
        SnapshotSavingObserverManager.notifyListeners(new SaveSnapshotServiceEvent(SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.STARTED, event));
    }

    @Override
    public void taskCancelled(PStepProgressEvent event) {
        SnapshotSavingObserverManager.notifyListeners(new SaveSnapshotServiceEvent(SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.CANCEL, event));
    }
}

