/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot;

import com.nokia.em.poseidon.services.snapshot.desc.SnapshotInfo;
import com.nokia.em.poseidon.services.snapshot.desc.SystemDescription;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.xml.ObjectLoader;
import com.nokia.widgets.systeminfo.SystemInfoInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PSnapshotFileModel {
    private static final String SETTINGS_OWNERNAME = "snapshot";
    private File mySnapshotDirFile;
    private PSettings mySettings;
    private SnapshotInfo mySnapshotInfo;
    private SystemInfoInterface mySystemInfo;
    private Logger myLogger;

    public PSnapshotFileModel(File snapshotFile, String snapshotFileName) {
        this.mySnapshotDirFile = snapshotFile;
        this.myLogger = Logger.getLogger(this.getClass());
        if (!this.mySnapshotDirFile.isDirectory()) {
            throw new IllegalArgumentException("The model can only be created from a directory");
        }
        this.mySettings = this.createSettings("snapshot.properties", SETTINGS_OWNERNAME);
        this.mySnapshotInfo = this.createSnapshotInfo(snapshotFileName);
        if (this.mySnapshotInfo != null) {
            this.mySystemInfo = new SnapshotSystemInfo(this.mySnapshotInfo.getSystemDescription());
        }
    }

    public PSettings getSettings() {
        return this.mySettings;
    }

    public SystemInfoInterface getSystemInformation() {
        return this.mySystemInfo;
    }

    public Map<String, URL> getMediatorURLs() {
        HashMap<String, URL> urlMap = new HashMap<String, URL>();
        String[] files = this.mySnapshotDirFile.list();
        if (files == null) {
            return null;
        }
        int i = 0;
        while (i < files.length) {
            File file = new File(this.mySnapshotDirFile, files[i]);
            if (file.isDirectory()) {
                try {
                    urlMap.put(files[i], file.toURI().toURL());
                }
                catch (MalformedURLException exception) {
                    this.myLogger.error("Unable to create url from the snapshot", exception);
                }
            }
            ++i;
        }
        if (urlMap.size() > 0) {
            return urlMap;
        }
        return null;
    }

    public SnapshotInfo getSnapshotInfo() {
        return this.mySnapshotInfo;
    }

    public void clear() {
        this.mySettings = null;
        this.mySnapshotInfo = null;
        this.mySystemInfo = null;
    }

    private PSettings createSettings(String filename, String ownerName) {
        PSettings settings = null;
        FileInputStream fos = null;
        File settingsFile = this.getFile(filename);
        if (settingsFile != null) {
            settings = PSettings.getInstance(ownerName);
            try {
                fos = new FileInputStream(settingsFile);
                settings.load(fos);
                fos.close();
            }
            catch (IOException exception) {
                this.myLogger.error("Unable to load settings from snapshot", exception);
                settings = null;
            }
        }
        return settings;
    }

    private SnapshotInfo createSnapshotInfo(String snapshotFileName) {
        SnapshotInfo info = null;
        File descFile = this.getFile("snapshotDesc.xml");
        if (descFile != null) {
            ObjectLoader objectLoader = new ObjectLoader(SnapshotInfo.class.getPackage().getName());
            try {
                info = (SnapshotInfo)objectLoader.loadObject(descFile.toURI().toURL());
                info.setFileName(snapshotFileName);
            }
            catch (Exception exception) {
                this.myLogger.error("Unable to load settings from snapshot", exception);
                info = null;
            }
        }
        return info;
    }

    private File getFile(String fileName) {
        String[] files = this.mySnapshotDirFile.list();
        if (files == null) {
            return null;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].equals(fileName)) {
                return new File(String.valueOf(this.mySnapshotDirFile.toString()) + System.getProperty("file.separator") + files[i]);
            }
            ++i;
        }
        return null;
    }

    private static class SnapshotSystemInfo
    implements SystemInfoInterface {
        private String myJava;
        private String myLocale;
        private String myCpu;
        private String myOs;
        private String myPath;
        private String myPatch;

        public SnapshotSystemInfo(SystemDescription systemInfo) {
            this.myJava = systemInfo.getJava();
            this.myLocale = systemInfo.getLocale();
            this.myCpu = systemInfo.getCpu();
            this.myOs = systemInfo.getOs();
            this.myPath = systemInfo.getPath();
            this.myPatch = systemInfo.getPatch();
        }

        @Override
        public String getOperatingSystem() {
            return this.myOs;
        }

        @Override
        public String getJre() {
            return this.myJava;
        }

        @Override
        public String getLocale() {
            return this.myLocale;
        }

        @Override
        public String getCpuString() {
            return this.myCpu;
        }

        @Override
        public String getInstallationPath() {
            return this.myPath;
        }

        @Override
        public String getPatch() {
            return this.myPatch;
        }
    }
}

