/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressEvent;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressListener;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressSource;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressTask;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleListener;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleManager;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleStatus;
import com.nokia.em.poseidon.plugin.object.ObjectRegistry;
import com.nokia.em.poseidon.plugin.operation.OperationException;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryEvent;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryListener;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.snapshot.CustomProgressHandler;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotChangeListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotFileModel;
import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListenerEvent;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceListenable;
import com.nokia.em.poseidon.services.snapshot.PTaskTimerHandler;
import com.nokia.em.poseidon.services.snapshot.cancelling.DefaultSnapshotCancellingHandler;
import com.nokia.em.poseidon.services.snapshot.cancelling.SnapshotCancellingHandler;
import com.nokia.em.poseidon.services.snapshot.cancelling.SnapshotCancellingListener;
import com.nokia.em.poseidon.services.snapshot.cancelling.SnapshotCancellingObserverManager;
import com.nokia.em.poseidon.services.snapshot.desc.SnapshotInfo;
import com.nokia.em.poseidon.services.snapshot.event.SnapshotCompletionEventListener;
import com.nokia.em.poseidon.services.snapshot.observer.manager.SnapshotSavingObserverManager;
import com.nokia.em.poseidon.services.snapshot.operations.PCopySnapshotFileOperation;
import com.nokia.em.poseidon.services.snapshot.operations.PPackSnapshotOperation;
import com.nokia.em.poseidon.services.snapshot.operations.PSnapshotCommonOperation;
import com.nokia.em.poseidon.snapshot.view.handler.CommonOperationsHandler;
import com.nokia.em.poseidon.snapshot.view.handler.DefaultProgressHandler;
import com.nokia.em.poseidon.snapshot.view.handler.ExecutionHandler;
import com.nokia.em.poseidon.snapshot.view.handler.MediatorStatusHandler;
import com.nokia.em.poseidon.snapshot.view.handler.OperationsHandler;
import com.nokia.em.poseidon.snapshot.view.handler.ProgressHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SnapshotExecutionHandler;
import com.nokia.em.poseidon.snapshot.view.handler.ThreadedExecutionHandler;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.FileWriteAccessException;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceChecker;
import com.nokia.em.poseidon.util.file.diskspace.DiskSpaceException;
import com.nokia.widgets.systeminfo.SystemInfoInterface;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.apache.log4j.Logger;

public class PSnapshotServiceImpl
implements PSnapshotServiceListenable,
PSnapshotChangeListener,
PluginRegistryListener,
PStepProgressSource,
Service,
LifecycleListener {
    protected PStepProgressTask myFinishedTask;
    protected List<PSnapshotCommonOperation> mySavingCommonTasks;
    protected boolean myLastMediatorFinishedCancel;
    private ExecutorCompletionService<Boolean> myExecutorService = new ExecutorCompletionService(new ThreadPerTaskExecutor());
    private List<PStepProgressTask> myProgressTasklist;
    private List<PStepProgressTask> myFailedProgresTasks;
    private File mySnapshotLocation;
    private String mySnapshotNotes;
    private File mySnapshotTempDir;
    private File mySnapshotTempFile;
    private boolean myCancelled = false;
    private PTaskTimerHandler myTimerHandler;
    private PSnapshotFileModel mySnapshotFileModel;
    private boolean myKeepInterruptData = false;
    private String mySaveLocation = "";
    private List<PSnapshotGuiListener> myGuiListeners;
    private Logger myLogger;
    private ResourceBundle myBundle;
    private boolean myCommonTaskExceutionStarted;
    private boolean mySnapshotOngoing;
    private Map<PSnapshotCommonOperation, PStepProgressTask> myOperationToTasks;
    protected PPackSnapshotOperation myPackingOperation;
    protected PCopySnapshotFileOperation myCopyOperation;
    private String mySnapshotLogCoverage;
    private String mySnapshotModuleCoverage;
    private List<PSaveSnapshotModules> mySnapshotModules = Collections.EMPTY_LIST;
    private String myAdditionalInfo = null;
    private boolean myRecentlyCancelled = false;
    private SnapshotExecutionHandler myExecutionHandler;
    private OperationsHandler myOperationsHandler;
    private SnapshotCancellingHandler mySnapshotCancelThreadedHandler;
    private ProgressHandler myProgressHandler;
    private MediatorStatusHandler myMediatorHandler;
    private Optional<SnapshotCompletionEventListener> myCompletionEventListener = Optional.empty();

    @Override
    public void setExecutionHandler(SnapshotExecutionHandler executionHandler) {
        this.myExecutionHandler = executionHandler;
    }

    @Override
    public void setProgressHandler(ProgressHandler progressHandler) {
        this.myProgressHandler = progressHandler;
    }

    public void setOperationsHandler(OperationsHandler operationsHandler) {
        this.myOperationsHandler = operationsHandler;
    }

    @Override
    public void start() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myBundle = I18n.getI18n().getBundle(this.getClass());
        this.initTasks();
        this.myMediatorHandler = new MediatorStatusHandler(this);
        this.setSaveLocation(PoseidonRuntime.getRuntime().getUserHome());
        this.myTimerHandler = new PTaskTimerHandler();
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).addRegistryListener(this);
        LifecycleManager.getInstance().addLifecycleListener(this);
        this.createSavingCommonTasks();
        this.myLogger.debug("Snapshot service initialized");
    }

    private void initTasks() {
        this.mySavingCommonTasks = new ArrayList<PSnapshotCommonOperation>();
        this.myProgressTasklist = new ArrayList<PStepProgressTask>();
        this.myGuiListeners = new ArrayList<PSnapshotGuiListener>();
        this.myFailedProgresTasks = Collections.synchronizedList(new ArrayList());
        this.myOperationToTasks = new HashMap<PSnapshotCommonOperation, PStepProgressTask>();
    }

    @Override
    public void stop() {
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).removeRegistryListener(this);
        this.myMediatorHandler.clearMediators(this);
        this.myTimerHandler.reset();
        this.mySavingCommonTasks.clear();
        this.myProgressTasklist.clear();
        this.myFailedProgresTasks.clear();
        this.myGuiListeners.clear();
        SnapshotSavingObserverManager.removeAll();
    }

    public void setKeepInterruptData(boolean value) {
        this.myKeepInterruptData = value;
    }

    @Override
    public void setSaveLocation(String location) {
        this.mySaveLocation = location;
    }

    @Override
    public String getSaveLocation() {
        return this.mySaveLocation;
    }

    public File getSnapshotTempDir() {
        return this.mySnapshotTempDir;
    }

    public File getSnapshotTempFile() {
        return this.mySnapshotTempFile;
    }

    public String getNotes() {
        return this.mySnapshotNotes;
    }

    public List<PSnapshotMediator> getMediators(State state) {
        List<PSnapshotMediator> mediators = this.myMediatorHandler.getMediators(state);
        return mediators;
    }

    public File getSnapshotLocation() {
        return this.mySnapshotLocation;
    }

    public void updateStepDescription(PSnapshotCommonOperation operation) {
        this.myProgressHandler.updateStepDescription(operation);
    }

    public void updateProgress(PStepProgressEvent event) {
        if (!this.myCancelled) {
            this.myProgressHandler.taskUpdated(event);
        }
    }

    protected void createSavingCommonTasks() {
        this.createCommonTasks();
        this.createFinishedTask();
    }

    private void createCommonTasks() {
        if (this.getOperationsHandler() == null) {
            this.setOperationsHandler(new CommonOperationsHandler());
        }
        this.mySavingCommonTasks.add(this.getOperationsHandler().createSaveLogOperation(this.myBundle.getString("PSaveLogOperation.Name"), this));
        this.mySavingCommonTasks.add(this.getOperationsHandler().createSavePropertiesOperation(this.myBundle.getString("PSavePropertiesOperation.Name"), this));
        this.mySavingCommonTasks.add(this.getOperationsHandler().createWriteDescOperation(this.myBundle.getString("PWriteDescOperation.Name"), this));
        this.myPackingOperation = this.getOperationsHandler().createPackSnapshotOperation(this.myBundle.getString("PPackSnapshotOperation.Name"), this);
        this.mySavingCommonTasks.add(this.myPackingOperation);
        this.myCopyOperation = this.getOperationsHandler().createCopySnapshotFileOperation(this.myBundle.getString("PCopySnapshotFileOperation.Name"), this);
        this.mySavingCommonTasks.add(this.myCopyOperation);
    }

    private void createFinishedTask() {
        this.myFinishedTask = new PStepProgressTask(this.myBundle.getString("FinishedTask.Name"), "service");
    }

    private void finalizeCancelling() {
        this.myLogger.debug("Finalizing cancel");
        if (!this.myLastMediatorFinishedCancel) {
            this.myLogger.debug("Pending mediator");
            return;
        }
        this.deleteSnapshotTemporaryData();
        this.myFinishedTask.setOperationName(this.myBundle.getString("CancelledTask.Name"));
        this.myFinishedTask.setState(PStepProgressTask.State.COMPLETED);
        this.myProgressHandler.operationCompleted(new PStepProgressEvent(this.myFinishedTask));
        this.resetDataStructures();
        this.reportOperationFinished(this.createSuccessEvent());
    }

    private void deleteSnapshotTemporaryData() {
        if (this.mySnapshotFileModel != null) {
            this.mySnapshotFileModel.clear();
            this.mySnapshotFileModel = null;
        }
        if (this.mySnapshotTempDir != null) {
            this.deleteSnapshotTemp(this.mySnapshotTempDir, "Could not delete snapshot temporary directory");
            this.mySnapshotTempDir = null;
        }
        if (this.mySnapshotTempFile != null) {
            this.deleteSnapshotTemp(this.mySnapshotTempFile, "Could not delete snapshot temporary file");
            this.mySnapshotTempFile = null;
        }
    }

    private void deleteSnapshotTemp(File snapshotTemp, String errorMsg) {
        if (snapshotTemp != null) {
            try {
                PFileUtils.delete(snapshotTemp);
            }
            catch (RuntimeException ex) {
                this.myLogger.error(errorMsg, ex);
            }
        }
    }

    @Override
    public void setCompletionEventListener(SnapshotCompletionEventListener listener) {
        this.myCompletionEventListener = Optional.ofNullable(listener);
    }

    private void reportOperationFinished(PSnapshotGuiListenerEvent event) {
        ArrayList<PSnapshotGuiListener> copyOfGuiListeners = new ArrayList<PSnapshotGuiListener>();
        copyOfGuiListeners.addAll(this.myGuiListeners);
        copyOfGuiListeners.forEach(listener -> listener.operationFinished(event));
    }

    private void reportSavingFinished() {
        if (!this.myCancelled) {
            this.reportOperationSuccessfulFinished();
        } else {
            this.reportOperationFinished(this.createSuccessEvent());
        }
    }

    private void reportOperationSuccessfulFinished() {
        List<PSnapshotMediator> failedMediators = this.getMediators(State.FAILED);
        if (failedMediators.isEmpty()) {
            this.myCompletionEventListener.ifPresent(SnapshotCompletionEventListener::updateEventSnapshotCompletedSuccessfully);
            this.reportOperationFinished(this.createSuccessEvent());
        } else {
            this.myCompletionEventListener.ifPresent(SnapshotCompletionEventListener::updateEventSnapshotCompletedPartially);
            this.reportOperationFinished(this.createFailedEvent());
        }
        this.myCompletionEventListener = Optional.empty();
    }

    private PSnapshotGuiListenerEvent createSuccessEvent() {
        return new PSnapshotGuiListenerEvent(this, PSnapshotGuiListenerEvent.Type.SUCCESS, new Object[0]);
    }

    private PSnapshotGuiListenerEvent createFailedEvent() {
        return new PSnapshotGuiListenerEvent(this, PSnapshotGuiListenerEvent.Type.MEDIATORS_FAILED_SAVING, this.getFailedSteps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFailedSteps() {
        HashMap<PSnapshotMediator, ArrayList<PStepProgressTask>> mediatorsToFailedTasks = new HashMap<PSnapshotMediator, ArrayList<PStepProgressTask>>();
        List<PStepProgressTask> list = this.myFailedProgresTasks;
        synchronized (list) {
            for (PStepProgressTask task : this.myFailedProgresTasks) {
                PSnapshotMediator mediator = this.myMediatorHandler.getMediatorUsingTask(task);
                ArrayList<PStepProgressTask> tasks = (ArrayList<PStepProgressTask>)mediatorsToFailedTasks.get(mediator);
                if (tasks == null) {
                    tasks = new ArrayList<PStepProgressTask>();
                    tasks.add(task);
                    mediatorsToFailedTasks.put(mediator, tasks);
                    continue;
                }
                tasks.add(task);
            }
        }
        StringBuilder mediatorList = new StringBuilder();
        Set failedMediators = mediatorsToFailedTasks.keySet();
        for (PSnapshotMediator mediator : failedMediators) {
            mediatorList.append(String.valueOf(mediator.getDescription().getStringProperty("elementName")) + ": \n");
            for (PStepProgressTask task : (List)mediatorsToFailedTasks.get(mediator)) {
                mediatorList.append("  - " + task.getOperationName() + "\n");
            }
        }
        return mediatorList.toString();
    }

    private void cancelTasks(List<PStepProgressTask> tasks) {
        ArrayList<PStepProgressTask> copyOfTasks = new ArrayList<PStepProgressTask>();
        copyOfTasks.addAll(tasks);
        for (PStepProgressTask task : copyOfTasks) {
            task.setState(PStepProgressTask.State.CANCELLED);
            this.myProgressHandler.taskCancelled(new PStepProgressEvent(task));
            if (task.getChildTasks() == null || task.getChildTasks().size() <= 0) continue;
            this.cancelTasks(task.getChildTasks());
        }
    }

    private void handleMediatorFinished() {
        if (!this.myCommonTaskExceutionStarted && this.myMediatorHandler.isAllMediatorFinished()) {
            this.myTimerHandler.reset();
            if (this.myCancelled && !this.myKeepInterruptData) {
                this.finalizeCancelling();
            } else {
                this.myExecutorService.submit(new CommonTaskExecutor(), Boolean.TRUE);
                this.myCommonTaskExceutionStarted = true;
            }
        }
    }

    @Override
    public List<PStepProgressTask> getSnapshotSavingProgressTasks(PSnapshotConst.SNAPSHOT_LEVEL level) {
        this.myLogger.debug("Get Snapshot saving progress tasks");
        this.resetDataStructures();
        this.myMediatorHandler.addTasksFromMediators(level, this.myProgressTasklist);
        this.addCommonTasks();
        this.addFinishedTask();
        return this.myProgressTasklist;
    }

    protected void resetDataStructures() {
        this.myLogger.debug("Resetting snapshot service");
        this.myMediatorHandler.resetMediators();
        this.myProgressTasklist.clear();
        this.myFailedProgresTasks.clear();
        this.mySnapshotLocation = null;
        this.mySnapshotNotes = null;
        this.mySnapshotTempDir = null;
        this.mySnapshotTempFile = null;
        this.myCancelled = false;
        this.myTimerHandler.reset();
        this.myCommonTaskExceutionStarted = false;
        this.mySnapshotOngoing = false;
        this.myLastMediatorFinishedCancel = false;
    }

    private void addCommonTasks() {
        this.mySavingCommonTasks.clear();
        this.createSavingCommonTasks();
        for (PSnapshotCommonOperation operation : this.mySavingCommonTasks) {
            PStepProgressTask task = new PStepProgressTask(operation.getName(), "service", operation.hashCode());
            this.myOperationToTasks.put(operation, task);
            this.myProgressTasklist.add(task);
        }
    }

    private void addFinishedTask() {
        this.myFinishedTask.setState(PStepProgressTask.State.NOT_RUNNING);
        this.myFinishedTask.setOperationName(this.myBundle.getString("FinishedTask.Name"));
        this.myProgressTasklist.add(this.myFinishedTask);
    }

    @Override
    public void saveSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes, PStepProgressListener listener, List<PSaveSnapshotModules> modules) throws MalformedURLException {
        this.mySnapshotModules = modules;
        this.mySnapshotLogCoverage = level.toString().toLowerCase().replaceAll("_", " ");
        StringBuilder builder = new StringBuilder();
        int size = modules.size();
        int i = 0;
        while (i < size) {
            builder.append(modules.get(i).getName());
            if (i < size - 1) {
                builder.append(", ");
            }
            ++i;
        }
        this.mySnapshotModuleCoverage = builder.toString();
        this.saveSnapshot(level, location, notes, listener);
    }

    @Override
    public void saveSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes, PStepProgressListener listener) throws MalformedURLException {
        this.prepareSavingSnapshot(level, location, notes, new DefaultProgressHandler(this.myOperationToTasks, listener));
        this.executeMediatorSnapshotSavers(level, this.mySnapshotTempDir);
    }

    @Override
    public void saveSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes, List<PSaveSnapshotModules> modules) throws MalformedURLException {
        this.mySnapshotModules = modules;
        this.mySnapshotLogCoverage = level.toString().toLowerCase().replaceAll("_", " ");
        StringBuilder builder = new StringBuilder();
        int size = modules.size();
        int i = 0;
        while (i < size) {
            builder.append(modules.get(i).getValue());
            if (i < size - 1) {
                builder.append(", ");
            }
            ++i;
        }
        this.mySnapshotModuleCoverage = builder.toString();
        this.prepareSavingSnapshot(level, location, notes, new CustomProgressHandler(this.myOperationToTasks));
        this.executeMediatorSnapshotSavers(level, this.mySnapshotTempDir);
    }

    @Override
    public void saveSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes) throws MalformedURLException {
        this.mySnapshotModules.clear();
        this.mySnapshotModuleCoverage = "";
        this.prepareSavingSnapshot(level, location, notes, new CustomProgressHandler(this.myOperationToTasks));
        this.executeMediatorSnapshotSavers(level, this.mySnapshotTempDir);
    }

    private void prepareSavingSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes, ProgressHandler progressHandler) {
        File snapshotTempDir;
        this.myProgressHandler = progressHandler;
        this.myProgressHandler.setProgressTasks(this.getSnapshotSavingProgressTasks(level));
        this.myLogger.debug("Save Snapshot requested level: " + (Object)((Object)level) + " location: " + location);
        this.myRecentlyCancelled = false;
        this.mySnapshotLocation = location;
        this.mySnapshotNotes = notes;
        this.mySnapshotTempDir = snapshotTempDir = PFileUtils.createTempDir("SnapshotTemp");
        this.mySnapshotOngoing = true;
        this.mySnapshotTempFile = new File(String.valueOf(snapshotTempDir.getAbsolutePath()) + ".zip");
    }

    private void executeMediatorSnapshotSavers(PSnapshotConst.SNAPSHOT_LEVEL level, File snapshotTempDir) throws MalformedURLException {
        if (this.myExecutionHandler == null) {
            this.myExecutionHandler = new ThreadedExecutionHandler(this.myMediatorHandler, this.myExecutorService);
        }
        this.myExecutionHandler.execute(level, snapshotTempDir);
    }

    @Override
    public long getSnapshotOpeningTimeout() {
        return 30L;
    }

    @Override
    public Map<String, URL> openSnapshot(URL snapshotFileUrl) throws IOException {
        File snapshotTempDir;
        this.myLogger.debug("Open Snapshot called, URL: " + snapshotFileUrl);
        this.deleteSnapshotTemporaryData();
        this.mySnapshotTempDir = snapshotTempDir = PFileUtils.createTempDir("SnapshotTemp");
        File snapshotFileRootDir = null;
        if (!this.myCancelled) {
            try {
                snapshotFileRootDir = PFileUtils.unZip(new File(snapshotFileUrl.toURI()), this.mySnapshotTempDir);
            }
            catch (Exception e) {
                snapshotFileRootDir = PFileUtils.unZip(new File(snapshotFileUrl.getFile()), this.mySnapshotTempDir);
            }
        }
        if (!this.myCancelled) {
            this.mySnapshotFileModel = new PSnapshotFileModel(snapshotFileRootDir, new File(snapshotFileUrl.getFile()).getName());
        }
        return this.mySnapshotFileModel.getMediatorURLs();
    }

    @Override
    public SnapshotInfo getSnapshotInfo() {
        if (this.mySnapshotFileModel != null) {
            return this.mySnapshotFileModel.getSnapshotInfo();
        }
        return null;
    }

    @Override
    public PSettings getSnapshotSettings() {
        if (this.mySnapshotFileModel != null) {
            return this.mySnapshotFileModel.getSettings();
        }
        return null;
    }

    @Override
    public SystemInfoInterface getSnapshotSystemInfo() {
        if (this.mySnapshotFileModel != null) {
            return this.mySnapshotFileModel.getSystemInformation();
        }
        return null;
    }

    @Override
    public void addGuiListener(PSnapshotGuiListener listener) {
        this.myLogger.debug("Added Gui Listener, listener: " + listener);
        this.myGuiListeners.add(listener);
    }

    @Override
    public void removeGuiListener(PSnapshotGuiListener listener) {
        this.myLogger.debug("Removed Gui Listener, listener: " + listener);
        this.myGuiListeners.remove(listener);
    }

    @Override
    public boolean isDataKeptInInterrupt() {
        return this.myKeepInterruptData;
    }

    @Override
    public synchronized void taskStarted(PStepProgressEvent event, int timeout) {
        PSnapshotMediator mediator = this.myMediatorHandler.getMediatorUsingTask(event.getUpdatedTask());
        State stateOfMediator = this.myMediatorHandler.getStateOfMediator(mediator);
        boolean isMediatorFailedState = State.FAILED.equals((Object)stateOfMediator);
        if (isMediatorFailedState || State.FAILED_DISK_FULL.equals((Object)stateOfMediator)) {
            this.myMediatorHandler.setMediatorState(mediator, State.RUNNING_WITH_ERRORS);
        }
        this.updateProgress(event);
        if (!this.myCancelled && mediator != null) {
            this.myTimerHandler.createNewTimer(mediator, event, timeout, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void taskUpdated(PStepProgressEvent event) {
        boolean isStepFailedState;
        PSnapshotMediator mediator = this.myMediatorHandler.getMediatorUsingTask(event.getUpdatedTask());
        boolean isStepDiskIsFullState = event.getUpdatedTask().getState() == PStepProgressTask.State.FAILED_DISK_FULL || State.FAILED_DISK_FULL.equals((Object)this.myMediatorHandler.getStateOfMediator(mediator));
        boolean bl = isStepFailedState = event.getUpdatedTask().getState() == PStepProgressTask.State.FAILED || State.FAILED.equals((Object)this.myMediatorHandler.getStateOfMediator(mediator));
        if (isStepDiskIsFullState || isStepFailedState) {
            this.myMediatorHandler.setMediatorState(mediator, State.RUNNING_WITH_ERRORS);
            List<PStepProgressTask> list = this.myFailedProgresTasks;
            synchronized (list) {
                if (!this.myFailedProgresTasks.contains(event.getUpdatedTask())) {
                    this.myFailedProgresTasks.add(event.getUpdatedTask());
                }
            }
        }
        this.myTimerHandler.updateProgressTimerTasks(event);
        this.updateProgress(event);
    }

    @Override
    public synchronized void savingCompleted(PSnapshotMediator source) {
        this.myLogger.debug("Service Saving completed, source: " + source);
        State state = this.myMediatorHandler.getStateOfMediator(source);
        if (State.RUNNING_WITH_ERRORS.equals((Object)state) || State.RUNNING_WITH_DISK_FULL.equals((Object)state)) {
            this.myMediatorHandler.setMediatorState(source, State.FAILED);
        } else {
            this.myMediatorHandler.setMediatorState(source, State.COMPLETED);
        }
        this.myTimerHandler.stopTimersFor(source);
        this.handleMediatorFinished();
    }

    @Override
    public synchronized void savingCancelled(PSnapshotMediator source) {
        this.myLogger.debug("Saving cancelled, source: " + source);
        this.myMediatorHandler.setMediatorState(source, State.CANCELLED);
        this.myTimerHandler.stopTimersFor(source);
        this.handleMediatorFinished();
    }

    @Override
    public synchronized void savingFailed(PSnapshotMediator source) {
        this.myLogger.debug("Saving failed, source: " + source);
        for (PStepProgressTask task : this.myProgressTasklist) {
            if (!source.equals(this.myMediatorHandler.getMediatorUsingTask(task))) continue;
            task.setState(PStepProgressTask.State.FAILED);
            this.updateProgress(new PStepProgressEvent(task));
        }
        this.myTimerHandler.stopTimersFor(source);
        this.myMediatorHandler.setMediatorState(source, State.FAILED);
        this.handleMediatorFinished();
    }

    @Override
    public void itemAdded(PluginRegistryEvent event) {
        this.myMediatorHandler.add(event, this);
    }

    @Override
    public void itemRemoved(PluginRegistryEvent event) {
        this.myMediatorHandler.remove(event);
    }

    @Override
    public void lifecycleUpdated(LifecycleStatus event) {
        if (LifecycleStatus.CLOSING.equals((Object)event)) {
            this.deleteSnapshotTemporaryData();
        }
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public boolean isCancellable() {
        return !this.myRecentlyCancelled;
    }

    @Override
    public boolean cancel() {
        DefaultSnapshotCancellingHandler defaultCancellingHandler = new DefaultSnapshotCancellingHandler(this.myGuiListeners, this.myMediatorHandler, new SnapshotCancellingObserverManager());
        return this.cancel(defaultCancellingHandler, defaultCancellingHandler);
    }

    public boolean cancel(SnapshotCancellingHandler cancellingHandler, ExecutionHandler executionHandler) {
        this.myLogger.debug("Save snapshot cancelled");
        if (this.myCancelled) {
            return true;
        }
        this.cancelTasks(this.myProgressTasklist);
        if (this.myPackingOperation != null) {
            this.myPackingOperation.cancel();
        }
        if (this.myCopyOperation != null) {
            this.myCopyOperation.cancel();
        }
        if (this.myKeepInterruptData) {
            this.myFinishedTask.setOperationName(this.myBundle.getString("StoppingTask.Name"));
        } else {
            this.myFinishedTask.setOperationName(this.myBundle.getString("CancellingTask.Name"));
        }
        this.myFinishedTask.setState(PStepProgressTask.State.STARTED);
        this.myProgressHandler.taskStarted(new PStepProgressEvent(this.myFinishedTask));
        this.myRecentlyCancelled = true;
        this.myCancelled = true;
        this.mySnapshotCancelThreadedHandler = cancellingHandler;
        SnapshotCancellingObserverManager cancellingSubject = this.mySnapshotCancelThreadedHandler.getCancellingSubject();
        cancellingSubject.addListener(new SnapshotServiceCancellingListener());
        try {
            executionHandler.execute();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotOngoing() {
        return this.mySnapshotOngoing;
    }

    public String getSnapshotLogCoverage() {
        return this.mySnapshotLogCoverage;
    }

    public String getSnapshotModuleCoverage() {
        return this.mySnapshotModuleCoverage;
    }

    public List<String> getSnapshotModules() {
        ArrayList<String> modules = new ArrayList<String>();
        if (this.mySnapshotModules != null) {
            for (PSaveSnapshotModules module : this.mySnapshotModules) {
                modules.add(module.getValue());
            }
        }
        return modules;
    }

    @Override
    public String getAdditionalInfo() {
        return this.myAdditionalInfo;
    }

    @Override
    public void setAdditionalInfo(String addInfo) {
        this.myAdditionalInfo = addInfo;
    }

    public OperationsHandler getOperationsHandler() {
        return this.myOperationsHandler;
    }

    private class CommonTaskExecutor
    implements Runnable {
        private CommonTaskExecutor() {
        }

        private void updateTask(int taskID, PStepProgressTask.State state) {
            PStepProgressTask foundTask = this.findTask(taskID);
            if (foundTask != null && !PSnapshotServiceImpl.this.myCancelled) {
                foundTask.setState(state);
                PSnapshotServiceImpl.this.updateProgress(new PStepProgressEvent(foundTask));
            }
        }

        private PStepProgressTask findTask(int taskID) {
            for (PStepProgressTask task : PSnapshotServiceImpl.this.myProgressTasklist) {
                if (task.getID() != taskID) continue;
                return task;
            }
            return null;
        }

        @Override
        public void run() {
            PSnapshotServiceImpl.this.myLogger.debug("Starting the common tasks execution");
            for (PSnapshotCommonOperation operation : PSnapshotServiceImpl.this.mySavingCommonTasks) {
                PSnapshotServiceImpl.this.myLogger.debug("Starting common task: " + operation.getName());
                this.updateTask(operation.hashCode(), PStepProgressTask.State.STARTED);
                try {
                    if (PSnapshotServiceImpl.this.myCancelled && !PSnapshotServiceImpl.this.myKeepInterruptData) {
                        PSnapshotServiceImpl.this.finalizeCancelling();
                        return;
                    }
                    operation.invoke();
                    this.updateTask(operation.hashCode(), PStepProgressTask.State.COMPLETED);
                    PSnapshotServiceImpl.this.myLogger.debug("Common task: " + operation.getName() + " finished succesfully");
                }
                catch (OperationException operationException) {
                    this.deleteSnapshotTempFiles();
                    PSnapshotServiceImpl.this.myLogger.error("Common task: " + operation.getName() + " failed , ending snapshot saving.", operationException);
                    this.updateTask(operation.hashCode(), PStepProgressTask.State.FAILED);
                    PSnapshotServiceImpl.this.myProgressHandler.operationCompleted(new PStepProgressEvent(this.findTask(operation.hashCode())));
                    this.reportFailedOperation(operation, operationException);
                    PSnapshotServiceImpl.this.resetDataStructures();
                    return;
                }
            }
            this.deleteSnapshotTempFiles();
            if (PSnapshotServiceImpl.this.myCancelled && !PSnapshotServiceImpl.this.myKeepInterruptData) {
                PSnapshotServiceImpl.this.finalizeCancelling();
                return;
            }
            if (PSnapshotServiceImpl.this.myCancelled) {
                PSnapshotServiceImpl.this.myFinishedTask.setOperationName(PSnapshotServiceImpl.this.myBundle.getString("StoppedTask.Name"));
            } else {
                PSnapshotServiceImpl.this.myFinishedTask.setOperationName(PSnapshotServiceImpl.this.myBundle.getString("FinishedTask.Name"));
            }
            PSnapshotServiceImpl.this.myFinishedTask.setState(PStepProgressTask.State.COMPLETED);
            PSnapshotServiceImpl.this.myProgressHandler.operationCompleted(new PStepProgressEvent(PSnapshotServiceImpl.this.myFinishedTask));
            PSnapshotServiceImpl.this.reportSavingFinished();
            PSnapshotServiceImpl.this.resetDataStructures();
        }

        private void reportFailedOperation(PSnapshotCommonOperation operation, OperationException operationException) {
            DiskSpaceChecker checker = new DiskSpaceChecker.Builder(operationException).build();
            PSnapshotGuiListenerEvent failedEvent = null;
            String additionalDetails = null;
            Throwable cause = checker.getCause();
            if (operation instanceof PCopySnapshotFileOperation) {
                if (cause instanceof DiskSpaceException) {
                    additionalDetails = PSnapshotServiceImpl.this.getSnapshotLocation().getAbsolutePath();
                } else if (this.getRootCause(cause) instanceof FileWriteAccessException) {
                    additionalDetails = PSnapshotServiceImpl.this.getSnapshotLocation().getAbsolutePath();
                    cause = this.getRootCause(cause);
                }
                failedEvent = new PSnapshotGuiListenerEvent(this, PSnapshotGuiListenerEvent.Type.SNAPSHOT_COPYING_FAILED, additionalDetails, cause);
            } else {
                if (cause instanceof DiskSpaceException) {
                    additionalDetails = PSnapshotServiceImpl.this.getSnapshotTempDir().getAbsolutePath();
                }
                failedEvent = new PSnapshotGuiListenerEvent(this, PSnapshotGuiListenerEvent.Type.SNAPSHOT_SAVING_FAILED, additionalDetails);
            }
            PSnapshotServiceImpl.this.reportOperationFinished(failedEvent);
        }

        private Throwable getRootCause(Throwable cause) {
            if (cause.getCause() != null) {
                return this.getRootCause(cause.getCause());
            }
            return cause;
        }

        private void deleteSnapshotTempFiles() {
            PSnapshotServiceImpl.this.deleteSnapshotTemp(PSnapshotServiceImpl.this.getSnapshotTempDir(), "Failed to delete snapshot temporary directory: ");
            PSnapshotServiceImpl.this.deleteSnapshotTemp(PSnapshotServiceImpl.this.getSnapshotTempFile(), "Failed to delete snapshot temporary file: ");
            System.gc();
        }
    }

    private class SnapshotServiceCancellingListener
    implements SnapshotCancellingListener {
        private SnapshotServiceCancellingListener() {
        }

        @Override
        public void handleCancelling() {
            PSnapshotServiceImpl.this.myLastMediatorFinishedCancel = true;
            PSnapshotServiceImpl.this.mySnapshotOngoing = false;
            PSnapshotServiceImpl.this.finalizeCancelling();
            if (PSnapshotServiceImpl.this.mySnapshotCancelThreadedHandler != null && PSnapshotServiceImpl.this.mySnapshotCancelThreadedHandler.getCancellingSubject() != null) {
                PSnapshotServiceImpl.this.mySnapshotCancelThreadedHandler.getCancellingSubject().removeAllListeners();
            }
        }
    }

    public static enum State {
        FAILED,
        COMPLETED,
        CANCELLED,
        RUNNING,
        RUNNING_WITH_ERRORS,
        RUNNING_WITH_DISK_FULL,
        FAILED_DISK_FULL;

    }

    private static class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

