/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot;

import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressEvent;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressTask;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.snapshot.operations.StillAliveChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class PTaskTimerHandler {
    private List<TimeOutTimerTask> myTimerTasks = Collections.synchronizedList(new ArrayList());
    private Logger myLogger;
    private Timer myTimer = new Timer();

    public PTaskTimerHandler() {
        this.myLogger = Logger.getLogger(this.getClass());
    }

    public void createNewTimer(PSnapshotMediator mediator, PStepProgressEvent event, int timeOut, PSnapshotServiceImpl service) {
        TimeOutTimerTask timeOutTimerTask = new TimeOutTimerTask(mediator, event, service, timeOut);
        this.myTimerTasks.add(timeOutTimerTask);
        this.myTimer.scheduleAtFixedRate((TimerTask)timeOutTimerTask, timeOut, (long)timeOut);
        this.myLogger.debug("Scheduled a timer for task: " + event.getOperation() + " Timeout is: " + timeOut + " Owner is: " + event.getUpdatedTask().getOwner());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimersFor(PSnapshotMediator mediator) {
        List<TimeOutTimerTask> list = this.myTimerTasks;
        synchronized (list) {
            ListIterator<TimeOutTimerTask> iter = this.myTimerTasks.listIterator();
            while (iter.hasNext()) {
                TimeOutTimerTask timerTask = iter.next();
                if (!timerTask.getMediator().equals(mediator)) continue;
                timerTask.cancel();
                iter.remove();
            }
        }
        this.myLogger.debug("Stopped all task timers for mediator: " + mediator.getDescription().getStringProperty("publicName"));
    }

    public void reset() {
        this.myTimer.cancel();
        this.myTimer = new Timer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgressTimerTasks(PStepProgressEvent event) {
        List<TimeOutTimerTask> list = this.myTimerTasks;
        synchronized (list) {
            ListIterator<TimeOutTimerTask> iter = this.myTimerTasks.listIterator();
            while (iter.hasNext()) {
                TimeOutTimerTask timerTask = iter.next();
                if (timerTask.getTaskId() != event.getUpdatedTask().getID()) continue;
                timerTask.cancel();
                iter.remove();
                if (event.getUpdatedTask().getState() == PStepProgressTask.State.STARTED) {
                    this.myLogger.debug("Step started called for running task, owner is: " + event.getUpdatedTask().getOwner() + " taskname is: " + event.getOperation());
                    this.createNewTimer(timerTask.getMediator(), event, timerTask.getTimeout(), timerTask.getService());
                } else if (event.getUpdatedTask().getState() == PStepProgressTask.State.NOT_RUNNING) {
                    this.myLogger.debug("Step not running cancelling timer for: " + event.getOperation());
                } else if (event.getUpdatedTask().getState() == PStepProgressTask.State.CANCELLED) {
                    this.myLogger.debug("Step cancelled cancelling timer for: " + event.getOperation());
                } else if (event.getUpdatedTask().getState() == PStepProgressTask.State.TIMEOUT) {
                    this.myLogger.debug("Step timeout cancelling timer for: " + event.getOperation());
                } else if (event.getUpdatedTask().getState() == PStepProgressTask.State.FAILED) {
                    this.myLogger.debug("Step failed cancelling timer for: " + event.getOperation());
                } else if (event.getUpdatedTask().getState() == PStepProgressTask.State.FAILED_DISK_FULL) {
                    this.myLogger.debug("Step failed cancelling timer for: " + event.getOperation());
                } else if (event.getUpdatedTask().getState() == PStepProgressTask.State.COMPLETED) {
                    this.myLogger.debug("Step completed cancelling timer for: " + event.getOperation());
                }
                return;
            }
            this.myLogger.error("Did not update timer task, received a progress event from unkonwn owner or with unknowntaskname. Owner: " + event.getUpdatedTask().getOwner() + " taskname " + event.getOperation() + ". Event state " + (Object)((Object)event.getUpdatedTask().getState()));
        }
    }

    private class TimeOutTimerTask
    extends TimerTask {
        private PSnapshotMediator myMediator;
        private PStepProgressEvent myEvent;
        private PSnapshotServiceImpl myService;
        private ExecutorService myExecutorService = Executors.newCachedThreadPool();
        private int myTimeout;

        public TimeOutTimerTask(PSnapshotMediator mediator, PStepProgressEvent event, PSnapshotServiceImpl service, int timeout) {
            this.myMediator = mediator;
            this.myEvent = event;
            this.myService = service;
            this.myTimeout = timeout;
        }

        @Override
        public void run() {
            Future future = this.myExecutorService.submit(new StillAliveChecker(this.myMediator));
            try {
                if (future.get(1000L, TimeUnit.MILLISECONDS).equals(Boolean.TRUE)) {
                    PTaskTimerHandler.this.myLogger.debug("Mediator: " + this.myMediator.getDescription().getStringProperty("internalName") + " returned ok. The task that was over time is: " + this.myEvent.getOperation());
                    return;
                }
                PTaskTimerHandler.this.myLogger.debug("Mediator: " + this.myMediator.getDescription().getStringProperty("internalName") + " returned  NOT OK. The task that was over time is: " + this.myEvent.getOperation());
            }
            catch (TimeoutException exception) {
                PTaskTimerHandler.this.myLogger.error("SnapshotMediator did not respond on the stillAlive query on time, mediator: " + this.myMediator.getDescription().getStringProperty("internalName") + ": " + this.myEvent.getOperation());
            }
            catch (Exception exception) {
                PTaskTimerHandler.this.myLogger.error("Could not finish the SnapshotMediator stillAlive query", exception);
            }
            this.myEvent.getUpdatedTask().setState(PStepProgressTask.State.TIMEOUT);
            this.myService.updateProgress(this.myEvent);
            this.cancel();
            PTaskTimerHandler.this.myTimerTasks.remove(this);
            this.myService.savingFailed(this.myMediator);
        }

        public int getTaskId() {
            return this.myEvent.getUpdatedTask().getID();
        }

        public PSnapshotMediator getMediator() {
            return this.myMediator;
        }

        public int getTimeout() {
            return this.myTimeout;
        }

        public PSnapshotServiceImpl getService() {
            return this.myService;
        }
    }
}

