/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot.cancelling;

import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListenerEvent;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.snapshot.cancelling.SnapshotCancellingHandler;
import com.nokia.em.poseidon.services.snapshot.cancelling.SnapshotCancellingObserverManager;
import com.nokia.em.poseidon.services.snapshot.operations.Canceller;
import com.nokia.em.poseidon.snapshot.view.handler.ExecutionHandler;
import com.nokia.em.poseidon.snapshot.view.handler.MediatorStatusHandler;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class DefaultSnapshotCancellingHandler
implements SnapshotCancellingHandler,
ExecutionHandler {
    private Logger myLogger;
    private List<PSnapshotGuiListener> myGuiListeners;
    private MediatorStatusHandler myMediatorHandler;
    private ExecutorCompletionService<Boolean> myCancelExecutorService = new ExecutorCompletionService(new ThreadPerTaskExecutor());
    private SnapshotCancellingObserverManager myCancellingSubject;

    public DefaultSnapshotCancellingHandler(List<PSnapshotGuiListener> guiListeners, MediatorStatusHandler mediatorHandler, SnapshotCancellingObserverManager cancelSubject) {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myGuiListeners = guiListeners;
        this.myCancellingSubject = cancelSubject;
        this.myMediatorHandler = mediatorHandler;
    }

    @Override
    public void execute() throws MalformedURLException {
        new Thread(this::executeCancelling).start();
    }

    @Override
    public SnapshotCancellingObserverManager getCancellingSubject() {
        return this.myCancellingSubject;
    }

    private void executeCancelling() {
        ArrayList<Future<Boolean>> myCancellingJobs = new ArrayList<Future<Boolean>>();
        this.operationStart();
        Iterator iter = this.myMediatorHandler.getMediatorIterator();
        while (iter.hasNext()) {
            PSnapshotMediator mediator = (PSnapshotMediator)iter.next();
            if (PSnapshotServiceImpl.State.COMPLETED.equals((Object)this.myMediatorHandler.getStateOfMediator(mediator)) || PSnapshotServiceImpl.State.FAILED.equals((Object)this.myMediatorHandler.getStateOfMediator(mediator))) continue;
            this.myLogger.debug("Calling cancel for mediator in state: " + (Object)((Object)this.myMediatorHandler.getStateOfMediator(mediator)));
            myCancellingJobs.add(this.myCancelExecutorService.submit(new Canceller(mediator)));
        }
        this.myLogger.debug("Waiting for all mediators to be cancelled");
        this.waitUntilMediatorsCancelled(myCancellingJobs);
        this.myCancellingSubject.notifyListeners();
    }

    private void waitUntilMediatorsCancelled(List<Future<Boolean>> futures) {
        int i = 0;
        while (i < futures.size()) {
            try {
                Future<Boolean> fut = this.myCancelExecutorService.take();
                fut.get(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.myLogger.debug("Snapshot future interrupted while waiting: ", e);
            }
            catch (ExecutionException e) {
                this.myLogger.debug("Snapshot future encountered execution exception while waiting: ", e);
            }
            catch (TimeoutException e) {
                this.myLogger.debug("Snapshot future time out reached: ", e);
            }
            ++i;
        }
    }

    private void operationStart() {
        if (this.myGuiListeners == null) {
            return;
        }
        ArrayList<PSnapshotGuiListener> copyOfGuiListeners = new ArrayList<PSnapshotGuiListener>();
        copyOfGuiListeners.addAll(this.myGuiListeners);
        for (PSnapshotGuiListener listener : copyOfGuiListeners) {
            listener.operationStarted(new PSnapshotGuiListenerEvent(this, PSnapshotGuiListenerEvent.Type.SNAPSHOT_SAVING_FAILED, new Object[0]));
        }
    }

    private static class ThreadPerTaskExecutor
    implements Executor {
        private ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

