/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot.observer.manager;

import com.nokia.em.poseidon.services.snapshot.event.SaveSnapshotServiceEvent;
import com.nokia.em.poseidon.services.snapshot.listener.SaveSnapshotServiceListener;
import java.util.ArrayList;
import java.util.List;

public final class SnapshotSavingObserverManager {
    private static List<SaveSnapshotServiceListener> listeners;

    public static void addListener(SaveSnapshotServiceListener listener) {
        if (listeners == null) {
            listeners = new ArrayList<SaveSnapshotServiceListener>();
        }
        listeners.add(listener);
    }

    public static void removeAll() {
        if (listeners != null) {
            listeners.clear();
        }
    }

    public static void notifyListeners(SaveSnapshotServiceEvent state) {
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        ArrayList<SaveSnapshotServiceListener> copyOfListeners = new ArrayList<SaveSnapshotServiceListener>(listeners);
        for (SaveSnapshotServiceListener listener : copyOfListeners) {
            if (state.getState().equals((Object)SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.UPDATE_TASK)) {
                listener.handleUpdateTasks(state.getData());
                continue;
            }
            if (state.getState().equals((Object)SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.CANCEL)) {
                listener.handleCancel(state.getData());
                continue;
            }
            if (state.getState().equals((Object)SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.OPERATION_COMPLETED)) {
                listener.handleCompleted(state.getData());
                continue;
            }
            if (state.getState().equals((Object)SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.STARTED)) {
                listener.handleStarted(state.getData());
                continue;
            }
            if (state.getState().equals((Object)SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.FAILED)) {
                listener.handleFailed(state.getData());
                continue;
            }
            if (state.getState().equals((Object)SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.UPDATE_PROGRESS)) {
                listener.handleUpdateProgress(state.getData());
                continue;
            }
            if (!state.getState().equals((Object)SaveSnapshotServiceEvent.SAVE_SNAPSHOT_EVENT_STATE.UPDATE_DESCRIPTION)) continue;
            listener.handleUpdateDescription(state.getData());
        }
    }
}

