/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot.operations;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.plugin.operation.OperationException;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.snapshot.operations.PSnapshotCommonOperation;
import com.nokia.em.poseidon.util.file.CopyFileProgressListener;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.log4j.Logger;

public class PCopySnapshotFileOperation
implements PSnapshotCommonOperation,
CopyFileProgressListener {
    private String myOperationName;
    private PSnapshotServiceImpl myService;
    private ResourceBundle myRB;
    private Long mySourceSize = 0L;
    private Long myDestinationSize = 0L;
    private File myDestination;
    private static final int UPDATE_INTERVAL = 1000;
    private Object myAbortLock = new Object();
    private boolean myAbort = false;
    private Logger myLogger;
    private Exception myOperationError = null;

    public PCopySnapshotFileOperation(String operationName, PSnapshotServiceImpl service) {
        this.myOperationName = operationName;
        this.myService = service;
        this.myRB = I18n.getI18n().getBundle(this.getClass());
        this.myLogger = Logger.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invoke() throws OperationException {
        try {
            this.mySourceSize = this.myService.getSnapshotTempFile().length();
            this.myDestination = this.myService.getSnapshotLocation();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PFileUtils.copyFile(PCopySnapshotFileOperation.this.myService.getSnapshotLocation(), PCopySnapshotFileOperation.this.myService.getSnapshotTempFile(), PCopySnapshotFileOperation.this, 1000);
                    }
                    catch (Exception e) {
                        PCopySnapshotFileOperation.this.myLogger.error("Failed to copy the snapshot", e);
                    }
                }
            }).start();
            Object object = this.myAbortLock;
            synchronized (object) {
                while (!this.myAbort) {
                    try {
                        this.myAbortLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.myOperationError == null) return;
            throw new Exception(this.myOperationError);
        }
        catch (Exception exception) {
            this.myLogger.error("Failed to get the total size of the snapshot file", exception);
            this.deleteSnapshotFile();
            throw new OperationException("Failed to copy the snapshot", exception);
        }
    }

    public void setName(String name) {
        this.myOperationName = name;
    }

    @Override
    public String getName() {
        return String.valueOf(this.myOperationName) + " " + this.getAdditionalInfo();
    }

    private String getAdditionalInfo() {
        Object[] texts = new Object[]{this.myDestinationSize / 1024L, this.mySourceSize / 1024L};
        return MessageFormat.format(this.myRB.getString("PCopySnapshotFileOperation.AdditionalInfo"), texts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFileCompleted(long copiedSize) {
        if (!this.myAbort) {
            this.myDestinationSize = copiedSize;
            this.myService.updateStepDescription(this);
            Object object = this.myAbortLock;
            synchronized (object) {
                this.myAbort = true;
                this.myAbortLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFileFailed(long copiedSize, Exception ex) {
        this.myDestinationSize = copiedSize;
        this.myService.updateStepDescription(this);
        this.myOperationError = ex;
        Object object = this.myAbortLock;
        synchronized (object) {
            this.myAbort = true;
            this.myAbortLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFileUpdated(long copiedSize) {
        Object object = this.myAbortLock;
        synchronized (object) {
            if (this.myAbort) {
                return;
            }
        }
        this.myDestinationSize = copiedSize;
        this.myService.updateStepDescription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAbortCopyFile() {
        Object object = this.myAbortLock;
        synchronized (object) {
            return this.myAbort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.myAbortLock;
        synchronized (object) {
            this.myAbort = true;
            this.deleteSnapshotFile();
        }
    }

    private void deleteSnapshotFile() {
        try {
            Optional.ofNullable(this.myDestination).ifPresent(PFileUtils::delete);
        }
        catch (RuntimeException ex) {
            this.myLogger.error("Failed to delete snapshot file: ", ex);
        }
    }
}

