/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot.operations;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.plugin.operation.OperationException;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.snapshot.operations.PSnapshotCommonOperation;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.em.poseidon.util.file.ZippingProgressListener;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class PPackSnapshotOperation
implements PSnapshotCommonOperation,
ZippingProgressListener {
    private String myOperationName;
    private PSnapshotServiceImpl myService;
    private ResourceBundle myRB;
    private Long myTotalSize = 0L;
    private Long myPackedSize = 0L;
    private static int UPDATE_INTERVAL = 1000;
    private Object myAbortLock = new Object();
    private volatile boolean myAbort = false;
    private Logger myLogger;
    private Exception myOperationError = null;

    public PPackSnapshotOperation(String operationName, PSnapshotServiceImpl service) {
        this.myOperationName = operationName;
        this.myService = service;
        this.myRB = I18n.getI18n().getBundle(this.getClass());
        this.myLogger = Logger.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invoke() throws OperationException {
        try {
            this.myTotalSize = PFileUtils.getFileSize(this.myService.getSnapshotTempDir());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PFileUtils.zip(PPackSnapshotOperation.this.myService.getSnapshotTempFile(), PPackSnapshotOperation.this.myService.getSnapshotTempDir(), PPackSnapshotOperation.this, UPDATE_INTERVAL);
                    }
                    catch (Exception e) {
                        PPackSnapshotOperation.this.myLogger.error("Failed to zip the snapshot", e);
                    }
                }
            }).start();
            Object object = this.myAbortLock;
            synchronized (object) {
                while (!this.myAbort) {
                    try {
                        this.myAbortLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.myOperationError == null) return;
            throw new Exception(this.myOperationError);
        }
        catch (Exception exception) {
            this.myLogger.error("Failed to get the total size of the snapshot file", exception);
            throw new OperationException("Failed to zip the snapshot", exception);
        }
    }

    public void setName(String name) {
        this.myOperationName = name;
    }

    @Override
    public String getName() {
        return String.valueOf(this.myOperationName) + " " + this.getAdditionalInfo();
    }

    private String getAdditionalInfo() {
        Object[] texts = new Object[]{this.myPackedSize / 1024L, this.myTotalSize / 1024L};
        return MessageFormat.format(this.myRB.getString("PPackSanpshotOperation.AdditionalInfo"), texts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zippingCompleted(long zippedSize) {
        this.myPackedSize = zippedSize;
        this.myService.updateStepDescription(this);
        Object object = this.myAbortLock;
        synchronized (object) {
            this.myAbort = true;
            this.myAbortLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zippingFailed(long zippedSize, Exception ex) {
        this.myPackedSize = zippedSize;
        this.myService.updateStepDescription(this);
        this.myOperationError = ex;
        Object object = this.myAbortLock;
        synchronized (object) {
            this.myAbort = true;
            this.myAbortLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zippingUpdated(long zippedSize) {
        Object object = this.myAbortLock;
        synchronized (object) {
            if (this.myAbort) {
                return;
            }
        }
        this.myPackedSize = zippedSize;
        this.myService.updateStepDescription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.myAbortLock;
        synchronized (object) {
            this.myAbort = true;
        }
    }
}

