/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot.operations;

import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.snapshot.operations.PSnapshotCommonOperation;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.em.poseidon.util.logging.TruncatingFileAppender;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;

public class PSaveLogOperation
implements PSnapshotCommonOperation {
    private String myOperationName;
    private PSnapshotServiceImpl myService;
    private Logger myLogger;
    private static String LOG_FOLDER_NAME = "logs";

    public PSaveLogOperation(String operationName, PSnapshotServiceImpl service) {
        this.myOperationName = operationName;
        this.myService = service;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    @Override
    public void invoke() {
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            String logFileName;
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender) || (logFileName = ((FileAppender)appender).getFile()) == null || "".equals(logFileName)) continue;
            try {
                File logInSnapshot = new File(this.myService.getSnapshotTempDir(), String.valueOf(LOG_FOLDER_NAME) + File.separator + new File(logFileName).getName());
                if (!logInSnapshot.getParentFile().mkdirs()) {
                    this.myLogger.trace("Cannot create folder for log files (folder may exists already).");
                }
                File originalLogFile = new File(logFileName);
                PFileUtils.copyFile(logInSnapshot, originalLogFile);
                if (!logInSnapshot.setLastModified(originalLogFile.lastModified())) {
                    this.myLogger.trace("Cannot set lastModified date to snapshot log file.");
                }
            }
            catch (Exception exception) {
                this.myLogger.error("Unable to copy log file to snapshot", exception);
            }
            if (!(appender instanceof TruncatingFileAppender)) continue;
            String backupLogFilename = logFileName;
            int index = backupLogFilename.lastIndexOf(".");
            if (index != -1) {
                backupLogFilename = backupLogFilename.substring(0, index);
            }
            this.getAllBackupFiles(backupLogFilename, (TruncatingFileAppender)appender);
        }
    }

    private void getAllBackupFiles(String logFileName, TruncatingFileAppender appender) {
        int maxBackupFiles = appender.getMaxBackupIndex();
        int i = 1;
        while (i <= maxBackupFiles) {
            String tempBackupFileName = appender.createBackupFilePathname(logFileName, i);
            File backupFile = new File(tempBackupFileName);
            if (!backupFile.exists() || backupFile.length() <= 0L) break;
            try {
                File snapshotFile = new File(this.myService.getSnapshotTempDir(), String.valueOf(LOG_FOLDER_NAME) + File.separator + new File(tempBackupFileName).getName());
                if (!snapshotFile.getParentFile().mkdirs()) {
                    this.myLogger.trace("Cannot create folder for backup log files (folder may exists already).");
                }
                PFileUtils.copyFile(snapshotFile, backupFile);
                if (!snapshotFile.setLastModified(backupFile.lastModified())) {
                    this.myLogger.trace("Cannot set last modified date for snapshot log files.");
                }
            }
            catch (IOException exception) {
                this.myLogger.error("Unable to copy backup log file to snapshot", exception);
            }
            ++i;
        }
    }

    public void setName(String name) {
        this.myOperationName = name;
    }

    @Override
    public String getName() {
        return this.myOperationName;
    }
}

