/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot.operations;

import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.snapshot.operations.PSnapshotCommonOperation;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class PSavePropertiesOperation
implements PSnapshotCommonOperation {
    private String myOperationName;
    private PSnapshotServiceImpl myService;

    public PSavePropertiesOperation(String operationName, PSnapshotServiceImpl service) {
        this.myOperationName = operationName;
        this.myService = service;
    }

    @Override
    public void invoke() {
        File settingsFile = new File(this.myService.getSnapshotTempDir(), "snapshot.properties");
        PFileOutputStream outStream = null;
        try {
            try {
                outStream = new PFileOutputStream(settingsFile);
                PSettings.getInstance().save(outStream);
            }
            catch (IOException exception) {
                Logger.getLogger(this.getClass()).error("Could not save settings to snapshot", exception);
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (IOException exception2) {
                    Logger.getLogger(this.getClass()).error("Could not close the outputstream", exception2);
                }
            }
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException exception) {
                Logger.getLogger(this.getClass()).error("Could not close the outputstream", exception);
            }
        }
    }

    public void setName(String name) {
        this.myOperationName = name;
    }

    @Override
    public String getName() {
        return this.myOperationName;
    }
}

