/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.snapshot.operations;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotCoverageProvider;
import com.nokia.em.poseidon.plugin.operation.OperationException;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.snapshot.operations.PSnapshotCommonOperation;
import com.nokia.em.poseidon.util.xml.XmlUtils;
import com.nokia.widgets.systeminfo.SystemInfo;
import com.nokia.widgets.text.TimeZoneFormatter;
import com.nokia.widgets.text.TimestampFormatter;
import java.io.File;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PWriteDescOperation
implements PSnapshotCommonOperation {
    private String myOperationName;
    private PSnapshotServiceImpl myService;

    public PWriteDescOperation(String operationName, PSnapshotServiceImpl service) {
        this.myOperationName = operationName;
        this.myService = service;
    }

    protected String getDescription() {
        return "-";
    }

    protected String getUserName() {
        return this.returnHyphenIfNull(PoseidonRuntime.getRuntime().getParameters().getFirstValue("user"));
    }

    private String returnHyphenIfNull(String value) {
        if (value == null) {
            return "-";
        }
        return value;
    }

    @Override
    public void invoke() throws OperationException {
        XmlUtils utils = XmlUtils.getInstance();
        Document doc = utils.createDoc();
        Element root = doc.createElement("snapshotInfo");
        doc.appendChild(root);
        Node version = utils.makeEmptyNode(doc, root, "managerVersion");
        int[] versions = (int[])PoseidonRuntime.getRuntime().getRuntimeProperty("MasterSnapshotVersion");
        if (versions == null) {
            versions = new int[5];
        }
        utils.makeNode(doc, version, "major", String.valueOf(versions[0]));
        utils.makeNode(doc, version, "minor", String.valueOf(versions[1]));
        utils.makeNode(doc, version, "build", String.valueOf(versions[3]));
        utils.makeNode(doc, root, "managerType", this.returnHyphenIfNull((String)PoseidonRuntime.getRuntime().getRuntimeProperty("productFamily")));
        utils.makeNode(doc, root, "softwareReleaseVersion", this.returnHyphenIfNull(String.valueOf((String)PoseidonRuntime.getRuntime().getRuntimeProperty("version")) + " (" + (String)PoseidonRuntime.getRuntime().getRuntimeProperty("build") + ")"));
        utils.makeNode(doc, root, "managerShortName", this.returnHyphenIfNull((String)PoseidonRuntime.getRuntime().getRuntimeProperty("shortPublicName")));
        XmlUtils.getInstance().makeNode(doc, root, "snapshotDescription", this.getDescription());
        Node systemDesc = utils.makeEmptyNode(doc, root, "systemDescription");
        SystemInfo info = SystemInfo.getInstance();
        utils.makeNode(doc, systemDesc, "java", info.getJre());
        utils.makeNode(doc, systemDesc, "locale", info.getLocale());
        utils.makeNode(doc, systemDesc, "cpu", info.getCpuString());
        utils.makeNode(doc, systemDesc, "os", info.getOperatingSystem());
        utils.makeNode(doc, systemDesc, "path", info.getInstallationPath());
        utils.makeNode(doc, systemDesc, "patch", info.getPatch());
        utils.makeNode(doc, root, "userName", this.getUserName());
        utils.makeNode(doc, root, "notes", this.myService.getNotes());
        Calendar cal = Calendar.getInstance();
        utils.makeNode(doc, root, "savingDate", String.valueOf(TimestampFormatter.applyLongFormat(cal)) + " " + TimeZoneFormatter.formatGMTText(cal));
        utils.makeNode(doc, root, "splitParts", "1");
        Node failedNode = utils.makeEmptyNode(doc, root, "savingFailed");
        List<PSnapshotMediator> failed = this.myService.getMediators(PSnapshotServiceImpl.State.FAILED);
        failed.addAll(this.myService.getMediators(PSnapshotServiceImpl.State.CANCELLED));
        for (PSnapshotMediator mediator : failed) {
            utils.makeNode(doc, failedNode, "failedMediator", mediator.getDescription().getStringProperty("internalName"));
        }
        if (this.myService.getSnapshotLogCoverage() != null) {
            utils.makeNode(doc, root, "logCoverage", this.myService.getSnapshotLogCoverage());
        }
        if (this.myService.getSnapshotModuleCoverage() != null) {
            this.addCoverageToNode(utils, doc, root);
        }
        File descFile = new File(this.myService.getSnapshotTempDir(), "snapshotDesc.xml");
        try {
            utils.writeDocToFile(descFile, doc);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass()).error("Failed to write the desc file", exception);
            throw new OperationException("Failed to write the desc file", exception);
        }
    }

    private void addCoverageToNode(XmlUtils utils, Document doc, Element root) {
        Optional<PSaveSnapshotCoverageProvider> pSaveSnapshotCoverageProvider = Optional.ofNullable(PoseidonRuntime.getRuntime().getObject(PSaveSnapshotCoverageProvider.class));
        String keyCoverage = pSaveSnapshotCoverageProvider.map(PSaveSnapshotCoverageProvider::getSnapshotCoverage).orElse("moduleCoverage");
        utils.makeNode(doc, root, keyCoverage, this.myService.getSnapshotModuleCoverage());
    }

    public void setName(String name) {
        this.myOperationName = name;
    }

    @Override
    public String getName() {
        return this.myOperationName;
    }
}

