/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.state;

import com.nokia.em.poseidon.services.state.Mode;
import com.nokia.em.poseidon.services.state.PErrorInfo;
import com.nokia.em.poseidon.services.state.PState;

public abstract class AbstractState
implements PState {
    private String myStep;
    private long myTimeOut;
    private PState.Status myStatus;
    private Mode myMode;
    private PErrorInfo myErrorInfo;

    public AbstractState() {
        this(PState.Status.CURRENT, Mode.FULLY_COMPATIBLE, null, -1L);
    }

    public AbstractState(PState.Status status) {
        this.myStatus = status;
        this.myMode = Mode.FULLY_COMPATIBLE;
    }

    public AbstractState(PState.Status status, String step, long timeOut) {
        this(status);
        this.myStep = step;
        this.myTimeOut = timeOut;
        this.myMode = Mode.FULLY_COMPATIBLE;
    }

    public AbstractState(PState.Status status, Mode mode, String step, long timeOut) {
        this(status);
        this.myMode = mode;
        this.myStep = step;
        this.myTimeOut = timeOut;
    }

    public AbstractState(PState.Status status, Mode mode, String step, long timeOut, PErrorInfo errorInfo) {
        this(status);
        this.myMode = mode;
        this.myStep = step;
        this.myTimeOut = timeOut;
        this.myErrorInfo = errorInfo;
    }

    @Override
    public String getStep() {
        return this.myStep;
    }

    public long getTimeout() {
        return this.myTimeOut;
    }

    @Override
    public PState.Status getStatus() {
        return this.myStatus;
    }

    @Override
    public Mode getMode() {
        return this.myMode;
    }

    @Override
    public void setMode(Mode mode) {
        this.myMode = mode;
    }

    @Override
    public PState.Level getLevel() {
        if (this.getStatus().equals((Object)PState.Status.CURRENT) || this.getStatus().equals((Object)PState.Status.ERROR)) {
            return PState.Level.ALL;
        }
        return PState.Level.LISTENERS;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (" + this.getStep() + "," + (Object)((Object)this.getStatus()) + "," + (Object)((Object)this.getLevel()) + "," + this.getTimeout() + ")";
    }

    public void setErrorInfo(PErrorInfo errorInfo) {
        this.myErrorInfo = errorInfo;
    }

    @Override
    public PErrorInfo getErrorInfo() {
        return this.myErrorInfo;
    }
}

