/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.state;

import com.nokia.em.poseidon.services.state.PPlugin;
import com.nokia.em.poseidon.services.state.PState;
import java.util.EventObject;

public class PStateEvent
extends EventObject
implements Cloneable {
    private PState myDesiredState;
    private PPlugin myPlugin;

    public PStateEvent(Object src, PState desiredState) {
        super(src);
        this.myDesiredState = desiredState;
    }

    public PStateEvent(Object src, PState desiredState, PPlugin plugin) {
        this(src, desiredState);
        this.myPlugin = plugin;
    }

    public PState getDesiredState() {
        return this.myDesiredState;
    }

    public PPlugin getPPlugin() {
        return this.myPlugin;
    }

    public boolean isResponseFor(PStateEvent event) {
        if (event == null) {
            return false;
        }
        PState ongoing = event.getDesiredState();
        return ongoing.getClass().equals(this.getDesiredState().getClass()) && ongoing.getStatus().ordinal() <= this.getDesiredState().getStatus().ordinal();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ": State " + this.getDesiredState() + ", Plugin " + this.getPPlugin();
    }

    public Object clone() throws CloneNotSupportedException {
        PStateEvent e = (PStateEvent)super.clone();
        e.myDesiredState = (PState)this.myDesiredState.getCopy();
        return e;
    }
}

