/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.state;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.application.Application;
import com.nokia.em.poseidon.plugin.application.ApplicationGrade;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.plugin.object.ObjectRegistry;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryEvent;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryListener;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.state.DefaultState;
import com.nokia.em.poseidon.services.state.PBlockEvent;
import com.nokia.em.poseidon.services.state.PPlugin;
import com.nokia.em.poseidon.services.state.PState;
import com.nokia.em.poseidon.services.state.PStateEvent;
import com.nokia.em.poseidon.services.state.PStateException;
import com.nokia.em.poseidon.services.state.PStateHolder;
import com.nokia.em.poseidon.services.state.PStateListener;
import com.nokia.em.poseidon.services.state.PStateManager;
import com.nokia.em.poseidon.services.state.StateOperation;
import com.nokia.em.poseidon.services.state.state.StateCall;
import com.nokia.em.poseidon.services.state.state.StateCallFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class PStateManagerImpl
implements Service,
PluginRegistryListener,
PStateManager {
    private List<PStateHolder> myStateHolders;
    private List<PStateListener> myStateListeners;
    private Map myStateOperations;
    private Logger myLogger;
    private Set<Object> myCurrentBlockers;
    private StateCall myChangeStateCall;
    private StateCall myNotifyStateCall;
    private StateCall myAbortStateCall;
    private transient PStateEvent myPreviousEvent;
    private transient PStateEvent myOngoingEvent;
    private ExecutorService myExecutorService;

    @Override
    public void start() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myStateHolders = new CopyOnWriteArrayList<PStateHolder>();
        this.myStateListeners = new CopyOnWriteArrayList<PStateListener>();
        this.myStateOperations = new ConcurrentHashMap();
        for (PStateHolder stateHolder : PoseidonRuntime.getRuntime().getObjects(PStateHolder.class)) {
            this.addPossibleStateHolder(stateHolder);
        }
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).addRegistryListener(this);
        this.myCurrentBlockers = new CopyOnWriteArraySet<Object>();
        this.myExecutorService = Executors.newSingleThreadExecutor();
        this.myChangeStateCall = StateCallFactory.createCarryChangeStateCall(this);
        this.myNotifyStateCall = StateCallFactory.createNotifyStateCall(this);
        this.myAbortStateCall = StateCallFactory.createAbortStateCall(this);
        this.myPreviousEvent = this.myOngoingEvent = new PStateEvent(this, new DefaultState());
        this.myLogger.debug("State service started");
        this.notifyStateChanged(this.myOngoingEvent);
    }

    @Override
    public void stop() {
        this.myCurrentBlockers.clear();
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).removeRegistryListener(this);
        this.myStateHolders.clear();
        this.myStateListeners.clear();
        this.myStateOperations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStateChange(PStateEvent event) {
        PStateManagerImpl pStateManagerImpl = this;
        synchronized (pStateManagerImpl) {
            this.myLogger.debug("State change request. Target = " + event.getDesiredState() + ", Source = " + event.getSource().getClass().getSimpleName() + "Plugin: " + event.getPPlugin());
            this.myPreviousEvent = this.myOngoingEvent;
            this.myOngoingEvent = event;
            this.myLogger.debug("Notifying listeners about state change request. Listeners: " + this.getListenerNames());
            this.myExecutorService.execute(new ChangeTask(event, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStateChanged(PStateEvent event) {
        PStateManagerImpl pStateManagerImpl = this;
        synchronized (pStateManagerImpl) {
            this.myLogger.debug("State change notify. Target: " + event.getDesiredState() + ", Source: " + event.getSource().getClass().getSimpleName() + "Plugin: " + event.getPPlugin());
            if (PState.Status.CURRENT.equals((Object)event.getDesiredState().getStatus()) && !event.isResponseFor(this.myOngoingEvent) && this.getMaster() != null && this.getMaster().equals(event.getPPlugin())) {
                this.myLogger.debug("State notify changed to request");
                this.requestStateChange(event);
            } else {
                this.myLogger.debug("Notifying listeners about state change notify. Listener list = " + this.getListenerNames());
                this.myExecutorService.execute(new NotifyTask(event, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortStateChange(PStateEvent event) {
        PStateManagerImpl pStateManagerImpl = this;
        synchronized (pStateManagerImpl) {
            try {
                this.myLogger.debug("State change aborted. Target: " + event.getDesiredState() + ", Source: " + event.getSource().getClass().getSimpleName() + "Plugin: " + event.getPPlugin());
                this.myLogger.debug("Notifying listeners about abort. Listeners: " + this.getListenerNames());
                this.myExecutorService.execute(new AbortTask(event, true));
                this.myOngoingEvent = this.myPreviousEvent;
            }
            catch (Exception ex) {
                this.myLogger.error("Could not abort state change", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void block(final PBlockEvent event) {
        PStateManagerImpl pStateManagerImpl = this;
        synchronized (pStateManagerImpl) {
            this.myLogger.debug("Block called. Source: " + event.getSource() + ", block flag: " + event.shouldBlock() + ", myCurrentBlockers:" + this.myCurrentBlockers);
            boolean notify = false;
            if (event.shouldBlock()) {
                if (this.myCurrentBlockers.isEmpty()) {
                    notify = true;
                }
                if (this.myCurrentBlockers.contains(event.getSource())) {
                    this.myLogger.warn("Same source tried to block twice. Block rejected");
                    return;
                }
                this.myCurrentBlockers.add(event.getSource());
            } else if (this.myCurrentBlockers.contains(event.getSource())) {
                this.myCurrentBlockers.remove(event.getSource());
                if (this.myCurrentBlockers.isEmpty()) {
                    notify = true;
                }
            } else {
                this.myLogger.warn("Redundant unblock from " + event.getSource());
            }
            if (!notify) return;
            this.myExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    PStateManagerImpl.this.myLogger.debug("Notifying listeners about the block. Listeners: " + PStateManagerImpl.this.getListenerNames());
                    for (PStateListener listener : PStateManagerImpl.this.myStateListeners) {
                        try {
                            listener.block(event);
                        }
                        catch (PStateException e) {
                            PStateManagerImpl.this.myLogger.error("Exception during blocking", e);
                        }
                    }
                }
            });
            return;
        }
    }

    @Override
    public PState getCurrentState() {
        return this.myOngoingEvent.getDesiredState();
    }

    @Override
    public PState getPreviousState() {
        return this.myPreviousEvent.getDesiredState();
    }

    @Override
    public boolean isBlocked() {
        return !this.myCurrentBlockers.isEmpty();
    }

    @Override
    public void itemAdded(PluginRegistryEvent event) {
        this.addPossibleStateHolder(event.getPlugin());
    }

    @Override
    public synchronized void itemRemoved(PluginRegistryEvent event) {
        this.myStateHolders.remove(event.getPlugin());
    }

    @Override
    public void addStateHolder(PStateHolder holder) {
        this.myStateHolders.add(holder);
        this.myStateListeners.add(holder);
    }

    @Override
    public void removeStateHolder(PStateHolder holder) {
        this.myStateHolders.remove(holder);
        this.myStateListeners.remove(holder);
    }

    @Override
    public List<PStateHolder> getStateHolders() {
        return this.myStateHolders;
    }

    @Override
    public PPlugin getMaster() {
        List masters = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).getApplications(ApplicationGrade.MASTER);
        for (Application master : masters) {
            for (PStateHolder obj : this.myStateHolders) {
                PPlugin plugin;
                if (!(obj instanceof PPlugin) || !(plugin = (PPlugin)obj).getAppDescription().getStringProperty("internalName").equals(master.getDescription().getStringProperty("internalName"))) continue;
                return plugin;
            }
        }
        return null;
    }

    @Override
    public void addStateOperation(PState state, StateOperation operation) {
        ArrayList<StateOperation> operations = (ArrayList<StateOperation>)this.myStateOperations.get(state);
        if (operations == null) {
            operations = new ArrayList<StateOperation>();
        }
        operations.add(operation);
        this.myStateOperations.put(state.getClass(), operations);
    }

    @Override
    public void removeStateOperation(PState state, StateOperation operation) {
        List operations = (List)this.myStateOperations.get(state.getClass());
        if (operations != null) {
            operations.remove(operation);
        }
    }

    protected String getListenerNames() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (PStateHolder holder : this.myStateHolders) {
            sb.append(holder.getClass().getSimpleName());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPossibleStateHolder(Object possibleStateHolder) {
        if (possibleStateHolder instanceof PStateHolder && !this.myStateHolders.contains(possibleStateHolder)) {
            this.myLogger.debug("Adding stateholder: " + possibleStateHolder);
            PStateManagerImpl pStateManagerImpl = this;
            synchronized (pStateManagerImpl) {
                this.myStateHolders.add((PStateHolder)possibleStateHolder);
            }
        }
    }

    @Override
    public void addStateListener(PStateListener listener) {
        this.myStateListeners.add(listener);
    }

    @Override
    public void removeStateListener(PStateListener listener) {
        this.myStateListeners.remove(listener);
    }

    @Override
    public List<PStateListener> getStateListeners() {
        return this.myStateListeners;
    }

    protected class AbortTask
    extends StateTask {
        public AbortTask(PStateEvent event, boolean excludeSource) {
            super(event, excludeSource);
        }

        @Override
        public void execute() throws PStateException, CloneNotSupportedException {
            PStateManagerImpl.this.myAbortStateCall.handleCall(this.myEvent, true);
        }
    }

    protected class ChangeTask
    extends StateTask {
        public ChangeTask(PStateEvent event, boolean excludeSource) {
            super(event, excludeSource);
        }

        @Override
        public void execute() throws PStateException, CloneNotSupportedException {
            try {
                List operations = (List)PStateManagerImpl.this.myStateOperations.get(this.myEvent.getDesiredState().getClass());
                if (operations != null) {
                    Object arg = this.myEvent;
                    Iterator iter = operations.iterator();
                    while (iter.hasNext()) {
                        arg = ((StateOperation)iter.next()).invoke(arg);
                    }
                    if (arg instanceof PStateEvent) {
                        this.myEvent = arg;
                    }
                }
            }
            catch (Exception ex) {
                PStateManagerImpl.this.myLogger.error("Error in notification process", ex);
            }
            if (!PStateManagerImpl.this.myChangeStateCall.handleCall(this.myEvent, this.myExcludeSource)) {
                PStateManagerImpl.this.myOngoingEvent = PStateManagerImpl.this.myPreviousEvent;
            }
        }
    }

    protected class NotifyTask
    extends StateTask {
        public NotifyTask(PStateEvent event, boolean excludeSource) {
            super(event, excludeSource);
        }

        @Override
        public void execute() throws PStateException, CloneNotSupportedException {
            PStateManagerImpl.this.myNotifyStateCall.handleCall(this.myEvent, this.myExcludeSource);
        }
    }

    protected abstract class StateTask
    implements Runnable {
        protected PStateEvent myEvent;
        protected boolean myExcludeSource;

        public StateTask(PStateEvent event, boolean excludeSource) {
            this.myEvent = event;
            this.myExcludeSource = excludeSource;
        }

        @Override
        public void run() {
            try {
                this.execute();
            }
            catch (PStateException pex) {
                PStateManagerImpl.this.myLogger.error("Could not change state to " + this.myEvent.getDesiredState().getClass().getName() + ": " + pex);
                if (pex.getGuilty() instanceof Application && ApplicationGrade.MASTER.equals((Object)PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).getApplicationGrade((Application)((Object)pex.getGuilty())))) {
                    PStateManagerImpl.this.abortStateChange(this.myEvent);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        protected abstract void execute() throws PStateException, CloneNotSupportedException;
    }
}

