/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.state.state;

import com.nokia.em.poseidon.services.state.PPlugin;
import com.nokia.em.poseidon.services.state.PState;
import com.nokia.em.poseidon.services.state.PStateEvent;
import com.nokia.em.poseidon.services.state.PStateException;
import com.nokia.em.poseidon.services.state.PStateHolder;
import com.nokia.em.poseidon.services.state.PStateManager;
import com.nokia.em.poseidon.services.state.state.StateCall;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class AbstractStateCall
implements StateCall {
    protected PStateManager myStateManager;
    protected Logger myLogger;

    public AbstractStateCall(PStateManager stateManager) {
        this.myStateManager = stateManager;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    @Override
    public boolean handleCall(PStateEvent event, boolean excludeSource) throws PStateException, CloneNotSupportedException {
        PState desiredState = event.getDesiredState();
        PStateHolder item = null;
        PState.Level level = desiredState.getLevel();
        PStateEvent eventToHandle = null;
        boolean success = true;
        Iterator<PStateHolder> iter = this.myStateManager.getStateHolders().iterator();
        while (iter.hasNext() && success) {
            item = iter.next();
            if (excludeSource && item.equals(event.getPPlugin()) && item.equals(event.getSource()) || level != PState.Level.ALL && (level != PState.Level.PLUGINS || !(item instanceof PPlugin)) && (level != PState.Level.LISTENERS || item instanceof PPlugin)) continue;
            eventToHandle = (PStateEvent)event.clone();
            success = this.doCall(item, eventToHandle);
        }
        return success;
    }

    protected abstract boolean doCall(PStateHolder var1, PStateEvent var2) throws PStateException;
}

