/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.operation.Operation;
import com.nokia.em.poseidon.services.ui.action.ActionRegistry;
import com.nokia.em.poseidon.services.ui.action.RuleRegistry;
import com.nokia.em.poseidon.services.ui.items.PoseidonCheckBoxMenuItem;
import com.nokia.em.poseidon.services.ui.items.PoseidonMenu;
import com.nokia.em.poseidon.services.ui.items.PoseidonMenuItem;
import com.nokia.em.poseidon.services.ui.items.PoseidonMenuSeparator;
import com.nokia.em.poseidon.services.ui.items.PoseidonRadioButtonMenuItem;
import com.nokia.em.poseidon.services.ui.items.PoseidonToggleToolButton;
import com.nokia.em.poseidon.services.ui.items.PoseidonToolBarSeparator;
import com.nokia.em.poseidon.services.ui.items.PoseidonToolButton;
import com.nokia.em.poseidon.services.ui.items.UI;
import com.nokia.em.poseidon.services.ui.menu.MenuBarServiceImpl;
import com.nokia.em.poseidon.services.ui.toolbar.ToolBarServiceImpl;
import com.nokia.em.poseidon.util.file.ClassParser;
import com.nokia.em.poseidon.util.xml.ObjectLoader;
import java.awt.Component;
import java.awt.Container;
import java.net.URL;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class ConfigurationParser {
    protected int myConfigCounter = 0;
    protected ObjectLoader myObjectLoader = new ObjectLoader("com.nokia.em.poseidon.services.ui.items");

    public ConfigurationParser() {
        this.myObjectLoader.registerTag("ui", UI.class);
        this.myObjectLoader.registerSwingTags();
        this.myObjectLoader.registerTag("pmenuitem", PoseidonMenuItem.class);
        this.myObjectLoader.registerTag("pmenu", PoseidonMenu.class);
        this.myObjectLoader.registerTag("pmenuseparator", PoseidonMenuSeparator.class);
        this.myObjectLoader.registerTag("ptoolbarseparator", PoseidonToolBarSeparator.class);
        this.myObjectLoader.registerTag("pcheckboxmenuitem", PoseidonCheckBoxMenuItem.class);
        this.myObjectLoader.registerTag("pradiobuttonmenuitem", PoseidonRadioButtonMenuItem.class);
        this.myObjectLoader.registerTag("ptoolbutton", PoseidonToolButton.class);
        this.myObjectLoader.registerTag("ptooltogglebutton", PoseidonToggleToolButton.class);
    }

    public void cleanUp() {
        this.myObjectLoader.cleanup();
    }

    public synchronized String loadUIConfiguration(URL configurationFile) {
        String configName = "config" + this.myConfigCounter++;
        try {
            Container container = (Container)this.myObjectLoader.loadObject(configurationFile);
            this.parse(container, configName);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Loading of " + configurationFile + " failed!", exception);
        }
        return configName;
    }

    public void removeUIConfiguration(String configurationID) {
        PoseidonRuntime.getRuntime().getService(MenuBarServiceImpl.class).removeConfiguration(configurationID);
        PoseidonRuntime.getRuntime().getService(ToolBarServiceImpl.class).removeConfiguration(configurationID);
    }

    protected void parse(Component comp, String configName) throws Exception {
        if (comp instanceof UI) {
            ActionRegistry.getInstance().loadActionsFromPackage(((UI)comp).getActionPackages());
            RuleRegistry.getInstance().loadRulesFromPackage(((UI)comp).getRulePackages());
            Component[] componentArray = ((UI)comp).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                this.parse(child, configName);
                ++n2;
            }
            this.invokeOperations((UI)comp);
        } else if (comp instanceof JMenuBar) {
            PoseidonRuntime.getRuntime().getService(MenuBarServiceImpl.class).parseMenus(comp, configName);
        } else if (comp instanceof JToolBar) {
            PoseidonRuntime.getRuntime().getService(ToolBarServiceImpl.class).parseToolBar(comp, configName);
        }
    }

    private void invokeOperations(UI ui) throws Exception {
        for (String pack : ui.getOperationPackages()) {
            for (Class clazz : ClassParser.getClasses(pack)) {
                if (!Operation.class.isAssignableFrom(clazz)) continue;
                ((Operation)clazz.newInstance()).invoke();
            }
        }
    }
}

