/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui;

import com.nokia.em.poseidon.services.ui.action.ActionRegistry;
import com.nokia.em.poseidon.services.ui.action.ActionRule;
import com.nokia.em.poseidon.services.ui.action.PoseidonAction;
import com.nokia.em.poseidon.services.ui.action.RuleRegistry;
import com.nokia.em.poseidon.services.ui.items.RuledItem;
import java.awt.Component;
import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UIUtil {
    public static void addActionAndRules(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            Action ac = button.getAction();
            if (ac == null) {
                ac = (Action)ActionRegistry.getInstance().get(component.getName());
                if (ac == null) {
                    ac = UIUtil.createActionFrom(button);
                }
                button.setAction(ac);
            }
            if (component instanceof RuledItem && ac instanceof PoseidonAction) {
                RuleRegistry reg = RuleRegistry.getInstance();
                for (String ruleName : ((RuledItem)((Object)component)).getRuleNames()) {
                    ActionRule rule = (ActionRule)reg.get(ruleName);
                    if (rule != null) {
                        ((PoseidonAction)ac).addRule(rule);
                        continue;
                    }
                    throw new IllegalArgumentException("Cannot find the rule with name: " + ruleName + " to add to compoment: " + component.getName());
                }
            }
        }
    }

    public static PoseidonAction createActionFrom(AbstractButton button) {
        String name = button.getText();
        if (name == null || "".equals(name)) {
            name = button.getName();
        }
        PoseidonAction action = new PoseidonAction(name);
        Object value = button.getToolTipText();
        if (value != null) {
            action.putValue("ShortDescription", value);
        }
        value = button.getMnemonic();
        if (!Integer.valueOf(0).equals(value)) {
            action.putValue("MnemonicKey", value);
        }
        if ((value = button.getIcon()) != null) {
            action.putValue("SmallIcon", value);
        }
        if ((value = button.getActionCommand()) != null) {
            action.putValue("ActionCommandKey", value);
        }
        action.setEnabled(button.isEnabled());
        action.putValue("visible", button.isVisible());
        return action;
    }

    public static void setActionPropertiesTo(Component comp) {
        AbstractButton button;
        Action action;
        if (comp instanceof AbstractButton && (action = (button = (AbstractButton)comp).getAction()) != null) {
            Object value = action.getValue("ShortDescription");
            if (value != null) {
                button.setToolTipText((String)value);
            }
            if ((value = action.getValue("MnemonicKey")) != null && Integer.valueOf(0).equals(value)) {
                button.setMnemonic((Integer)value);
            }
            if ((value = action.getValue("SmallIcon")) != null) {
                button.setIcon((Icon)value);
            }
            if ((value = action.getValue("ActionCommandKey")) != null) {
                button.setActionCommand((String)value);
            }
            if ((value = action.getValue("visible")) != null) {
                button.setVisible((Boolean)value);
            }
            button.setEnabled(action.isEnabled());
        }
    }

    public static void handleSpacers(Class spacer, Container container) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (spacer.isInstance(comp)) {
                comp.setVisible(true);
            }
            ++n2;
        }
        Component previous = null;
        Component[] componentArray2 = container.getComponents();
        int n3 = componentArray2.length;
        n = 0;
        while (n < n3) {
            Component comp = componentArray2[n];
            if (comp.isVisible()) {
                if (spacer.isInstance(comp) && spacer.isInstance(previous)) {
                    previous.setVisible(false);
                }
                previous = comp;
            }
            ++n;
        }
        Component lastVisible = null;
        boolean first = true;
        Component[] componentArray3 = container.getComponents();
        int n4 = componentArray3.length;
        int n5 = 0;
        while (n5 < n4) {
            Component comp = componentArray3[n5];
            if (comp.isVisible()) {
                if (first && spacer.isInstance(comp)) {
                    comp.setVisible(false);
                }
                first = false;
                lastVisible = comp;
            }
            ++n5;
        }
        if (lastVisible != null && spacer.isInstance(lastVisible)) {
            lastVisible.setVisible(false);
        }
    }

    public static void updateSpacers(Container parent) {
        if (parent != null) {
            UIUtil.handleSpacers(JSeparator.class, parent);
        }
        if (parent instanceof JPopupMenu) {
            ((JPopupMenu)parent).pack();
        }
    }

    public static void runAndWaitOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getLogger(UIUtil.class).error("Invoke and wait failed", e);
            }
        }
    }
}

