/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.gui.common.PStaticDialogs;
import com.nokia.em.poseidon.plugin.lifecycle.LifecycleManager;
import com.nokia.em.poseidon.services.ui.ConfigurationParser;
import com.nokia.em.poseidon.services.ui.UIUtil;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.services.ui.menu.MenuBarService;
import com.nokia.em.poseidon.services.ui.notification.MessageHandler;
import com.nokia.em.poseidon.services.ui.notification.NotificationService;
import com.nokia.em.poseidon.services.ui.notification.PAbstractAppMessage;
import com.nokia.em.poseidon.services.ui.notification.PAppMessage;
import com.nokia.em.poseidon.services.ui.toolbar.ToolBarService;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.ViewUtils;
import com.nokia.laf.NetLookAndFeel;
import java.awt.BorderLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UserInterfaceImpl
implements UserInterface,
MessageHandler {
    protected static final String MAIN_FRAME = "main_frame";
    protected JFrame myFrame;
    protected PropertyChangeSupport mySupport;
    protected boolean myRememberFrameProperties = true;
    protected NotificationService myNotificationService;
    protected ConfigurationParser myConfigurationParser;

    protected void restoreFrameSettings() {
        Rectangle defaultBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (this.myRememberFrameProperties) {
            this.myFrame.setBounds(ViewUtils.restoreSettings(MAIN_FRAME, defaultBounds));
        } else {
            this.myFrame.setBounds(defaultBounds);
        }
        if (defaultBounds.equals(this.myFrame.getBounds())) {
            this.myFrame.setExtendedState(6);
        } else {
            this.myFrame.setExtendedState(ViewUtils.restoreExtendedState(MAIN_FRAME, 0));
        }
    }

    @Override
    public void start() {
        this.mySupport = new PropertyChangeSupport(this);
        if (!GeneralUtils.isHeadlessMode()) {
            UIUtil.runAndWaitOnEDT(new Runnable(){

                @Override
                public void run() {
                    UserInterfaceImpl.this.myFrame = new JFrame();
                    NetLookAndFeel.setDefaultMainFrame(UserInterfaceImpl.this.myFrame);
                    UserInterfaceImpl.this.restoreFrameSettings();
                    UserInterfaceImpl.this.myFrame.setDefaultCloseOperation(0);
                    UserInterfaceImpl.this.myFrame.setLayout(new BorderLayout());
                    UserInterfaceImpl.this.myFrame.addWindowListener(new MainFrameListener());
                    UserInterfaceImpl.this.myFrame.setJMenuBar(PoseidonRuntime.getRuntime().getService(MenuBarService.class).getMenuBar());
                }
            });
        }
        this.myNotificationService = PoseidonRuntime.getRuntime().getService(NotificationService.class);
        this.myNotificationService.addMessageHandler(this);
        this.myNotificationService.setMessageProcessingEnabled(false);
        Logger.getLogger(this.getClass()).debug("UI service started");
    }

    @Override
    public void stop() {
        if (this.myRememberFrameProperties && this.myFrame != null && this.myFrame.isVisible()) {
            ViewUtils.storeSettings(MAIN_FRAME, this.myFrame.getBounds());
            ViewUtils.storeExtendedState(MAIN_FRAME, this.myFrame.getExtendedState());
            PSettings.getInstance().save();
        }
        this.myNotificationService.removeMessageHandler(this);
        this.myNotificationService.setMessageProcessingEnabled(false);
        if (this.myConfigurationParser != null) {
            this.myConfigurationParser.cleanUp();
        }
        if (!GeneralUtils.isHeadlessMode() && this.myFrame != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean oldValue = UserInterfaceImpl.this.myFrame.isVisible();
                    UserInterfaceImpl.this.myFrame.dispose();
                    UserInterfaceImpl.this.myFrame = null;
                    UserInterfaceImpl.this.mySupport.firePropertyChange(new PropertyChangeEvent(this, "ui_visibility_changed", oldValue, false));
                }
            });
        }
        Logger.getLogger(this.getClass()).debug("UI service stopped");
    }

    @Override
    public void setVisible(boolean visibility) {
        boolean oldValue = this.myFrame.isVisible();
        if (visibility) {
            Logger.getLogger(this.getClass()).info("Main frame shown");
            this.myFrame.setVisible(true);
            this.myFrame.toFront();
        } else {
            Logger.getLogger(this.getClass()).info("Main frame hidden");
            this.myFrame.setVisible(false);
        }
        this.mySupport.firePropertyChange(new PropertyChangeEvent(this, "ui_visibility_changed", oldValue, visibility));
    }

    @Override
    public JFrame getFrame() {
        return this.myFrame;
    }

    @Override
    public MenuBarService getMenu() {
        return PoseidonRuntime.getRuntime().getService(MenuBarService.class);
    }

    @Override
    public ToolBarService getToolBar() {
        return PoseidonRuntime.getRuntime().getService(ToolBarService.class);
    }

    @Override
    public void processMessage(final PAbstractAppMessage message) {
        Logger.getLogger(this.getClass()).trace("Processing message: " + message);
        if (!(message instanceof PAppMessage)) {
            return;
        }
        UIUtil.runAndWaitOnEDT(new Runnable(){

            @Override
            public void run() {
                PStaticDialogs.showMessage(UserInterfaceImpl.this.myFrame, (PAppMessage)message);
            }
        });
    }

    @Override
    public String loadUIConfiguration(URL configurationFile) {
        if (this.myConfigurationParser == null) {
            this.myConfigurationParser = new ConfigurationParser();
        }
        String confID = this.myConfigurationParser.loadUIConfiguration(configurationFile);
        this.mySupport.firePropertyChange(new PropertyChangeEvent(this, "ui_conf_loaded", null, confID));
        Logger.getLogger(this.getClass()).debug("Loaded UI conf: " + configurationFile);
        return confID;
    }

    @Override
    public void removeUIConfiguration(String configurationID) {
        if (this.myConfigurationParser != null) {
            this.myConfigurationParser.removeUIConfiguration(configurationID);
            this.mySupport.firePropertyChange(new PropertyChangeEvent(this, "ui_conf_removed", null, null));
        }
    }

    @Override
    public void setRememberFrameProperties(boolean remember) {
        this.myRememberFrameProperties = remember;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mySupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mySupport.removePropertyChangeListener(listener);
    }

    class MainFrameListener
    extends WindowAdapter {
        MainFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Logger.getLogger(this.getClass()).debug("User closed window. Sending closeRequest to Poseidon");
            LifecycleManager.getInstance().closeRequest();
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            Logger.getLogger(this.getClass()).debug("Window opened. Processing msq queue");
            UserInterfaceImpl.this.myNotificationService.setMessageProcessingEnabled(true);
            UserInterfaceImpl.this.myNotificationService.processMessageQueue();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            UserInterfaceImpl.this.myNotificationService.setMessageProcessingEnabled(false);
        }
    }
}

