/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.action;

import com.nokia.em.poseidon.services.ui.action.PoseidonAction;
import com.nokia.em.poseidon.util.file.ClassParser;
import com.nokia.em.poseidon.util.registry.Registry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Action;

public final class ActionRegistry
extends Registry<Action>
implements ActionListener {
    private static ActionRegistry theInstance;
    private Set<ActionListener> myListeners = new CopyOnWriteArraySet<ActionListener>();

    private ActionRegistry() {
    }

    public static synchronized ActionRegistry getInstance() {
        if (theInstance == null) {
            theInstance = new ActionRegistry();
        }
        return theInstance;
    }

    public void add(Action action) {
        this.add(action.getClass().getSimpleName(), action);
    }

    @Override
    public void add(String name, Action item) {
        if (item instanceof PoseidonAction) {
            ((PoseidonAction)item).addActionListener(this);
        }
        super.add(name, item);
    }

    public void add(Collection<Action> actions) {
        for (Action action : actions) {
            this.add(action);
        }
    }

    public Action get(Class<?> clazz) {
        return (Action)this.get(clazz.getSimpleName());
    }

    public List<PoseidonAction> getGroup(String group) {
        ArrayList<PoseidonAction> actions = new ArrayList<PoseidonAction>();
        for (Object action : this.getAll()) {
            PoseidonAction confAction;
            if (!(action instanceof PoseidonAction) || !(confAction = (PoseidonAction)action).getGroup().equals(group)) continue;
            actions.add(confAction);
        }
        return actions;
    }

    public synchronized void removeGroup(String group) {
        for (Action action : this.getGroup(group)) {
            this.remove(action);
        }
    }

    @Override
    public void remove(Action action) {
        if (action instanceof PoseidonAction) {
            ((PoseidonAction)action).removeActionListener(this);
        }
        super.remove(action);
    }

    @Override
    public void remove(String name) {
        this.remove((Action)this.get(name));
    }

    public void addActionListener(ActionListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        for (ActionListener listener : this.myListeners) {
            listener.actionPerformed(event);
        }
    }

    public void loadActionsFromPackage(List<String> packageNames) throws Exception {
        for (String pack : packageNames) {
            for (Class clazz : ClassParser.getClasses(pack)) {
                int modifiers = clazz.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || !Action.class.isAssignableFrom(clazz)) continue;
                this.add((Action)clazz.newInstance());
            }
        }
    }
}

