/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.action;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.services.ui.action.ActionRule;
import com.nokia.em.poseidon.services.ui.action.PoseidonAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class CompositeRule
extends ActionRule
implements Observer {
    protected static ResourceBundle myBundle = I18n.getI18n().getBundle(CompositeRule.class);
    protected List<ActionRule> myChildRules = new ArrayList<ActionRule>();
    protected ActionRule myActiveChildRule;

    public synchronized void addChildRule(ActionRule rule) {
        if (!this.myChildRules.contains(rule)) {
            this.myChildRules.add(rule);
            rule.addObserver(this);
            this.update(rule, null);
        }
    }

    public synchronized void removeChildRule(ActionRule rule) {
        this.myChildRules.remove(rule);
        rule.deleteObserver(this);
        this.update(null, null);
    }

    public synchronized List<ActionRule> getChildRules() {
        return new ArrayList<ActionRule>(this.myChildRules);
    }

    public synchronized void removeChildRules() {
        this.myChildRules.clear();
    }

    @Override
    public boolean shouldActionBeVisible() {
        for (ActionRule rule : this.myChildRules) {
            if (rule.shouldActionBeVisible()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldActionBeEnabled() {
        for (ActionRule rule : this.myChildRules) {
            if (rule.shouldActionBeEnabled()) continue;
            this.myActiveChildRule = rule;
            return false;
        }
        return true;
    }

    @Override
    public void updateAction(PoseidonAction action) {
        if (this.myActiveChildRule != null) {
            action.updateTooltipFromBundle(this.myActiveChildRule);
            this.myActiveChildRule.updateAction(action);
            this.myActiveChildRule = null;
        } else if (this.myChildRules.size() > 0) {
            action.updateTooltipFromBundle(this.myChildRules.get(0));
            this.myChildRules.get(0).updateAction(action);
        }
    }

    @Override
    public void update(Observable observable, Object arg) {
        this.myActiveChildRule = (ActionRule)observable;
        this.setChanged();
        this.notifyObservers();
    }
}

