/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.action;

import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.services.ui.action.ActionRule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.AbstractAction;

public class PoseidonAction
extends AbstractAction
implements Observer {
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String ENABLED_TOOLTIP_KEY = "enabledToolTip";
    public static final String DISABLED_TOOLTIP_KEY = "disabledToolTip";
    public static final String DEFAULT_GROUP = "default_group";
    public static final String HTML_START = "<html>";
    public static final String HTML_CLOSE = "</html>";
    public static final String HTML_LINEBREAK = "<BR/>";
    protected List<ActionRule> myRules;
    protected Set<ActionListener> myListeners;
    protected String myGroup;
    protected ResourceBundle myBundle;

    public PoseidonAction(String name) {
        this(name, DEFAULT_GROUP);
    }

    public PoseidonAction(String name, String group) {
        super(name);
        this.myGroup = group;
        this.myBundle = LocalizerRegistry.lookup("swing").getResourceBundle();
        this.myRules = new ArrayList<ActionRule>();
        this.myListeners = new CopyOnWriteArraySet<ActionListener>();
    }

    public String getGroup() {
        return this.myGroup;
    }

    public void setGroup(String group) {
        this.myGroup = group;
    }

    public synchronized void addRule(ActionRule rule) {
        if (!this.myRules.contains(rule)) {
            this.myRules.add(rule);
            rule.addObserver(this);
            this.checkStatus(rule);
        }
    }

    public synchronized void removeRule(ActionRule rule) {
        this.myRules.remove(rule);
        rule.deleteObserver(this);
        this.checkStatus(null);
    }

    public synchronized List<ActionRule> getRules() {
        return new ArrayList<ActionRule>(this.myRules);
    }

    public synchronized void removeRules() {
        this.myRules.clear();
    }

    public void addActionListener(ActionListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.myListeners.remove(listener);
    }

    protected void checkStatus(ActionRule changedRule) {
        ActionRule hidingRule = this.getFirstHidingRule();
        if (hidingRule != null) {
            this.putValue(PROPERTY_VISIBLE, false);
            return;
        }
        this.putValue(PROPERTY_VISIBLE, true);
        ActionRule disablingRule = null;
        disablingRule = this.getDisableRule(changedRule);
        if (disablingRule != null) {
            this.setEnabled(false);
            this.updateTooltipFromBundle(disablingRule);
            disablingRule.updateAction(this);
            return;
        }
        this.setEnabled(true);
        if (changedRule != null) {
            this.updateTooltipFromBundle(changedRule);
            changedRule.updateAction(this);
        } else if (this.myRules.size() > 0) {
            this.updateTooltipFromBundle(this.myRules.get(0));
            this.myRules.get(0).updateAction(this);
        } else {
            this.setEnabled(true);
            this.putValue(PROPERTY_VISIBLE, true);
        }
    }

    protected ActionRule getDisableRule(ActionRule changedRule) {
        ActionRule disablingRule = changedRule != null && !changedRule.shouldActionBeEnabled() ? changedRule : this.getFirstDisablingRule();
        return disablingRule;
    }

    protected void updateTooltipFromBundle(ActionRule rule) {
        String id;
        String tooltipText;
        String toolTip;
        String toolTipKey = String.valueOf(this.getTooltipKeyBase()) + "_" + rule.getClass().getSimpleName() + "_";
        toolTipKey = rule.shouldActionBeEnabled() ? String.valueOf(toolTipKey) + ENABLED_TOOLTIP_KEY : String.valueOf(toolTipKey) + DISABLED_TOOLTIP_KEY;
        if (!toolTipKey.equals(toolTip = this.myBundle.getString(toolTipKey))) {
            this.putValue("ShortDescription", toolTip);
        } else if (!rule.shouldActionBeEnabled()) {
            String actionTooltipKey = String.valueOf(this.getTooltipKeyBase()) + "_" + ENABLED_TOOLTIP_KEY;
            String ruleTooltipKey = String.valueOf(rule.getClass().getSimpleName()) + "_" + DISABLED_TOOLTIP_KEY;
            String actionToolTip = this.myBundle.getString(actionTooltipKey);
            String ruleToolTip = this.myBundle.getString(ruleTooltipKey);
            if (!actionToolTip.equals(actionTooltipKey) && !ruleToolTip.equals(ruleTooltipKey)) {
                if (actionToolTip.toLowerCase().startsWith(HTML_START)) {
                    actionToolTip = actionToolTip.substring(HTML_START.length(), actionToolTip.toLowerCase().indexOf(HTML_CLOSE) != -1 ? actionToolTip.toLowerCase().indexOf(HTML_CLOSE) : actionToolTip.length());
                }
                if (ruleToolTip.toLowerCase().startsWith(HTML_START)) {
                    ruleToolTip = ruleToolTip.substring(HTML_START.length(), ruleToolTip.toLowerCase().indexOf(HTML_CLOSE) != -1 ? ruleToolTip.toLowerCase().indexOf(HTML_CLOSE) : ruleToolTip.length());
                }
                this.putValue("ShortDescription", HTML_START + actionToolTip + HTML_LINEBREAK + ruleToolTip + HTML_CLOSE);
            } else {
                String id2 = String.valueOf(this.getTooltipKeyBase()) + "_ToolTipText";
                String tooltipText2 = this.myBundle.getString(id2);
                if (!tooltipText2.equals(id2)) {
                    this.putValue("ShortDescription", tooltipText2);
                }
            }
        } else if (rule.shouldActionBeEnabled() && !(tooltipText = this.myBundle.getString(id = String.valueOf(this.getTooltipKeyBase()) + "_ToolTipText")).equals(id)) {
            this.putValue("ShortDescription", tooltipText);
        }
    }

    protected String getTooltipKeyBase() {
        return this.getClass().getSimpleName();
    }

    protected ActionRule getFirstHidingRule() {
        for (ActionRule rule : this.myRules) {
            if (rule.shouldActionBeVisible()) continue;
            return rule;
        }
        return null;
    }

    protected ActionRule getFirstDisablingRule() {
        for (ActionRule rule : this.myRules) {
            if (rule.shouldActionBeEnabled()) continue;
            return rule;
        }
        return null;
    }

    @Override
    public synchronized void update(Observable observable, Object arg) {
        this.checkStatus((ActionRule)observable);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.actionExecuted(event);
        for (ActionListener listener : this.myListeners) {
            listener.actionPerformed(event);
        }
    }

    public void actionExecuted(ActionEvent event) {
    }
}

