/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.action;

import com.nokia.em.poseidon.services.ui.action.ActionRule;
import com.nokia.em.poseidon.services.ui.action.CompositeRule;
import com.nokia.em.poseidon.util.file.ClassParser;
import com.nokia.em.poseidon.util.registry.Registry;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class RuleRegistry
extends Registry<ActionRule> {
    private static RuleRegistry theInstance;

    private RuleRegistry() {
    }

    public static synchronized RuleRegistry getInstance() {
        if (theInstance == null) {
            theInstance = new RuleRegistry();
        }
        return theInstance;
    }

    public void add(ActionRule rule) {
        this.add(rule.getClass().getSimpleName(), rule);
    }

    public ActionRule get(Class<?> clazz) {
        return (ActionRule)this.get(clazz.getSimpleName());
    }

    public void loadRulesFromPackage(List<String> packageNames) throws Exception {
        for (String pack : packageNames) {
            if (pack.isEmpty()) continue;
            ArrayList<Class> compositeRules = new ArrayList<Class>();
            for (Class clazz : ClassParser.getClasses(pack)) {
                int modifiers = clazz.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || !ActionRule.class.isAssignableFrom(clazz)) continue;
                if (CompositeRule.class.isAssignableFrom(clazz)) {
                    compositeRules.add(clazz);
                    continue;
                }
                this.add((ActionRule)clazz.newInstance());
            }
            for (Class<Object> clazz : compositeRules) {
                this.add((ActionRule)clazz.newInstance());
            }
        }
    }
}

