/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.menu;

import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.services.ui.UIUtil;
import com.nokia.em.poseidon.services.ui.action.ActionPropertyListener;
import com.nokia.em.poseidon.services.ui.items.PoseidonMenu;
import com.nokia.em.poseidon.services.ui.items.RelativeItem;
import com.nokia.em.poseidon.services.ui.menu.MenuBarService;
import com.nokia.em.poseidon.services.ui.menu.MenuItemLocation;
import com.nokia.widgets.PMenuBar;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MenuBarServiceImpl
implements MenuBarService {
    protected PMenuBar myMenuBar;
    protected Map<String, List<String>> myConfigurationItems;
    protected Stack<Container> myParents;

    public void parseMenus(Component comp, String configName) {
        if (!this.myConfigurationItems.containsKey(configName)) {
            this.myConfigurationItems.put(configName, new ArrayList());
        }
        if (comp instanceof JMenuBar) {
            JMenuBar menuBar = (JMenuBar)comp;
            this.myParents.push(menuBar);
            Component[] componentArray = menuBar.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component mComp = componentArray[n2];
                this.parseMenus(mComp, configName);
                ++n2;
            }
            this.myParents.pop();
        } else if (comp instanceof JMenu) {
            JMenu menu = (JMenu)comp;
            if (menu.getName() == null) {
                menu.setName(menu.getText());
            }
            if (this.get(menu.getName()) == null) {
                PoseidonMenu copyMenu = new PoseidonMenu(menu.getText());
                copyMenu.setName(menu.getName());
                if (menu instanceof PoseidonMenu) {
                    copyMenu.setRuleNames(((PoseidonMenu)menu).getRuleNames());
                    copyMenu.setRelativeItemName(((PoseidonMenu)menu).getRelativeItemName());
                    copyMenu.setBeforeRelativeItem(((PoseidonMenu)menu).isBeforeRelativeItem());
                }
                if (!this.addWithRelativity(copyMenu, configName)) {
                    this.addComponent(copyMenu, new MenuItemLocation());
                }
            }
            this.myParents.push(menu);
            Component[] componentArray = menu.getMenuComponents();
            int n = componentArray.length;
            int n3 = 0;
            while (n3 < n) {
                Component child = componentArray[n3];
                this.parseMenus(child, configName);
                ++n3;
            }
            this.myParents.pop();
        } else if ((comp instanceof JMenuItem || comp instanceof JSeparator) && this.get(comp.getName()) == null && !this.addWithRelativity(comp, configName)) {
            throw new IllegalArgumentException("Unable to add menu item: " + comp + " because of a insufficient location information");
        }
    }

    public void removeConfiguration(String configurationID) {
        if (this.myConfigurationItems.containsKey(configurationID)) {
            for (String itemName : this.myConfigurationItems.get(configurationID)) {
                this.remove(itemName);
            }
            this.myConfigurationItems.remove(configurationID);
        }
    }

    protected boolean addWithRelativity(Component comp, String configName) {
        this.myConfigurationItems.get(configName).add(comp.getName());
        if (comp instanceof RelativeItem && ((RelativeItem)((Object)comp)).getRelativeItemName() != null) {
            RelativeItem rItem = (RelativeItem)((Object)comp);
            this.addComponent((JComponent)comp, new MenuItemLocation(rItem.getRelativeItemName(), rItem.isBeforeRelativeItem()));
            return true;
        }
        if (this.myParents.peek() != null) {
            if (comp instanceof RelativeItem && ((RelativeItem)((Object)comp)).getIndex() != -1) {
                this.addComponent((JComponent)comp, new MenuItemLocation(this.myParents.peek().getName(), ((RelativeItem)((Object)comp)).getIndex()));
            } else {
                this.addComponent((JComponent)comp, new MenuItemLocation(this.myParents.peek().getName()));
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addComponent(JComponent comp, MenuItemLocation location) {
        Logger.getLogger(this.getClass()).trace("Add menu item: " + comp + ", location=" + location);
        UIUtil.addActionAndRules(comp);
        this.localizeMenu(comp);
        UIUtil.setActionPropertiesTo(comp);
        if (location.getRelativeItemName() != null) {
            Component relativeItem = this.get(location.getRelativeItemName());
            if (relativeItem != null) {
                Container parent = relativeItem.getParent();
                int index = this.getChildIndex(relativeItem);
                if (parent == null) {
                    throw new IllegalArgumentException("Failed to find the parent item in order to add the component: " + comp + " to menu.");
                }
                if (location.isBeforeRelativeItem()) {
                    parent.add((Component)comp, index >= 0 ? index : 0);
                } else {
                    int childrenCount = parent.getComponentCount();
                    parent.add((Component)comp, index <= childrenCount - 1 ? index + 1 : childrenCount - 1);
                }
            } else if (location.getParentName() != null) {
                JMenu parent = (JMenu)this.get(location.getParentName());
                if (parent != null) {
                    parent.add(comp);
                }
            } else if (this.get(this.myParents.peek().getName()) != null) {
                ((JMenu)this.get(this.myParents.peek().getName())).add(comp);
            } else {
                if (!(comp instanceof JMenu)) throw new IllegalArgumentException("Failed to find the relative item: " + location.getRelativeItemName() + " in order to add the component: " + comp.getName());
                this.myMenuBar.add(comp);
            }
        } else if (location.getParentName() != null) {
            JMenu parent = (JMenu)this.get(location.getParentName());
            if (parent == null) throw new IllegalArgumentException("Failed to find the parent item: " + location.getParentName() + " in order to add the component: " + comp + " to menu.");
            if (location.getIndex() >= 0 && location.getIndex() <= parent.getItemCount()) {
                parent.add((Component)comp, location.getIndex());
            } else {
                parent.add(comp);
            }
        } else if (location.getIndex() >= 0 && location.getIndex() <= this.myMenuBar.getComponentCount()) {
            this.myMenuBar.add((Component)comp, location.getIndex());
        } else if (location.getIndex() == -2) {
            this.myMenuBar.setOptionalBannerComponent(comp);
        } else {
            this.myMenuBar.add(comp);
        }
        if (!(comp instanceof AbstractButton)) return;
        this.addVisiblityHandling(comp, ((AbstractButton)comp).getAction());
    }

    protected void addVisiblityHandling(Component comp, Action action) {
        if (action != null) {
            MenuActionPropertyListener listener = new MenuActionPropertyListener(comp);
            action.addPropertyChangeListener(listener);
            Boolean value = (Boolean)action.getValue("visible");
            if (value != null) {
                listener.propertyChange(new PropertyChangeEvent(this, "visible", value == false, value));
            }
        }
    }

    protected void localizeMenu(JComponent comp) {
        if (comp.getClientProperty("autolocalization") == null) {
            comp.putClientProperty("autolocalization", Boolean.TRUE);
        }
        if (comp instanceof JMenuItem && ((Boolean)comp.getClientProperty("autolocalization")).booleanValue()) {
            JMenuItem item = (JMenuItem)comp;
            if (item.getName() == null) {
                Action action = ((JMenuItem)comp).getAction();
                if (action != null) {
                    item.setName((String)action.getValue("Name"));
                } else if (item.getText() != null) {
                    item.setName(item.getText());
                }
            }
            Localizer localiser = LocalizerRegistry.lookup("swing");
            localiser.localizeObject(comp);
        }
    }

    protected Component findItem(JMenu menu, String itemName) {
        Component result = null;
        if (this.nameMatches(menu, itemName)) {
            return menu;
        }
        int i = 0;
        while (i < menu.getItemCount()) {
            Component item = menu.getMenuComponent(i);
            if (this.nameMatches(item, itemName)) {
                result = item;
                break;
            }
            if (item instanceof JMenu && (result = this.findItem((JMenu)item, itemName)) != null) break;
            ++i;
        }
        return result;
    }

    protected int getChildIndex(Component comp) {
        Container parent = comp.getParent();
        if (parent == null) {
            return -1;
        }
        int i = 0;
        while (i < parent.getComponentCount()) {
            if (parent.getComponent(i).equals(comp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean nameMatches(Component comp, String name) {
        return comp != null && comp.getName() != null && comp.getName().equals(name);
    }

    @Override
    public void start() {
        UIUtil.runAndWaitOnEDT(new Runnable(){

            @Override
            public void run() {
                MenuBarServiceImpl.this.myMenuBar = new PMenuBar();
            }
        });
        this.myConfigurationItems = new HashMap<String, List<String>>();
        this.myParents = new Stack();
        Logger.getLogger(this.getClass()).debug("MenuBar service started");
    }

    @Override
    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuBarServiceImpl.this.removeAll();
            }
        });
        this.myConfigurationItems.clear();
        Logger.getLogger(this.getClass()).debug("MenuBar service stopped");
    }

    @Override
    public void add(JMenuItem menuItem) {
        this.addComponent(menuItem, new MenuItemLocation());
    }

    @Override
    public void add(JMenuItem menuItem, MenuItemLocation location) {
        this.addComponent(menuItem, location);
    }

    @Override
    public void add(Action action) {
        this.add(action, new MenuItemLocation());
    }

    @Override
    public void add(Action action, MenuItemLocation location) {
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.setName((String)action.getValue("Name"));
        this.addComponent(menuItem, location);
    }

    @Override
    public void add(JSeparator separator, MenuItemLocation location) {
        this.addComponent(separator, location);
    }

    @Override
    public void setApplicationIcon(Icon applicationIcon) {
        this.myMenuBar.setApplicationIcon(applicationIcon);
    }

    @Override
    public Component get(String name) {
        int i = 0;
        while (i < this.myMenuBar.getMenuCount()) {
            JMenu menu = this.myMenuBar.getMenu(i);
            if (menu != null) {
                if (this.nameMatches(menu, name)) {
                    return menu;
                }
                Component item = this.findItem(menu, name);
                if (item != null) {
                    return item;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean contains(String name) {
        return this.get(name) != null;
    }

    @Override
    public void remove(String name) {
        Component item = this.get(name);
        if (item != null && item.getParent() != null) {
            Container parent = item.getParent();
            parent.remove(item);
            UIUtil.updateSpacers(parent);
        }
    }

    @Override
    public void removeAll() {
        this.myMenuBar.removeAll();
    }

    @Override
    public PMenuBar getMenuBar() {
        return this.myMenuBar;
    }

    private static class MenuActionPropertyListener
    extends ActionPropertyListener {
        public MenuActionPropertyListener(Component comp) {
            super(comp);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if ("visible".equals(evt.getPropertyName())) {
                UIUtil.updateSpacers(this.myComp.getParent());
            }
        }
    }
}

