/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.notification;

import com.nokia.em.poseidon.services.ui.notification.MessageHandler;
import com.nokia.em.poseidon.services.ui.notification.NotificationHandlerEvent;
import com.nokia.em.poseidon.services.ui.notification.NotificationHandlerListener;
import com.nokia.em.poseidon.services.ui.notification.NotificationService;
import com.nokia.em.poseidon.services.ui.notification.PAbstractAppMessage;
import com.nokia.em.poseidon.util.concurrency.ThreadPool;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class NotificationServiceImpl
implements NotificationService {
    protected static final int FIRST_GENERATED_ID = 100000;
    protected Queue<PAbstractAppMessage> myMsgQueue;
    protected List<MessageHandler> myMessageHandlers;
    protected Set<NotificationHandlerListener> myListeners;
    protected Logger myLogger;
    protected AtomicInteger myCurrentId;
    protected List<PAbstractAppMessage> myOnScreenMessages;
    protected boolean myMessageProcessingEnabled;

    protected boolean isMessageInQueue(int messageID) {
        for (PAbstractAppMessage msg : this.myMsgQueue) {
            if (messageID != msg.getID()) continue;
            return true;
        }
        return false;
    }

    protected void sendMessageToHandlers(PAbstractAppMessage msg) {
        this.myLogger.debug("Send message to handlers. Message: " + msg);
        for (MessageHandler handler : this.myMessageHandlers) {
            handler.processMessage(msg);
        }
    }

    protected void queueMessage(PAbstractAppMessage msg) {
        if (msg != null) {
            this.myMsgQueue.offer(msg);
            this.myLogger.debug("Message added to queue: " + msg);
            this.fireEvent(NotificationHandlerEvent.MESSAGE_QUEUED, msg.getID());
        }
    }

    protected void fireEvent(NotificationHandlerEvent event, int messageID) {
        for (NotificationHandlerListener listener : this.myListeners) {
            listener.eventOccured(event, messageID);
        }
    }

    @Override
    public void start() {
        this.myMsgQueue = new ConcurrentLinkedQueue<PAbstractAppMessage>();
        this.myLogger = Logger.getLogger(this.getClass());
        this.myCurrentId = new AtomicInteger(100000);
        this.myMessageHandlers = new CopyOnWriteArrayList<MessageHandler>();
        this.myListeners = new CopyOnWriteArraySet<NotificationHandlerListener>();
        this.myOnScreenMessages = new CopyOnWriteArrayList<PAbstractAppMessage>();
        this.myMessageProcessingEnabled = true;
        this.myLogger.debug("Started notification handler service");
    }

    @Override
    public void stop() {
        this.myMsgQueue.clear();
        this.myMessageHandlers.clear();
        this.myListeners.clear();
        this.myOnScreenMessages.clear();
        this.myLogger.debug("NotificationHandler service stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendMessage(PAbstractAppMessage msg) {
        int id = msg.getID();
        if (id == -1) {
            id = this.myCurrentId.incrementAndGet();
            msg.setID(id);
        }
        Queue<PAbstractAppMessage> queue = this.myMsgQueue;
        synchronized (queue) {
            if (this.isMessageInQueue(id) || this.isMessageOnScreen(id)) {
                this.myLogger.debug("do not process the message if it is already on screen or in queue");
                return id;
            }
            if (!this.myMessageProcessingEnabled && msg.isCacheable()) {
                this.queueMessage(msg);
                this.myLogger.debug("Set message to queue if message processing is not allowed and message is cacheable");
                return id;
            }
            if (!msg.shouldWaitUntilShown() || msg.getPriority() == PAbstractAppMessage.Priority.HIGH) {
                Logger.getLogger(this.getClass()).debug("Message shown asynchronously: " + msg);
                ThreadPool.getInstance().execute(new SendMessageTask(msg));
                return id;
            }
            this.myOnScreenMessages.add(msg);
        }
        Logger.getLogger(this.getClass()).debug("Message shown in synchronous fashion: " + msg);
        new SendMessageTask(msg).run();
        queue = this.myMsgQueue;
        synchronized (queue) {
            this.myOnScreenMessages.remove(msg);
        }
        return id;
    }

    @Override
    public void processMessageQueue() {
        this.myLogger.debug("Processing message queue. Queue size = " + this.myMsgQueue.size());
        while (this.myMsgQueue.peek() != null && this.myMessageProcessingEnabled) {
            PAbstractAppMessage msg = this.myMsgQueue.poll();
            this.sendMessage(msg);
        }
    }

    @Override
    public void emptyMessageQueue() {
        for (PAbstractAppMessage msg : this.myMsgQueue) {
            this.removeMessageFromQueue(msg.getID());
        }
        this.myLogger.debug("Message queue emptied");
        this.fireEvent(NotificationHandlerEvent.MESSAGE_QUEUE_EMPTIED, 0);
    }

    @Override
    public void removeMessageFromQueue(int id) {
        for (PAbstractAppMessage msg : this.myMsgQueue) {
            if (msg.getID() != id) continue;
            this.myMsgQueue.remove(msg);
            this.myLogger.debug("Message removed from the queue: " + id);
            this.fireEvent(NotificationHandlerEvent.MESSAGE_REMOVED_FROM_QUEUE, id);
        }
    }

    @Override
    public void addMessageHandler(MessageHandler handler) {
        this.myMessageHandlers.add(handler);
    }

    @Override
    public void removeMessageHandler(MessageHandler handler) {
        this.myMessageHandlers.remove(handler);
    }

    @Override
    public void addListener(NotificationHandlerListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    @Override
    public void removeListener(NotificationHandlerListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public boolean isMessageQueued(int id) {
        for (PAbstractAppMessage msg : this.myMsgQueue) {
            if (msg.getID() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMessageOnScreen(int messageID) {
        for (PAbstractAppMessage msg : this.myOnScreenMessages) {
            if (messageID != msg.getID()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMessageProcessingEnabled() {
        return this.myMessageProcessingEnabled;
    }

    @Override
    public void setMessageProcessingEnabled(boolean enableMessageProcessing) {
        this.myMessageProcessingEnabled = enableMessageProcessing;
    }

    class SendMessageTask
    implements Runnable {
        protected PAbstractAppMessage myAppMessage;

        SendMessageTask(PAbstractAppMessage msg) {
            this.myAppMessage = msg;
            NotificationServiceImpl.this.myOnScreenMessages.add(this.myAppMessage);
        }

        @Override
        public void run() {
            NotificationServiceImpl.this.fireEvent(NotificationHandlerEvent.PROCESSING_MESSAGE, this.myAppMessage.getID());
            NotificationServiceImpl.this.sendMessageToHandlers(this.myAppMessage);
            NotificationServiceImpl.this.fireEvent(NotificationHandlerEvent.MESSAGE_PROCESSED, this.myAppMessage.getID());
            NotificationServiceImpl.this.myOnScreenMessages.remove(this.myAppMessage);
        }
    }
}

