/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.notification;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public abstract class PAbstractAppMessage {
    protected String myTitle;
    protected String myHeadline;
    protected Object myMessage;
    protected Icon myIcon;
    protected boolean myCacheable = true;
    protected boolean myWaitUntilShown = true;
    protected List<PropertyChangeListener> myPropertyChangeListeners = new ArrayList<PropertyChangeListener>();
    protected boolean myIsAccepted = false;
    protected int myID = -1;
    protected Priority myPriority = Priority.NORMAL;

    public PAbstractAppMessage() {
    }

    public PAbstractAppMessage(Object message) {
        this(null, null, message);
    }

    public PAbstractAppMessage(String title, Object message) {
        this(title, null, message);
    }

    public PAbstractAppMessage(String title, String headline, Object message) {
        this();
        this.myTitle = title;
        this.myHeadline = headline;
        this.myMessage = message;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setHeadline(String headline) {
        this.myHeadline = headline;
    }

    public String getHeadline() {
        return this.myHeadline;
    }

    public void setMessage(Object message) {
        this.myMessage = message;
    }

    public Object getMessage() {
        return this.myMessage;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setCacheable(boolean cacheable) {
        this.myCacheable = cacheable;
    }

    public boolean isCacheable() {
        return this.myCacheable;
    }

    public void setWaitUntilShown(boolean value) {
        this.myWaitUntilShown = value;
    }

    public boolean shouldWaitUntilShown() {
        return this.myWaitUntilShown;
    }

    public int getID() {
        return this.myID;
    }

    public void setID(int id) {
        this.myID = id;
    }

    public Priority getPriority() {
        return this.myPriority;
    }

    public void setPriority(Priority priority) {
        this.myPriority = priority;
    }

    public String toString() {
        return "Abstract Message{myTitle='" + this.myTitle + '\'' + ", myHeadline='" + this.myHeadline + '\'' + ", myMessage=" + this.myMessage + ", myIcon=" + this.myIcon + ", myCacheable=" + this.myCacheable + ", myPropertyChangeListeners=" + this.myPropertyChangeListeners + ", myIsAccepted=" + this.myIsAccepted + ", myWaitUntilShown=" + this.myWaitUntilShown + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myCacheable ? 1231 : 1237);
        result = 31 * result + (this.myHeadline == null ? 0 : this.myHeadline.hashCode());
        result = 31 * result + this.myID;
        result = 31 * result + (this.myIsAccepted ? 1231 : 1237);
        result = 31 * result + (this.myMessage == null ? 0 : this.myMessage.hashCode());
        result = 31 * result + (this.myPriority == null ? 0 : this.myPriority.hashCode());
        result = 31 * result + (this.myTitle == null ? 0 : this.myTitle.hashCode());
        result = 31 * result + (this.myWaitUntilShown ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PAbstractAppMessage)) {
            return false;
        }
        PAbstractAppMessage other = (PAbstractAppMessage)obj;
        if (this.myTitle != null ? !this.myTitle.equals(other.getTitle()) : other.getTitle() != null) {
            return false;
        }
        if (this.myHeadline != null ? !this.myHeadline.equals(other.getHeadline()) : other.getHeadline() != null) {
            return false;
        }
        if (this.myMessage != null ? !this.myMessage.equals(other.getMessage()) : other.getMessage() != null) {
            return false;
        }
        if (this.myIcon != null ? !this.myIcon.equals(other.getIcon()) : other.getIcon() != null) {
            return false;
        }
        if (other.isCacheable() != this.myCacheable) {
            return false;
        }
        return other.shouldWaitUntilShown() == this.myWaitUntilShown;
    }

    public static enum Priority {
        HIGH,
        NORMAL;

    }
}

