/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.ui.toolbar;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.services.ui.UIUtil;
import com.nokia.em.poseidon.services.ui.action.ActionPropertyListener;
import com.nokia.em.poseidon.services.ui.items.RelativeItem;
import com.nokia.em.poseidon.services.ui.menu.MenuBarService;
import com.nokia.em.poseidon.services.ui.toolbar.ToolBarLocation;
import com.nokia.em.poseidon.services.ui.toolbar.ToolBarService;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ToolBarServiceImpl
implements ToolBarService {
    protected static final String TOOLBAR_GROUP_PROPERTY = "ToolBarGroupName";
    protected List<String> myGroups;
    protected JToolBar myJToolBar;
    protected Map<String, List<String>> myConfigurationItems;
    protected boolean myShowToolButtonTexts;

    public void parseToolBar(Component comp, String configName) {
        if (!this.myConfigurationItems.containsKey(configName)) {
            this.myConfigurationItems.put(configName, new ArrayList());
        }
        if (comp instanceof JToolBar) {
            JToolBar toolbar = (JToolBar)comp;
            Component[] componentArray = toolbar.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component mComp = componentArray[n2];
                if (this.get(mComp.getName()) == null) {
                    this.myConfigurationItems.get(configName).add(mComp.getName());
                    if (mComp instanceof RelativeItem && ((RelativeItem)((Object)mComp)).getRelativeItemName() != null) {
                        RelativeItem rItem = (RelativeItem)((Object)mComp);
                        this.add((JComponent)mComp, new ToolBarLocation(rItem.getRelativeItemName(), rItem.isBeforeRelativeItem()));
                    } else if (mComp instanceof RelativeItem && ((RelativeItem)((Object)mComp)).getIndex() != -1) {
                        this.add((JComponent)mComp, new ToolBarLocation(((RelativeItem)((Object)mComp)).getIndex()));
                    } else {
                        this.add((JComponent)mComp, new ToolBarLocation());
                    }
                }
                ++n2;
            }
        }
    }

    public void removeConfiguration(String configurationID) {
        if (this.myConfigurationItems.containsKey(configurationID)) {
            for (String itemName : this.myConfigurationItems.get(configurationID)) {
                this.remove(itemName);
            }
            this.myConfigurationItems.remove(configurationID);
        }
    }

    protected void addPropertyListener(AbstractButton button) {
        Action action = button.getAction();
        if (action != null) {
            ToolBarActionPropertyListener handler = new ToolBarActionPropertyListener(button);
            action.addPropertyChangeListener(handler);
            Boolean value = (Boolean)action.getValue("visible");
            if (value != null) {
                handler.propertyChange(new PropertyChangeEvent(this, "visible", value == false, value));
            }
        }
    }

    protected void localize(JComponent comp) {
        if (comp.getClientProperty("autolocalization") == null) {
            comp.putClientProperty("autolocalization", Boolean.TRUE);
        }
        if (((Boolean)comp.getClientProperty("autolocalization")).booleanValue()) {
            ImageIcon notFoundImage;
            ResourceBundle bundle;
            ImageIcon icon;
            Localizer localiser = LocalizerRegistry.lookup("swing");
            localiser.localizeObject(comp);
            if (comp instanceof AbstractButton && !(icon = (bundle = I18n.getI18n().getBundle(this.getClass())).getImageIcon(String.valueOf(comp.getName()) + "_ToolbarIcon")).equals(notFoundImage = (ImageIcon)bundle.getResourceCacheManager().getNotFoundObject(ImageIcon.class))) {
                ((AbstractButton)comp).setIcon(icon);
            }
        }
    }

    protected int getGroupIndex(String group) {
        int groupIndex = 0;
        for (String groupName : this.myGroups) {
            if (group.equals(groupName)) break;
            int i = 0;
            while (i < this.myJToolBar.getComponentCount()) {
                JComponent comp;
                if (this.myJToolBar.getComponent(i) instanceof JComponent && groupName.equals((comp = (JComponent)this.myJToolBar.getComponent(i)).getClientProperty(TOOLBAR_GROUP_PROPERTY))) {
                    ++groupIndex;
                }
                ++i;
            }
        }
        return groupIndex;
    }

    @Override
    public void start() {
        this.myJToolBar = PoseidonRuntime.getRuntime().getService(MenuBarService.class).getMenuBar().getToolBar();
        this.myGroups = new CopyOnWriteArrayList<String>();
        this.myConfigurationItems = new HashMap<String, List<String>>();
        this.myGroups.add("defaultGroup");
    }

    @Override
    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolBarServiceImpl.this.removeAll();
            }
        });
        this.myConfigurationItems.clear();
        this.myGroups.clear();
    }

    @Override
    public void add(Action action) {
        this.add(action, new ToolBarLocation());
    }

    @Override
    public void add(JComponent component) {
        this.add(component, new ToolBarLocation());
    }

    @Override
    public void add(Action action, ToolBarLocation location) {
        JButton button = new JButton(action);
        button.setName((String)action.getValue("Name"));
        this.add(button, location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(JComponent comp, ToolBarLocation location) {
        Logger.getLogger(this.getClass()).trace("Add toolbar item: " + comp + ", location=" + location);
        UIUtil.addActionAndRules(comp);
        this.localize(comp);
        UIUtil.setActionPropertiesTo(comp);
        comp.putClientProperty(TOOLBAR_GROUP_PROPERTY, location.getGroup());
        int toolBarItemCount = this.myJToolBar.getComponentCount();
        if (location.getIndex() == -1) {
            this.myJToolBar.add(comp);
        } else if (location.getRelativeItemName() != null) {
            Component relativeItem = this.get(location.getRelativeItemName());
            if (relativeItem == null) throw new IllegalArgumentException("Relative item with name: " + location.getRelativeItemName() + " cannot be found for component: " + comp.getName());
            int index = this.myJToolBar.getComponentIndex(relativeItem);
            if (location.isBeforeRelativeItem()) {
                this.myJToolBar.add((Component)comp, index);
            } else {
                this.myJToolBar.add((Component)comp, index + 1 <= toolBarItemCount - 1 ? index + 1 : -1);
            }
        } else {
            if (location.getGroup() == null) throw new IllegalArgumentException("Component : " + comp + " has invalid location defintion.");
            int itemIndex = this.getGroupIndex(location.getGroup()) + location.getIndex();
            this.myJToolBar.add((Component)comp, itemIndex <= toolBarItemCount - 1 ? itemIndex : -1);
        }
        if (!(comp instanceof AbstractButton)) return;
        this.addPropertyListener((AbstractButton)comp);
        if (this.myShowToolButtonTexts) return;
        ((AbstractButton)comp).setText(null);
        ((AbstractButton)comp).setMnemonic(0);
    }

    @Override
    public void addSeparator(String name) {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setName(name);
        this.myJToolBar.add(separator);
    }

    @Override
    public void remove(String name) {
        Component comp = this.get(name);
        if (comp != null) {
            this.myJToolBar.remove(comp);
            UIUtil.updateSpacers(this.myJToolBar);
        }
    }

    @Override
    public void removeAll() {
        this.myJToolBar.removeAll();
    }

    @Override
    public boolean contains(String name) {
        return this.get(name) != null;
    }

    @Override
    public void addGroupDefinition(String groupName, int toolBarIndex) {
        if (toolBarIndex <= this.myGroups.size()) {
            this.myGroups.add(toolBarIndex, groupName);
        } else {
            this.myGroups.add(groupName);
        }
    }

    @Override
    public JToolBar getJToolBar() {
        return this.myJToolBar;
    }

    @Override
    public Component get(String name) {
        int i = 0;
        while (i < this.myJToolBar.getComponentCount()) {
            Action action = null;
            Component comp = this.myJToolBar.getComponentAtIndex(i);
            if (comp instanceof AbstractButton) {
                action = ((AbstractButton)comp).getAction();
            }
            if (comp != null && comp.getName() != null && comp.getName().equals(name) || action != null && action.getValue("Name") != null && action.getValue("Name").equals(name)) {
                return this.myJToolBar.getComponentAtIndex(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setShowToolButtonTexts(boolean showTexts) {
        this.myShowToolButtonTexts = showTexts;
    }

    @Override
    public boolean areToolButtonTextsShown() {
        return this.myShowToolButtonTexts;
    }

    private class ToolBarActionPropertyListener
    extends ActionPropertyListener {
        public ToolBarActionPropertyListener(Component comp) {
            super(comp);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if (this.myComp instanceof AbstractButton && !ToolBarServiceImpl.this.myShowToolButtonTexts) {
                ((AbstractButton)this.myComp).setText(null);
                ((AbstractButton)this.myComp).setMnemonic(0);
            }
            if ("visible".equals(evt.getPropertyName())) {
                UIUtil.updateSpacers(this.myComp.getParent());
            }
        }
    }
}

