/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.services.userauthentication;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.object.ObjectRegistry;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryEvent;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryListenerAdapter;
import com.nokia.em.poseidon.plugin.service.Service;
import com.nokia.em.poseidon.services.userauthentication.UserAuthenticationListener;
import com.nokia.em.poseidon.services.userauthentication.UserAuthenticationMediator;
import com.nokia.em.poseidon.services.userauthentication.UserAuthenticationService;
import com.nokia.em.poseidon.services.userauthentication.event.AddListenerEvent;
import com.nokia.em.poseidon.services.userauthentication.event.CurrentStateEvent;
import com.nokia.em.poseidon.services.userauthentication.event.EventInterceptor;
import com.nokia.em.poseidon.services.userauthentication.event.EventTransmitter;
import com.nokia.em.poseidon.services.userauthentication.event.GetCurrentStateEvent;
import com.nokia.em.poseidon.services.userauthentication.event.RemoveListenerEvent;
import com.nokia.em.poseidon.services.userauthentication.event.StatusEvent;
import com.nokia.em.poseidon.util.concurrency.ThreadPool;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserAuthenticationServiceImpl
extends PluginRegistryListenerAdapter
implements UserAuthenticationService,
Service {
    private Logger myLogger;
    private Set<EventInterceptor> myMediators;
    private Set<EventInterceptor> myListeners;
    private ThreadPool myThreadPool = ThreadPool.getInstance();

    private void initMediator(UserAuthenticationMediator mediator) {
        this.myLogger.debug("Adding user authentication mediator: " + mediator);
        this.sendSyncEvent(mediator, new AddListenerEvent(this, this));
        this.myMediators.add(mediator);
        this.sendEvent(this.myMediators, new GetCurrentStateEvent(this));
    }

    private void sendEvent(Collection<EventInterceptor> recipients, EventObject event) {
        for (EventInterceptor interceptor : recipients) {
            this.myThreadPool.execute(new EventTransmitter(interceptor, event));
        }
    }

    private void sendSyncEvent(EventInterceptor recipient, EventObject event) {
        this.myLogger.debug("Requesting interceptor " + recipient + " to process synchronous event: " + event);
        recipient.processEvent(event);
    }

    @Override
    public void processEvent(EventObject event) {
        Object source = event.getSource();
        if (source instanceof UserAuthenticationListener) {
            if (event instanceof AddListenerEvent) {
                EventInterceptor listener = ((AddListenerEvent)event).getListener();
                if (this.myListeners.add(listener)) {
                    this.myLogger.debug("Added user authentication listener: " + listener);
                }
            } else if (event instanceof RemoveListenerEvent) {
                EventInterceptor listener = ((RemoveListenerEvent)event).getListener();
                if (this.myListeners.remove(listener)) {
                    this.myLogger.debug("Removed user authentication listener: " + listener);
                }
            } else {
                this.sendEvent(this.myMediators, event);
                if (this.myMediators.isEmpty() && event instanceof GetCurrentStateEvent) {
                    this.sendEvent(this.myListeners, new CurrentStateEvent(this, StatusEvent.STATUS.NOT_AVAILABLE, "", null));
                }
            }
        } else if (source instanceof UserAuthenticationMediator) {
            this.sendEvent(this.myListeners, event);
        }
    }

    @Override
    public void start() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myMediators = new HashSet<EventInterceptor>();
        this.myListeners = new HashSet<EventInterceptor>();
        for (UserAuthenticationMediator mediator : PoseidonRuntime.getRuntime().getObjects(UserAuthenticationMediator.class)) {
            this.initMediator(mediator);
        }
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).addRegistryListener(this);
        this.myLogger.debug("User Authentication service initialized");
    }

    @Override
    public void stop() {
        PoseidonRuntime.getRuntime().getRegistry(ObjectRegistry.class).removeRegistryListener(this);
        this.myMediators.clear();
        this.myListeners.clear();
    }

    @Override
    public void itemAdded(PluginRegistryEvent event) {
        if (event.getPlugin() instanceof UserAuthenticationMediator) {
            this.initMediator((UserAuthenticationMediator)event.getPlugin());
        }
    }

    @Override
    public void itemRemoved(PluginRegistryEvent event) {
        if (event.getPlugin() instanceof UserAuthenticationMediator && this.myMediators.remove(event.getPlugin())) {
            this.myLogger.debug("Removed user authentication mediator: " + event.getPlugin());
        }
    }
}

