/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.snapshot.view;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.event.EventProcessor;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserController;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserDefaultValidator;
import com.nokia.em.poseidon.gui.savechooser.SaveChooserModel;
import com.nokia.em.poseidon.gui.snapshot.PSaveSnapshotView;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotSaveAvailability;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotViewUtils;
import com.nokia.em.poseidon.services.conninfo.BasicConnectionFilter;
import com.nokia.em.poseidon.services.conninfo.ConnectionEvent;
import com.nokia.em.poseidon.services.conninfo.ConnectionInfo;
import com.nokia.em.poseidon.services.conninfo.ConnectionStatus;
import com.nokia.em.poseidon.services.snapshot.PSaveSnapshotModules;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.snapshot.view.SaveSnapshotView;
import com.nokia.em.poseidon.snapshot.view.handler.DefaultDestroyHandler;
import com.nokia.em.poseidon.snapshot.view.handler.DefaultModuleHandler;
import com.nokia.em.poseidon.snapshot.view.handler.DefaultViewHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotDialogGUIHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotDialogHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotModuleHandler;
import com.nokia.em.poseidon.snapshot.view.listener.DefaultSaveSnapshotViewListener;
import com.nokia.em.poseidon.snapshot.view.listener.observer.SaveSnapshotGUIViewListenerObserver;
import com.nokia.em.poseidon.snapshot.view.listener.observer.manager.SaveSnapshotViewListenerObserverManager;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import org.apache.log4j.Logger;

public class SaveSnapshotGUIView
extends SaveChooserController
implements EventProcessor,
SaveSnapshotView {
    public static final String SNAPSHOT_FILE_SW_VERSION = "SNAPSHOT_FILE_SW_VERSION";
    public static final String SNAPSHOT_FILE_DIST_NAME = "SNAPSHOT_FILE_DIST_NAME";
    private static final String SEPARATOR = "_";
    private boolean myIsSnapshotOngoing;
    protected final SimpleDateFormat myFormat = new SimpleDateFormat("yyyyMMdd-HHmm");
    protected ResourceBundle myResourceBundle;
    protected Logger myLogger;
    protected String mySiteName = "";
    protected PSnapshotConst.SNAPSHOT_LEVEL myLevel;
    protected String myNotes = "";
    protected PSettings mySettings;
    private boolean myIsFirstime;
    private SaveSnapshotModuleHandler myModuleHandler;
    private SaveSnapshotDialogHandler myDialogHandler;

    public SaveSnapshotGUIView() {
        this((List<PSnapshotConst.SNAPSHOT_LEVEL>)null);
    }

    public SaveSnapshotGUIView(List<PSnapshotConst.SNAPSHOT_LEVEL> disabledLevels) throws IllegalArgumentException {
        this.initSettings();
        this.initModuleHandler();
        this.initDialogHandler();
        this.addObjectToRuntime();
        this.initSaveAvailability();
        this.initFileChooser();
        this.initView(disabledLevels);
        this.startSavingSnapshot();
    }

    private void initSettings() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myResourceBundle = I18n.getI18n().getBaseBundle();
        this.mySettings = PSettings.getInstance();
    }

    private void initModuleHandler() {
        this.myModuleHandler = new DefaultModuleHandler();
    }

    private void initDialogHandler() {
        this.myDialogHandler = new SaveSnapshotDialogGUIHandler();
    }

    private void addObjectToRuntime() {
        PoseidonRuntime.getRuntime().addObject(this);
    }

    private void initSaveAvailability() {
        PSnapshotSaveAvailability ps = (PSnapshotSaveAvailability)PoseidonRuntime.getRuntime().getRuntimeProperty("SAVE_SNAPSHOT_FUNCTION_AVAILABLE");
        if (ps != null) {
            ps.setSaveSnapshotController(this);
        }
    }

    private void initFileChooser() {
        SaveChooserModel model = this.getModel();
        model.setSettingsKey("SnapshotPreviousFileLocation");
        model.setDialogTitle(this.myResourceBundle.getString("PSaveSnapshotAsView_Title"));
        model.setFileFilter(PSnapshotViewUtils.createFileFilter(this.mySettings.get("snapshotFileType", "zip")));
        PSnapshotServiceImpl service = PoseidonRuntime.getRuntime().getService(PSnapshotServiceImpl.class);
        model.setDefaultPath(service.getSaveLocation());
        this.myIsFirstime = true;
        model.setFileValidator(new SaveSnapshotChooserCustomValidator(model));
    }

    private void initView(List<PSnapshotConst.SNAPSHOT_LEVEL> disabledLevels) {
        PSaveSnapshotView view = new PSaveSnapshotView(this, PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
        view.setDisabledLevels(disabledLevels);
        this.setView(view);
        this.setVisible(true);
    }

    @Override
    public void startSavingSnapshot() {
        File file = this.selectFile();
        if (file != null) {
            SaveSnapshotViewListenerObserverManager.addListener(new SaveSnapshotGUIViewListenerObserver(this));
            DefaultSaveSnapshotViewListener saver = new DefaultSaveSnapshotViewListener(this.myModuleHandler, new DefaultViewHandler((PSaveSnapshotView)this.getView()), new DefaultDestroyHandler(this), this.myDialogHandler);
            saver.startSavingSnapshot(this.myLevel, file, this.myNotes);
        } else {
            PoseidonRuntime.getRuntime().removeObject(this);
            this.destroy();
        }
    }

    protected String createFileName() {
        ConnectionEvent event;
        String distName = this.getDistName();
        String softwareReleaseVersion = this.getSWReleaseVersion();
        ConnectionInfo connectionInfoService = PoseidonRuntime.getRuntime().getService(ConnectionInfo.class);
        if (connectionInfoService != null && (event = connectionInfoService.getLatestConnectionEvent(new BasicConnectionFilter(ConnectionStatus.CONNECTED))) != null) {
            this.mySiteName = event.getNetworkElementName();
        }
        this.mySiteName = this.mySiteName != null && this.mySiteName.length() > 0 ? String.valueOf(this.mySiteName.replaceAll(" ", "")) + SEPARATOR : this.myResourceBundle.getString("unknown_Text");
        return "Snapshot_" + distName + softwareReleaseVersion + this.mySiteName + this.myFormat.format(new Date()) + "." + this.mySettings.get("snapshotFileType", "zip");
    }

    protected String getSWReleaseVersion() {
        if (PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_SW_VERSION) == null) {
            return "";
        }
        return (String)PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_SW_VERSION);
    }

    protected String getDistName() {
        if (PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_DIST_NAME) == null) {
            return "";
        }
        return (String)PoseidonRuntime.getRuntime().getRuntimeProperty(SNAPSHOT_FILE_DIST_NAME);
    }

    public static String format(String property) {
        if (property.trim().length() == 0) {
            return "";
        }
        return String.valueOf(property.trim()) + SEPARATOR;
    }

    @Override
    public void setLevel(PSnapshotConst.SNAPSHOT_LEVEL level) {
        this.myLevel = level;
    }

    @Override
    public PSnapshotConst.SNAPSHOT_LEVEL getLevel() {
        return this.myLevel;
    }

    @Override
    public void setNotes(String notes) {
        this.myNotes = notes;
    }

    public void setSnapshotOngoing(boolean isSnapshotOngoing) {
        this.myIsSnapshotOngoing = isSnapshotOngoing;
    }

    public boolean isSnapshotOngoing() {
        return this.myIsSnapshotOngoing;
    }

    public boolean isCancelled() {
        return this.myDialogHandler.isCancelled();
    }

    public void hideProgressDialog() {
        this.myDialogHandler.hideProgressDialog();
    }

    @Override
    public void setModules(List<PSaveSnapshotModules> modules) {
        this.myModuleHandler.setModules(modules);
    }

    @Override
    public List<PSaveSnapshotModules> getModules() {
        return this.myModuleHandler.getModules();
    }

    @Override
    public void processEvent(EventObject event) {
    }

    private final class SaveSnapshotChooserCustomValidator
    extends SaveChooserDefaultValidator {
        private final SaveChooserModel mySaveChooserModel;

        private SaveSnapshotChooserCustomValidator(SaveChooserModel model) {
            this.mySaveChooserModel = model;
        }

        private File checkFileNameUniqueness(String defaultFilename) {
            String currentDirectory = ((PSaveSnapshotView)SaveSnapshotGUIView.this.myView).getCurrentDirectory() + System.getProperty("file.separator");
            File defaultFile = new File(String.valueOf(currentDirectory) + defaultFilename);
            return defaultFile.exists() ? ((PSaveSnapshotView)SaveSnapshotGUIView.this.myView).createAlternativeDefaultFile(defaultFile) : defaultFile;
        }

        @Override
        public boolean validateSelection(File selectedFile) {
            if (SaveSnapshotGUIView.this.myIsFirstime) {
                SaveSnapshotGUIView.this.myIsFirstime = false;
                String originalFilename = SaveSnapshotGUIView.this.createFileName();
                String fileName = PFileUtils.removeInvalidCharacters(originalFilename);
                File validSelectedFile = this.checkFileNameUniqueness(fileName);
                this.mySaveChooserModel.setDefaultFileName(validSelectedFile.getName());
                ((PSaveSnapshotView)SaveSnapshotGUIView.this.myView).setSelectedFile(validSelectedFile);
                if (!fileName.equals(originalFilename)) {
                    this.myMessageMap.put("Save.InvalidFileHeader", this.myResourceBundle.getString("PSaveSnapshotView_invalidSiteName_header"));
                    this.myMessageMap.put("Save.InvalidFileBody", this.myResourceBundle.getString("PSaveSnapshotView_invalidSiteName_text"));
                    return false;
                }
                return true;
            }
            return super.validateSelection(selectedFile);
        }
    }
}

