/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.snapshot.view.handler;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.progress.step.PStepProgressTask;
import com.nokia.em.poseidon.plugin.registry.PluginRegistryEvent;
import com.nokia.em.poseidon.services.snapshot.PSnapshotChangeListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.em.poseidon.services.snapshot.PSnapshotServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MediatorStatusHandler {
    private Logger myLogger = Logger.getLogger(this.getClass());
    private Map<PSnapshotMediator, PSnapshotServiceImpl.State> myMediatorToStatus = new HashMap<PSnapshotMediator, PSnapshotServiceImpl.State>();
    private Map<PStepProgressTask, PSnapshotMediator> myTaskToMediator = new HashMap<PStepProgressTask, PSnapshotMediator>();

    public MediatorStatusHandler(PSnapshotChangeListener listener) {
        for (PSnapshotMediator mediator : PoseidonRuntime.getRuntime().getObjects(PSnapshotMediator.class)) {
            mediator.addSnapshotChangeListener(listener);
            this.myMediatorToStatus.put(mediator, PSnapshotServiceImpl.State.RUNNING);
        }
    }

    public PSnapshotServiceImpl.State getStateOfMediator(PSnapshotMediator mediator) {
        return this.myMediatorToStatus.get(mediator);
    }

    public void clearMediators(PSnapshotChangeListener listener) {
        for (PSnapshotMediator mediator : this.myMediatorToStatus.keySet()) {
            mediator.removeSnapshotChangeListener(listener);
        }
        this.myMediatorToStatus.clear();
        this.myTaskToMediator.clear();
    }

    public List<PSnapshotMediator> getMediators(PSnapshotServiceImpl.State state) {
        ArrayList<PSnapshotMediator> mediators = new ArrayList<PSnapshotMediator>();
        for (PSnapshotMediator mediator : this.myMediatorToStatus.keySet()) {
            if (!state.equals((Object)this.getStateOfMediator(mediator))) continue;
            mediators.add(mediator);
        }
        return mediators;
    }

    public void setMediatorState(PSnapshotMediator mediator, PSnapshotServiceImpl.State state) {
        if (mediator == null) {
            throw new NullPointerException("Snapshot mediator cannot be null.");
        }
        this.myMediatorToStatus.put(mediator, state);
    }

    public void resetMediators() {
        Iterator<PSnapshotMediator> iter = this.myMediatorToStatus.keySet().iterator();
        while (iter.hasNext()) {
            this.setMediatorState(iter.next(), PSnapshotServiceImpl.State.RUNNING);
        }
        this.myTaskToMediator.clear();
    }

    public Iterator getMediatorIterator() {
        return this.myMediatorToStatus.keySet().iterator();
    }

    public void remove(PluginRegistryEvent pluginEvent) {
        this.myMediatorToStatus.remove(pluginEvent.getPlugin());
    }

    public void add(PluginRegistryEvent event, PSnapshotChangeListener listener) {
        Object mediator = event.getPlugin();
        if (mediator instanceof PSnapshotMediator && !this.myMediatorToStatus.containsKey(event.getPlugin())) {
            this.myLogger.debug("Adding snapshot mediator: " + event.getPlugin());
            ((PSnapshotMediator)mediator).addSnapshotChangeListener(listener);
            this.myMediatorToStatus.put((PSnapshotMediator)mediator, PSnapshotServiceImpl.State.RUNNING);
        }
    }

    public boolean isAllMediatorFinished() {
        return this.myMediatorToStatus.size() == this.getMediators(PSnapshotServiceImpl.State.COMPLETED).size() + this.getMediators(PSnapshotServiceImpl.State.FAILED).size() + this.getMediators(PSnapshotServiceImpl.State.CANCELLED).size() + this.getMediators(PSnapshotServiceImpl.State.FAILED_DISK_FULL).size();
    }

    public PSnapshotMediator getMediatorUsingTask(PStepProgressTask task) {
        return this.myTaskToMediator.get(task);
    }

    public void addTasksFromMediators(PSnapshotConst.SNAPSHOT_LEVEL level, List<PStepProgressTask> progressTasklist) {
        Iterator iter = this.getMediatorIterator();
        while (iter.hasNext()) {
            PSnapshotMediator mediator = (PSnapshotMediator)iter.next();
            PStepProgressTask task = mediator.getSnapshotSavingTasks(level);
            if (task == null) continue;
            progressTasklist.add(task);
            this.addChildTasksToMap(this.myTaskToMediator, task, mediator);
        }
    }

    private void addChildTasksToMap(Map<PStepProgressTask, PSnapshotMediator> map, PStepProgressTask task, PSnapshotMediator mediator) {
        map.put(task, mediator);
        List<PStepProgressTask> children = task.getChildTasks();
        if (children.size() > 0) {
            for (PStepProgressTask progressTask : children) {
                this.addChildTasksToMap(map, progressTask, mediator);
            }
        }
    }
}

