/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.snapshot.view.handler;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.gui.common.CloseConfirmationMessage;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.snapshot.controller.additionalinfo.SaveSnapshotAdditionalInfoController;
import com.nokia.em.poseidon.snapshot.controller.additionalinfo.SaveSnapshotAdditionalInfoControllerImpl;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotDialogHandler;
import com.nokia.em.poseidon.snapshot.view.listener.observer.event.SaveSnapshotViewListenerEvent;
import com.nokia.em.poseidon.snapshot.view.listener.observer.manager.SaveSnapshotViewListenerObserverManager;
import com.nokia.widgets.progress.ProgressDialogController;
import com.nokia.widgets.progress.ProgressFactory;
import com.nokia.widgets.progress.models.ProgressDialogModel;
import com.nokia.widgets.progress.models.StepProgressModel;
import com.nokia.widgets.progress.views.ProgressDialogCloseListener;
import com.nokia.widgets.progress.views.ProgressGuiEvent;
import java.awt.Dimension;
import java.util.Optional;
import javax.swing.SwingUtilities;

public class SaveSnapshotDialogGUIHandler
implements SaveSnapshotDialogHandler {
    private static final int DIALOG_WIDTH_OFFSET = 100;
    private ResourceBundle myResourceBundle = I18n.getI18n().getBaseBundle();
    private SaveSnapshotAdditionalInfoController myAdditionalInfoController = new SaveSnapshotAdditionalInfoControllerImpl();
    private ProgressDialogController myProgressDialogController;
    private static CloseConfirmationMessage myCloseMsg;

    public SaveSnapshotDialogGUIHandler() {
        myCloseMsg = PoseidonRuntime.getRuntime().getObject(CloseConfirmationMessage.class);
    }

    @Override
    public void createDialogController() {
        ProgressDialogModel dialogModel = this.createDialogModel();
        this.myProgressDialogController = ProgressFactory.createStepProgressDialog(PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame(), dialogModel);
        StepProgressModel progressModel = (StepProgressModel)this.myProgressDialogController.getProgressControllerModel();
        progressModel.setEstimatedDurationVisible(false);
        this.myProgressDialogController.getModel().setActionButtonEnabled(false);
        this.myProgressDialogController.getView().setResizable(true);
        this.myProgressDialogController.setCloseListener(new ProgressDialogCloseListener(){

            @Override
            public void closeRequest() {
                if (SaveSnapshotDialogGUIHandler.this.myProgressDialogController.getProgressControllerModel().getProgressState() != 1) {
                    if (myCloseMsg.closeAndStopRequested(SaveSnapshotDialogGUIHandler.this.myProgressDialogController.getView(), SaveSnapshotDialogGUIHandler.this.myResourceBundle.getString("PSaveSnapshotController_Saving_Title"), SaveSnapshotDialogGUIHandler.this.myResourceBundle.getString("PSaveSnapshotController_Saving_Operation_Text"))) {
                        SaveSnapshotDialogGUIHandler.this.myProgressDialogController.guiUpdated(new ProgressGuiEvent("cancelaction"));
                    } else {
                        return;
                    }
                }
                SaveSnapshotViewListenerObserverManager.notifyListeners(new SaveSnapshotViewListenerEvent(SaveSnapshotViewListenerEvent.DESTROY));
                SaveSnapshotDialogGUIHandler.this.myProgressDialogController.destroy();
            }
        });
    }

    private ProgressDialogModel createDialogModel() {
        ProgressDialogModel dialogModel = new ProgressDialogModel();
        dialogModel.setAdditionalInfo(this.myAdditionalInfoController.getAdditionalInfo());
        dialogModel.setTitle(this.myResourceBundle.getString("PSaveSnapshotController_Saving_Title"));
        dialogModel.setHeadingText(this.myResourceBundle.getString("PSaveSnapshotController_Saving_Header"));
        return dialogModel;
    }

    @Override
    public void displayProgressDialog() {
        this.myProgressDialogController.getProgressController().start(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int dialogWidth = SaveSnapshotDialogGUIHandler.this.myProgressDialogController.getView().getWidth();
                int dialogHeight = SaveSnapshotDialogGUIHandler.this.myProgressDialogController.getView().getHeight();
                SaveSnapshotDialogGUIHandler.this.myProgressDialogController.getView().setMinimumSize(new Dimension(dialogWidth + 100, dialogHeight));
                SaveSnapshotDialogGUIHandler.this.myProgressDialogController.show();
            }
        });
    }

    @Override
    public void updateProgressStepModelForDialogController() {
        StepProgressModel progressModel = (StepProgressModel)this.myProgressDialogController.getProgressControllerModel();
        if (progressModel.getVisibleSteps().size() >= 17) {
            progressModel.setUseScrolling(true);
        } else {
            progressModel.setUseScrolling(false);
        }
    }

    @Override
    public ProgressDialogController getDialogController() {
        return this.myProgressDialogController;
    }

    @Override
    public void invokeOperationFinished() {
        if (this.myProgressDialogController != null) {
            myCloseMsg.operationFinished(this.myProgressDialogController.getView());
        }
    }

    @Override
    public void enableActionButton() {
        this.myProgressDialogController.getModel().setActionButtonEnabled(true);
    }

    @Override
    public boolean isCancelled() {
        return this.myProgressDialogController.getProgressControllerModel().isCanceled();
    }

    @Override
    public void hideProgressDialog() {
        Optional.ofNullable(this.myProgressDialogController).ifPresent(ProgressDialogController::hide);
    }
}

