/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.snapshot.view.handler;

import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotMediator;
import com.nokia.em.poseidon.services.snapshot.operations.Saver;
import com.nokia.em.poseidon.snapshot.view.handler.MediatorStatusHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SnapshotExecutionHandler;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.ExecutorCompletionService;

public class ThreadedExecutionHandler
implements SnapshotExecutionHandler {
    private MediatorStatusHandler myMediatorHandler;
    private ExecutorCompletionService<Boolean> myExecutorService;

    public ThreadedExecutionHandler(MediatorStatusHandler mediatorHandler, ExecutorCompletionService<Boolean> executorService) {
        this.myMediatorHandler = mediatorHandler;
        this.myExecutorService = executorService;
    }

    private void runSavers(PSnapshotConst.SNAPSHOT_LEVEL level, File snapshotTempDir) throws MalformedURLException {
        URL mediatorUrl = null;
        Iterator iter = this.myMediatorHandler.getMediatorIterator();
        while (iter.hasNext()) {
            File file;
            PSnapshotMediator mediator = (PSnapshotMediator)iter.next();
            if (mediator.getDescription() == null || (file = PFileUtils.createDirectory(snapshotTempDir, mediator.getDescription().getStringProperty("internalName"))) == null) continue;
            mediatorUrl = file.toURI().toURL();
            this.myExecutorService.submit(new Saver(mediator, mediatorUrl, level), Boolean.TRUE);
        }
    }

    @Override
    public void execute(PSnapshotConst.SNAPSHOT_LEVEL level, File snapshotTempDir) throws MalformedURLException {
        this.runSavers(level, snapshotTempDir);
    }
}

