/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.snapshot.view.listener;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.gui.snapshot.PSnapshotController;
import com.nokia.em.poseidon.services.snapshot.PSnapshotConst;
import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListener;
import com.nokia.em.poseidon.services.snapshot.PSnapshotGuiListenerEvent;
import com.nokia.em.poseidon.services.snapshot.listener.SaveSnapshotGUIServiceListenerImpl;
import com.nokia.em.poseidon.services.snapshot.observer.manager.SnapshotSavingObserverManager;
import com.nokia.em.poseidon.snapshot.controller.guilistener.SaveSnapshotGUIListenerController;
import com.nokia.em.poseidon.snapshot.controller.guilistener.SaveSnapshotGUIListenerControllerImpl;
import com.nokia.em.poseidon.snapshot.controller.snapshotsaving.SaveSnapshotControllerImpl;
import com.nokia.em.poseidon.snapshot.controller.snapshotsaving.SaveSnapshotWithCancelController;
import com.nokia.em.poseidon.snapshot.view.factory.StepProgressAdapterFactory;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotDestroyHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotDialogHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotModuleHandler;
import com.nokia.em.poseidon.snapshot.view.handler.SaveSnapshotViewHandler;
import com.nokia.em.poseidon.snapshot.view.listener.SaveSnapshotViewListener;
import com.nokia.em.poseidon.snapshot.view.listener.observer.event.SaveSnapshotViewListenerEvent;
import com.nokia.em.poseidon.snapshot.view.listener.observer.manager.SaveSnapshotViewListenerObserverManager;
import com.nokia.em.poseidon.snapshot.view.listener.request.object.SnapshotRequestObject;
import com.nokia.widgets.progress.ProgressDialogController;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class DefaultSaveSnapshotViewListener
implements PSnapshotGuiListener,
SaveSnapshotViewListener {
    private Logger myLogger = Logger.getLogger(this.getClass());
    private SaveSnapshotModuleHandler myModuleHandler;
    private SaveSnapshotViewHandler myViewHandler;
    private SaveSnapshotDestroyHandler myDestroyHandler;
    private SaveSnapshotGUIListenerController myGUIListenerController;
    private SaveSnapshotWithCancelController mySaveSnapshotController;
    private SaveSnapshotDialogHandler myDialogHandler;

    public DefaultSaveSnapshotViewListener(SaveSnapshotModuleHandler moduleHandler, SaveSnapshotViewHandler viewHandler, SaveSnapshotDestroyHandler destroyHandler, SaveSnapshotDialogHandler dialogHandler) {
        this.myModuleHandler = moduleHandler;
        this.myViewHandler = viewHandler;
        this.myDestroyHandler = destroyHandler;
        this.myDialogHandler = dialogHandler;
        this.mySaveSnapshotController = new SaveSnapshotControllerImpl();
        this.myGUIListenerController = new SaveSnapshotGUIListenerControllerImpl();
    }

    @Override
    public void startSavingSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes) {
        SnapshotSavingObserverManager.removeAll();
        this.myGUIListenerController.addGuiListener(this);
        this.myDialogHandler.createDialogController();
        ProgressDialogController progressDialogController = this.myDialogHandler.getDialogController();
        if (progressDialogController != null) {
            SnapshotSavingObserverManager.addListener(new SaveSnapshotGUIServiceListenerImpl(StepProgressAdapterFactory.createAdapter(progressDialogController)));
        }
        try {
            this.saveSnapshot(new SnapshotRequestObject(level, location, notes));
            this.myDialogHandler.updateProgressStepModelForDialogController();
            SaveSnapshotViewListenerObserverManager.notifyListeners(new SaveSnapshotViewListenerEvent(SaveSnapshotViewListenerEvent.TURN_SNAPSHOT_ONGOING, Boolean.TRUE));
            this.myDialogHandler.displayProgressDialog();
        }
        catch (MalformedURLException exception) {
            this.handleMalformeURLException(exception);
            SnapshotSavingObserverManager.removeAll();
        }
    }

    @Override
    public void startSavingSnapshot(PSnapshotConst.SNAPSHOT_LEVEL level, File location, String notes, int cancelAfter) {
        this.startSavingSnapshot(level, location, notes);
        this.cancelAfter(cancelAfter);
    }

    private void cancelAfter(int cancelAfter) {
        TimerTask tasknew = new TimerTask(){

            @Override
            public void run() {
                if (DefaultSaveSnapshotViewListener.this.mySaveSnapshotController.isSnapshotOngoing()) {
                    DefaultSaveSnapshotViewListener.this.myLogger.debug("Cancelling snapshot..");
                    DefaultSaveSnapshotViewListener.this.mySaveSnapshotController.cancel();
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(tasknew, cancelAfter * 1000);
    }

    private void saveSnapshot(SnapshotRequestObject snapshotRequestObject) throws MalformedURLException {
        if (this.myModuleHandler.getModules() != null && this.myModuleHandler.getModules().size() > 0) {
            this.mySaveSnapshotController.saveSnapshot(snapshotRequestObject, this.myModuleHandler.getSelectedModules());
        } else {
            this.mySaveSnapshotController.saveSnapshot(snapshotRequestObject);
        }
    }

    private void handleMalformeURLException(MalformedURLException exception) {
        this.myLogger.error("Snapshot temporary directories cannot be created" + exception);
        this.myGUIListenerController.removeGuiListener(this);
        PoseidonRuntime.getRuntime().removeObject(this);
        this.myViewHandler.showMessage(PSnapshotController.ErrorType.CANNOT_CREATE_TEMP_DIR);
        SaveSnapshotViewListenerObserverManager.notifyListeners(new SaveSnapshotViewListenerEvent(SaveSnapshotViewListenerEvent.DESTROY));
    }

    @Override
    public void operationStarted(PSnapshotGuiListenerEvent event) {
    }

    @Override
    public void operationFinished(PSnapshotGuiListenerEvent event) {
        SaveSnapshotViewListenerObserverManager.notifyListeners(new SaveSnapshotViewListenerEvent(SaveSnapshotViewListenerEvent.TURN_SNAPSHOT_ONGOING, Boolean.FALSE));
        this.myGUIListenerController.removeGuiListener(this);
        this.myDialogHandler.invokeOperationFinished();
        PSnapshotGuiListenerEvent.Type eventType = event.getType();
        if (!this.myDestroyHandler.isDestroyed()) {
            boolean isMediatorDiskIsFull = PSnapshotGuiListenerEvent.Type.MEDIATOR_FAILED_DISK_FULL.equals((Object)eventType);
            boolean isMediatorFailed = PSnapshotGuiListenerEvent.Type.MEDIATORS_FAILED_SAVING.equals((Object)eventType);
            if (isMediatorFailed || isMediatorDiskIsFull) {
                this.myLogger.warn("Snapshot saving finished with errors, Failed mediators and tasks: " + event);
                PSnapshotController.ErrorType error = isMediatorFailed ? PSnapshotController.ErrorType.MEDIATORS_FAILED_SAVING : PSnapshotController.ErrorType.MEDIATOR_FAILED_DISK_FULL;
                this.myViewHandler.showMessage(error, event.getInfo());
            } else if (PSnapshotGuiListenerEvent.Type.SNAPSHOT_SAVING_FAILED.equals((Object)eventType)) {
                this.myLogger.error("Snapshot saving failed " + event);
                this.myViewHandler.showMessage(PSnapshotController.ErrorType.SAVING_FAILED, event.getInfo());
            } else if (PSnapshotGuiListenerEvent.Type.SNAPSHOT_COPYING_FAILED.equals((Object)eventType)) {
                this.myLogger.error("Copying snapshot file to destination failed " + event);
                this.myViewHandler.showMessage(PSnapshotController.ErrorType.COPYING_FAILED, event.getInfo());
            } else {
                this.myLogger.debug("Snapshot saving finished successfully");
            }
        } else {
            this.myLogger.debug("Snapshot saving dialog closed forcefully");
        }
        if (PSnapshotGuiListenerEvent.Type.SUCCESS.equals((Object)eventType)) {
            this.myDialogHandler.enableActionButton();
        }
        SaveSnapshotViewListenerObserverManager.removeAll();
    }
}

