/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util;

import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.util.GPSValue;
import com.nokia.em.poseidon.util.TextUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class CoordinatesUtils {
    public static final String DEGREE_NAME = "degree";
    public static final String MINUTE_NAME = "minute";
    public static final String SECOND_NAME = "second";
    public static final String DEGREE_SYMBOL = "\u00b0";
    public static final String MINUTE_SYMBOL = "'";
    public static final String SECOND_SYMBOL = "\"";
    public static final int DEGREES_MIN = 0;
    public static final int DEGREES_MAX_LATITUDE = 90;
    public static final int DEGREES_MAX_LONGITUDE = 180;
    public static final int DEGREES_STEP = 1;
    public static final int MINUTES_MIN = 0;
    public static final int MINUTES_MAX = 59;
    public static final int MINUTES_STEP = 1;
    public static final int SECONDS_MAX_DECIM_DIGITS = 2;
    public static final double SECONDS_MIN = 0.0;
    public static final double SECONDS_MAX = 59.99;
    public static final double SECONDS_STEP = 0.01;
    public static final String NORTH = "N";
    public static final String SOUTH = "S";
    public static final String EAST = "E";
    public static final String WEST = "W";
    public static final String DEFAULT = "";
    public static final BigDecimal TEN_MILLION = new BigDecimal("10000000");
    public static final int SCALE = TEN_MILLION.precision() - TEN_MILLION.scale() - 1;
    public static final BigDecimal SIXTY = new BigDecimal(60);
    public static final BigDecimal THREE_THOUSAND_SIX_HUNDRED = new BigDecimal(3600);
    public static final String CLIENT_PROPERTIES_KEY = "DMS";
    public static final int POSITIVE_VECTOR_INDEX = 1;
    public static final int NEGATIVE_VECTOR_INDEX = 2;
    private static final String BRACKET_OPEN = "[";
    private static final String BRACKET_CLOSE = "]";
    private static final String ELLIPSIS = "...";
    private static final String MIN_VALUE = "MIN";
    private static final String MAX_VALUE = "MAX";
    private static final int ZERO = 0;

    private CoordinatesUtils() {
    }

    public static String getDMSRange(String property) {
        StringBuilder range = new StringBuilder();
        range.append(BRACKET_OPEN);
        range.append(CoordinatesUtils.createDMSRangeValue(MIN_VALUE, property));
        range.append(ELLIPSIS);
        range.append(CoordinatesUtils.createDMSRangeValue(MAX_VALUE, property));
        range.append(BRACKET_CLOSE);
        return range.toString();
    }

    private static String createDMSRangeValue(String valueType, String property) {
        StringBuilder rangeValue = new StringBuilder();
        if (MIN_VALUE.equals(valueType)) {
            rangeValue.append(0);
        } else if (MAX_VALUE.equals(valueType)) {
            int maxRange = 0;
            if ("DMS latitude".equals(property)) {
                maxRange = 90;
            } else if ("DMS longitude".equals(property)) {
                maxRange = 180;
            }
            rangeValue.append(maxRange);
        }
        rangeValue.append(DEGREE_SYMBOL);
        rangeValue.append(0);
        rangeValue.append(MINUTE_SYMBOL);
        rangeValue.append(0);
        rangeValue.append(SECOND_SYMBOL);
        return rangeValue.toString();
    }

    public static void convertSCFValueToDMSValue(String value, GPSValue gpsValue) {
        BigDecimal valueBig = new BigDecimal(value);
        BigDecimal decimalDegrees = valueBig.divide(TEN_MILLION).abs();
        BigInteger degreesInt = decimalDegrees.toBigInteger();
        gpsValue.setDegrees(degreesInt.toString());
        BigDecimal minutesFromFormula = decimalDegrees.subtract(new BigDecimal(degreesInt)).multiply(SIXTY);
        BigInteger minutesInt = minutesFromFormula.toBigInteger();
        gpsValue.setMinutes(minutesInt.toString());
        BigDecimal secondsFromFormula = minutesFromFormula.subtract(new BigDecimal(minutesInt)).multiply(SIXTY);
        gpsValue.setSeconds(secondsFromFormula.setScale(2, RoundingMode.DOWN).toString());
    }

    public static String convertDMSValueToSCFValue(String degrees, String minutes, String seconds, boolean isNegative) {
        BigDecimal degreesDouble = BigDecimal.ZERO;
        BigDecimal minutesDouble = BigDecimal.ZERO;
        BigDecimal secondsDouble = BigDecimal.ZERO;
        if (TextUtils.isNumeric(degrees)) {
            degreesDouble = new BigDecimal(degrees);
        }
        if (TextUtils.isNumeric(minutes)) {
            minutesDouble = new BigDecimal(minutes);
        }
        if (TextUtils.isNumeric(seconds)) {
            secondsDouble = new BigDecimal(seconds);
        }
        BigDecimal bigSeconds = secondsDouble.divide(new BigDecimal(3600), SCALE, RoundingMode.CEILING);
        BigDecimal bigMinutes = minutesDouble.divide(new BigDecimal(60), SCALE, RoundingMode.CEILING);
        BigDecimal valueTimesTenM = bigSeconds.add(bigMinutes).add(degreesDouble).multiply(TEN_MILLION);
        if (isNegative) {
            valueTimesTenM = valueTimesTenM.negate();
        }
        return valueTimesTenM.toBigInteger().toString();
    }

    public static String getValidCoordinatesValue(RAMLParameter p) {
        return p != null && TextUtils.isNumeric(p.getValue()) ? String.valueOf(p.getValueAsInt()) : DEFAULT;
    }
}

