/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util;

import com.nokia.em.poseidon.util.PCmdLineParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PCmdLineParams {
    private static final String DEFAULT_PARAM_NAME_PREFIX = "-";
    private Map<String, List<String>> myParameters = new LinkedHashMap<String, List<String>>();
    private String myParamNamePrefix = "-";
    private List<PCmdLineParam> myParamList = new ArrayList<PCmdLineParam>();

    public PCmdLineParams() {
    }

    public PCmdLineParams(String[] params) {
        this(params, null);
    }

    public PCmdLineParams(String[] params, String paramPrefix) {
        if (paramPrefix != null) {
            this.myParamNamePrefix = paramPrefix;
        }
        if (params != null && params.length > 0) {
            this.parseParams(params);
        }
    }

    public List<String> getAllNames() {
        return new ArrayList<String>(this.myParameters.keySet());
    }

    public List<String> getNamesStartingWith(String name) {
        String loverCaseName = name.toLowerCase();
        ArrayList<String> list = new ArrayList<String>(this.myParameters.size());
        for (String key : this.myParameters.keySet()) {
            if (!key.startsWith(loverCaseName)) continue;
            list.add(key);
        }
        return list;
    }

    public boolean isDefined(String paramName) {
        return this.myParameters.containsKey(paramName.toLowerCase());
    }

    public List<PCmdLineParam> getParamList() {
        return this.myParamList;
    }

    public List<String> getValues(String paramName) {
        List<String> list = this.myParameters.get(paramName.toLowerCase());
        ArrayList<String> listToReturn = null;
        if (list != null) {
            listToReturn = new ArrayList<String>(list);
        }
        return listToReturn;
    }

    public String getFirstValue(String paramName) {
        List<String> list = this.myParameters.get(paramName.toLowerCase());
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseParamToList(Iterator<String> iter, String prevWord) {
        String word = "";
        String currentValue = "";
        if (prevWord.length() == 0) {
            if (!iter.hasNext()) return;
            word = iter.next();
        } else {
            word = prevWord;
        }
        if (word.startsWith(this.myParamNamePrefix)) {
            String currentParam = word.substring(this.myParamNamePrefix.length());
            if (!iter.hasNext()) {
                this.myParamList.add(new PCmdLineParam(currentParam, ""));
                return;
            }
            word = iter.next();
            if (word.startsWith(this.myParamNamePrefix)) {
                this.myParamList.add(new PCmdLineParam(currentParam, ""));
                this.parseParamToList(iter, word);
                return;
            }
            currentValue = word.startsWith("\"") && !word.endsWith("\"") ? this.parseQuoteBlock(word, iter) : (word.startsWith("\"") && word.endsWith("\"") && word.length() > 1 ? word.substring(1, word.length() - 1) : word);
            this.myParamList.add(new PCmdLineParam(currentParam, currentValue));
        }
        if (!iter.hasNext()) return;
        this.parseParamToList(iter, "");
    }

    protected void parseParams(String[] cmdParams) {
        List<String> cmdParamList = Arrays.asList(cmdParams);
        String currentParam = null;
        ArrayList<String> valueList = new ArrayList<String>();
        Iterator<String> iter = cmdParamList.iterator();
        String word = "";
        this.parseParamToList(iter, "");
        iter = cmdParamList.iterator();
        while (iter.hasNext()) {
            word = iter.next();
            if (word.startsWith(this.myParamNamePrefix)) {
                this.storeParamValues(currentParam, valueList);
                currentParam = word.substring(this.myParamNamePrefix.length());
                valueList = new ArrayList();
                continue;
            }
            if (word.startsWith("\"") && !word.endsWith("\"")) {
                valueList.add(this.parseQuoteBlock(word, iter));
                continue;
            }
            if (word.startsWith("\"") && word.endsWith("\"") && word.length() > 1) {
                word = word.substring(1, word.length() - 1);
                valueList.add(word);
                continue;
            }
            valueList.add(word);
        }
        this.storeParamValues(currentParam, valueList);
    }

    public void storeParamValues(String currentParam, List<String> valueList) {
        if (currentParam != null) {
            this.myParameters.put(currentParam.toLowerCase(), valueList);
        }
    }

    public void removeParameter(String parameterName) {
        this.myParameters.remove(parameterName);
    }

    private String parseQuoteBlock(String block, Iterator iter) {
        StringBuffer blockBuffer = new StringBuffer(block);
        while (iter.hasNext()) {
            String word = (String)iter.next();
            blockBuffer.append(' ');
            blockBuffer.append(word);
            if (word.endsWith("\"")) break;
        }
        if (blockBuffer.charAt(0) == '\"') {
            blockBuffer.deleteCharAt(0);
        }
        if (blockBuffer.charAt(blockBuffer.length() - 1) == '\"') {
            blockBuffer.deleteCharAt(blockBuffer.length() - 1);
        }
        return blockBuffer.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.myParameters.keySet()) {
            sb.append(String.valueOf(key) + ": ");
            if (this.myParameters.get(key) != null) {
                for (String value : this.myParameters.get(key)) {
                    sb.append(String.valueOf(value) + " ");
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

