/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util;

import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.file.PFileOutputStream;
import com.nokia.em.poseidon.util.file.PFileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PSettings {
    public static final String DEFAULT_FILE_EXTENSION = ".properties";
    public static final String DEFAULT_SETTINGS_NAME = "Poseidon";
    private static final String DEFAULT_STRING_VALUE = "";
    private static final char DEFAULT_CHAR_VALUE = '\u0000';
    private static final byte DEFAULT_BYTE_VALUE = 0;
    private static final int DEFAULT_INT_VALUE = 0;
    private static final long DEFAULT_LONG_VALUE = 0L;
    private static final float DEFAULT_FLOAT_VALUE = 0.0f;
    private static final double DEFAULT_DOUBLE_VALUE = 0.0;
    private static final boolean DEFAULT_BOOLEAN_VALUE = false;
    private static final String ARRAY_LENGTH_SPECIFIER = ".0";
    protected static final Map<String, PSettings> theSettingsMap = new HashMap<String, PSettings>();
    protected String myName = "";
    protected Properties myProperties = new Properties();
    protected Set<ChangeListener> myChangeListeners;
    protected Map<Class, Object> myClassToDefaultValue;
    protected Logger myLogger = Logger.getLogger(PSettings.class);
    protected Map<String, ChangeType> myChangedProperties = new HashMap<String, ChangeType>();

    protected PSettings(String name) {
        this.myName = name;
        this.myChangeListeners = new CopyOnWriteArraySet<ChangeListener>();
        this.myClassToDefaultValue = new HashMap<Class, Object>();
        this.myClassToDefaultValue.put(String.class, DEFAULT_STRING_VALUE);
        this.myClassToDefaultValue.put(Character.class, Character.valueOf('\u0000'));
        this.myClassToDefaultValue.put(Byte.class, (byte)0);
        this.myClassToDefaultValue.put(Integer.class, 0);
        this.myClassToDefaultValue.put(Long.class, 0L);
        this.myClassToDefaultValue.put(Float.class, Float.valueOf(0.0f));
        this.myClassToDefaultValue.put(Double.class, 0.0);
        this.myClassToDefaultValue.put(Boolean.class, false);
    }

    public static PSettings getInstance() {
        return PSettings.getInstance(DEFAULT_SETTINGS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSettings getInstance(String name) {
        Map<String, PSettings> map = theSettingsMap;
        synchronized (map) {
            PSettings settings;
            block10: {
                settings = theSettingsMap.get(name);
                if (settings == null) {
                    settings = new PSettings(name);
                    theSettingsMap.put(name, settings);
                    String tempName = PSettings.serachFileInOtherOS(name);
                    BufferedInputStream is = null;
                    File settingsFile = new File(String.valueOf(tempName) + DEFAULT_FILE_EXTENSION);
                    try {
                        try {
                            if (settingsFile.exists()) {
                                is = new BufferedInputStream(new FileInputStream(settingsFile));
                                settings.load(is);
                            }
                        }
                        catch (IOException e) {
                            Logger.getLogger(PSettings.class).warn("Failed to load settings from " + settingsFile + ", ignored.", e);
                            IOUtils.closeQuietly(is);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(is);
                }
            }
            return settings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String keyName, String defaultValue) {
        String value = null;
        boolean fileUpdated = false;
        Properties properties = this.myProperties;
        synchronized (properties) {
            value = (String)this.myProperties.get(keyName);
            if (value == null) {
                fileUpdated = true;
                value = String.valueOf(defaultValue);
                this.myProperties.setProperty(keyName, value);
            }
        }
        if (fileUpdated) {
            this.fireSettingChanged(keyName);
        }
        return value;
    }

    public Object get(String keyName) {
        return this.myProperties.get(keyName);
    }

    public void set(String keyName, String newValue) {
        this.myProperties.setProperty(keyName, newValue);
        this.fireSettingChanged(keyName);
    }

    public char get(String keyName, char defaultValue) {
        return this.get(keyName, String.valueOf(defaultValue)).charAt(0);
    }

    public void set(String keyName, char newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public byte get(String keyName, byte defaultValue) {
        return Byte.valueOf(this.get(keyName, String.valueOf(defaultValue)));
    }

    public void set(String keyName, byte newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public short get(String keyName, short defaultValue) {
        return Short.valueOf(this.get(keyName, String.valueOf(defaultValue)));
    }

    public void set(String keyName, short newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public int get(String keyName, int defaultValue) {
        return Integer.valueOf(this.get(keyName, String.valueOf(defaultValue)));
    }

    public void set(String keyName, int newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public long get(String keyName, long defaultValue) {
        return Long.valueOf(this.get(keyName, String.valueOf(defaultValue)));
    }

    public void set(String keyName, long newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public float get(String keyName, float defaultValue) {
        return Float.valueOf(this.get(keyName, String.valueOf(defaultValue))).floatValue();
    }

    public void set(String keyName, float newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public double get(String keyName, double defaultValue) {
        return Double.valueOf(this.get(keyName, String.valueOf(defaultValue)));
    }

    public void set(String keyName, double newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public boolean get(String keyName, boolean defaultValue) {
        return Boolean.valueOf(this.get(keyName, String.valueOf(defaultValue)));
    }

    public void set(String keyName, boolean newValue) {
        this.set(keyName, String.valueOf(newValue));
    }

    public String[] getSequence(String keyName, String[] defaultValues) {
        return (String[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, String[] values) {
        this.setObjectSequence(keyName, values);
    }

    public char[] getSequence(String keyName, char[] defaultValues) {
        return (char[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, char[] values) {
        this.setObjectSequence(keyName, values);
    }

    public byte[] getSequence(String keyName, byte[] defaultValues) {
        return (byte[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, byte[] values) {
        this.setObjectSequence(keyName, values);
    }

    public int[] getSequence(String keyName, int[] defaultValues) {
        return (int[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, int[] values) {
        this.setObjectSequence(keyName, values);
    }

    public long[] getSequence(String keyName, long[] defaultValues) {
        return (long[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, long[] values) {
        this.setObjectSequence(keyName, values);
    }

    public float[] getSequence(String keyName, float[] defaultValues) {
        return (float[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, float[] values) {
        this.setObjectSequence(keyName, values);
    }

    public double[] getSequence(String keyName, double[] defaultValues) {
        return (double[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, double[] values) {
        this.setObjectSequence(keyName, values);
    }

    public boolean[] getSequence(String keyName, boolean[] defaultValues) {
        return (boolean[])this.getObjectSequence(keyName, defaultValues);
    }

    public void setSequence(String keyName, boolean[] values) {
        this.setObjectSequence(keyName, values);
    }

    public void clear() {
        this.myProperties.clear();
        this.myChangedProperties.clear();
        this.fireSettingChanged(DEFAULT_STRING_VALUE);
    }

    public boolean isValueStored(String keyName) {
        return this.myProperties.containsKey(keyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSequenceStored(String keyName) {
        Properties properties = this.myProperties;
        synchronized (properties) {
            return this.myProperties.containsKey(String.valueOf(keyName) + ARRAY_LENGTH_SPECIFIER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSequenceLength(String keyName) {
        String arrayLengthKey = String.valueOf(keyName) + ARRAY_LENGTH_SPECIFIER;
        int length = -1;
        Properties properties = this.myProperties;
        synchronized (properties) {
            if (this.myProperties.containsKey(arrayLengthKey)) {
                try {
                    length = Integer.parseInt(this.get(arrayLengthKey, String.valueOf(length)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return length;
    }

    public void remove(String keyName) {
        if (this.myProperties.remove(keyName) != null) {
            this.fireSettingChanged(keyName);
        }
    }

    public void removeSequence(String keyName) {
        if (this.removeObjectSequence(keyName)) {
            this.fireSettingChanged(String.valueOf(keyName) + ".");
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.myChangeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.myChangeListeners.remove(listener);
    }

    public void load(String proertyFileName) {
        if (proertyFileName == null) {
            return;
        }
        BufferedInputStream inputStrean = null;
        try {
            try {
                File tmpFile;
                String tempName = PSettings.serachFileInOtherOS(proertyFileName);
                if (!tempName.endsWith(DEFAULT_FILE_EXTENSION)) {
                    tempName = String.valueOf(tempName) + DEFAULT_FILE_EXTENSION;
                }
                if ((tmpFile = new File(tempName)).exists()) {
                    inputStrean = new BufferedInputStream(new FileInputStream(new File(tempName)));
                    this.load(inputStrean);
                }
            }
            catch (IOException exception) {
                this.myLogger.error("Unable to load settings.", exception);
                IOUtils.closeQuietly(inputStrean);
            }
        }
        finally {
            IOUtils.closeQuietly(inputStrean);
        }
    }

    public void load(InputStream inStream) throws IOException {
        this.myProperties.load(inStream);
    }

    public void save(File proertyFile) {
        block6: {
            BufferedOutputStream outStream = null;
            try {
                try {
                    File tempFile = this.changeNotWritableFilePath(proertyFile);
                    if (!tempFile.exists()) {
                        tempFile.createNewFile();
                    }
                    outStream = new BufferedOutputStream(new PFileOutputStream(tempFile));
                    this.save(outStream);
                }
                catch (IOException exception) {
                    this.myLogger.error("Could not save settings.", exception);
                    IOUtils.closeQuietly(outStream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outStream);
                throw throwable;
            }
            IOUtils.closeQuietly(outStream);
        }
    }

    public void save(OutputStream outStream) throws IOException {
        this.myProperties.store(outStream, String.valueOf(this.myName) + " Settings File");
    }

    public boolean save() {
        boolean success;
        block8: {
            success = true;
            BufferedOutputStream outStream = null;
            Properties propertiesToSave = null;
            FileInputStream fis = null;
            try {
                try {
                    File file = this.getFileToSave();
                    file = this.changeNotWritableFilePath(file);
                    if (!file.exists()) {
                        if (!file.createNewFile()) {
                            this.myLogger.error("Cannot create settings file.");
                        }
                        propertiesToSave = this.myProperties;
                    } else {
                        Properties propertiesFromLatestFile = new Properties();
                        fis = new FileInputStream(file);
                        propertiesFromLatestFile.load(fis);
                        this.commitChanges(propertiesFromLatestFile);
                        propertiesToSave = propertiesFromLatestFile;
                    }
                    outStream = new BufferedOutputStream(new FileOutputStream(file));
                    propertiesToSave.store(outStream, String.valueOf(this.myName) + " Settings File");
                    ((OutputStream)outStream).flush();
                }
                catch (IOException e) {
                    success = false;
                    this.myLogger.error("Failed to save changes", e);
                    IOUtils.closeQuietly(outStream);
                    IOUtils.closeQuietly(fis);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outStream);
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly(outStream);
            IOUtils.closeQuietly(fis);
        }
        return success;
    }

    public Enumeration<Object> getPropertiesKeys() {
        return this.myProperties.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitChanges(Properties propertiesFromLatestFile) {
        Map<String, ChangeType> map = this.myChangedProperties;
        synchronized (map) {
            for (String key : this.myChangedProperties.keySet()) {
                ChangeType changeType = this.myChangedProperties.get(key);
                if (changeType == ChangeType.SINGLE_PARAMETER_UPDATED_OR_ADDED) {
                    propertiesFromLatestFile.put(key, this.myProperties.get(key));
                    continue;
                }
                if (changeType == ChangeType.SINGLE_PARAMETER_REMOVED) {
                    propertiesFromLatestFile.remove(key);
                    continue;
                }
                if (changeType == ChangeType.SEQUENCE_UPDATED_OR_ADDED) {
                    this.commitSequenceChange(key, propertiesFromLatestFile);
                    continue;
                }
                if (changeType != ChangeType.SEQUENCE_REMOVED) continue;
                this._removeSequence(key, propertiesFromLatestFile);
            }
        }
    }

    private void commitSequenceChange(String sequenceKey, Properties propertiesFromLatestFile) {
        this._removeSequence(sequenceKey, propertiesFromLatestFile);
        for (Object key : this.myProperties.keySet()) {
            if (!key.toString().startsWith(String.valueOf(sequenceKey) + ".")) continue;
            propertiesFromLatestFile.put(key, this.myProperties.get(key));
        }
    }

    private void _removeSequence(String key, Properties properties) {
        String sequenceKey = key;
        String arrayLengthName = String.valueOf(sequenceKey) + ARRAY_LENGTH_SPECIFIER;
        if (properties.containsKey(arrayLengthName)) {
            int length = Integer.parseInt((String)properties.get(arrayLengthName));
            properties.remove(arrayLengthName);
            if (length > 0) {
                sequenceKey = String.valueOf(sequenceKey) + ".";
                int i = 0;
                while (i < length) {
                    properties.remove(String.valueOf(sequenceKey) + (i + 1));
                    ++i;
                }
            }
        }
    }

    private File getFileToSave() {
        return new File(String.valueOf(this.myName) + DEFAULT_FILE_EXTENSION);
    }

    protected Object getObject(String keyName, Object defaultValue) {
        Object value = null;
        Class<?> defaultValueClass = defaultValue.getClass();
        String stringValue = this.get(keyName, defaultValue.toString());
        if (defaultValueClass == String.class) {
            return stringValue;
        }
        if (defaultValueClass == Character.class) {
            return Character.valueOf(stringValue.charAt(0));
        }
        try {
            Method method = defaultValueClass.getMethod("valueOf", String.class);
            value = method.invoke(defaultValueClass, stringValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectSequence(String keyName, Object defaultValues) {
        Object values = null;
        Properties properties = this.myProperties;
        synchronized (properties) {
            int length = this.getSequenceLength(keyName);
            if (length < 0 || defaultValues == null) {
                this.setObjectSequence(keyName, defaultValues);
                return defaultValues;
            }
            values = Array.newInstance(defaultValues.getClass().getComponentType(), length);
            String keyPrefix = String.valueOf(keyName) + ".";
            int idx = 0;
            while (idx < length) {
                if (idx < Array.getLength(defaultValues)) {
                    Array.set(values, idx, this.getObject(String.valueOf(keyPrefix) + (idx + 1), Array.get(defaultValues, idx)));
                } else {
                    Array.set(values, idx, this.getObject(String.valueOf(keyPrefix) + (idx + 1), this.myClassToDefaultValue.get(defaultValues.getClass().getComponentType())));
                }
                ++idx;
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setObjectSequence(String keyName, Object values) {
        Properties properties = this.myProperties;
        synchronized (properties) {
            this.removeObjectSequence(keyName);
            if (values == null) {
                return;
            }
            int length = Array.getLength(values);
            String arrayLengthName = String.valueOf(keyName) + ARRAY_LENGTH_SPECIFIER;
            this.myProperties.setProperty(arrayLengthName, String.valueOf(length));
            String itemKeyPrefix = String.valueOf(keyName) + ".";
            int idx = 0;
            while (idx < length) {
                this.myProperties.setProperty(String.valueOf(itemKeyPrefix) + (idx + 1), DEFAULT_STRING_VALUE + Array.get(values, idx));
                ++idx;
            }
        }
        this.fireSettingChanged(String.valueOf(keyName) + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeObjectSequence(String keyName) {
        boolean wasRemoved = false;
        int length = -1;
        String arrayLengthKey = String.valueOf(keyName) + ARRAY_LENGTH_SPECIFIER;
        Properties properties = this.myProperties;
        synchronized (properties) {
            if (this.myProperties.containsKey(arrayLengthKey)) {
                length = this.get(arrayLengthKey, length);
                this.myProperties.remove(arrayLengthKey);
                if (length > 0) {
                    String arrayPrefix = String.valueOf(keyName) + ".";
                    int i = 0;
                    while (i < length) {
                        this.myProperties.remove(String.valueOf(arrayPrefix) + (i + 1));
                        ++i;
                    }
                }
                wasRemoved = true;
            }
        }
        return wasRemoved;
    }

    protected void fireSettingChanged(String keyName) {
        String settingsKey = keyName;
        if (this.isSequenceKey(settingsKey)) {
            settingsKey = settingsKey.substring(0, settingsKey.length() - 1);
            this.recordSequenceChange(settingsKey);
        } else {
            this.recordParameterChange(settingsKey);
        }
        ChangeEvent event = new ChangeEvent(settingsKey);
        for (ChangeListener listener : this.myChangeListeners) {
            listener.stateChanged(event);
        }
    }

    private boolean isSequenceKey(String settingsKey) {
        return settingsKey.length() > 0 && settingsKey.charAt(settingsKey.length() - 1) == '.';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordParameterChange(String parameterKey) {
        Map<String, ChangeType> map = this.myChangedProperties;
        synchronized (map) {
            if (this.isValueStored(parameterKey)) {
                this.myChangedProperties.put(parameterKey, ChangeType.SINGLE_PARAMETER_UPDATED_OR_ADDED);
            } else {
                this.myChangedProperties.put(parameterKey, ChangeType.SINGLE_PARAMETER_REMOVED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSequenceChange(String sequenceKey) {
        Map<String, ChangeType> map = this.myChangedProperties;
        synchronized (map) {
            if (this.isSequenceStored(sequenceKey)) {
                this.myChangedProperties.put(sequenceKey, ChangeType.SEQUENCE_UPDATED_OR_ADDED);
            } else {
                this.myChangedProperties.put(sequenceKey, ChangeType.SEQUENCE_REMOVED);
            }
        }
    }

    private File changeNotWritableFilePath(File originalFile) {
        File localFile = originalFile;
        if (!GeneralUtils.isWindowsOS()) {
            String prefix;
            String latestName;
            File parentFile = originalFile.getParentFile();
            if (parentFile == null) {
                parentFile = new File(System.getProperty("user.dir"));
            }
            if ((latestName = PFileUtils.getLatestFileName(prefix = originalFile.getName().replace(DEFAULT_FILE_EXTENSION, DEFAULT_STRING_VALUE), DEFAULT_FILE_EXTENSION, parentFile, true)) == null) {
                localFile = new File(String.valueOf(GeneralUtils.getAppFolderPathFromUserHome()) + File.separator + originalFile.getName());
                this.myLogger.debug("File path is changed to " + localFile.toString());
            } else {
                localFile = new File(parentFile, latestName);
            }
        }
        return localFile;
    }

    private static String serachFileInOtherOS(String fileName) {
        String prefix;
        String result = fileName;
        if (!GeneralUtils.isWindowsOS() && (result = PFileUtils.getLatestFileName(prefix = fileName.replace(DEFAULT_FILE_EXTENSION, DEFAULT_STRING_VALUE), DEFAULT_FILE_EXTENSION, null, false)) == null) {
            result = PSettings.searchFromUserHome(fileName);
        }
        return result.replace(DEFAULT_FILE_EXTENSION, DEFAULT_STRING_VALUE);
    }

    private static String searchFromUserHome(String fileName) {
        String tmpFileName = String.valueOf(GeneralUtils.getAppFolderPathFromUserHome()) + File.separator + fileName;
        if (new File(tmpFileName).exists()) {
            return tmpFileName;
        }
        return fileName;
    }

    static enum ChangeType {
        SINGLE_PARAMETER_UPDATED_OR_ADDED,
        SINGLE_PARAMETER_REMOVED,
        SEQUENCE_UPDATED_OR_ADDED,
        SEQUENCE_REMOVED;

    }
}

