/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ReusableStringTokenizer
implements Enumeration<Object> {
    private String myData;
    private char mySeparatorChar;
    private int myCurrentPos;
    private int myLength;

    public ReusableStringTokenizer() {
        this.init("", ' ');
    }

    public ReusableStringTokenizer(String data, char separatorChar) {
        this.init(data, separatorChar);
    }

    public void init(String data, char separatorChar) {
        this.myData = data;
        this.mySeparatorChar = separatorChar;
        this.myLength = this.myData.length();
        this.myCurrentPos = 0;
    }

    public boolean hasMoreTokens() {
        boolean retVal = false;
        int i = this.myCurrentPos;
        while (i < this.myLength - 1) {
            if (this.myData.charAt(i) == this.mySeparatorChar) {
                retVal = true;
                break;
            }
            ++i;
        }
        if (!retVal && this.myCurrentPos < this.myLength) {
            retVal = true;
        }
        return retVal;
    }

    public String nextToken() throws NoSuchElementException {
        int startPos = this.myCurrentPos;
        int counter = this.myCurrentPos;
        while (counter < this.myLength) {
            if (this.myData.charAt(counter) == this.mySeparatorChar) break;
            ++counter;
        }
        this.myCurrentPos = counter;
        if (this.myCurrentPos - startPos <= 0) {
            throw new NoSuchElementException("String " + this.myData + " does not have more tokens");
        }
        return this.myData.substring(startPos, this.myCurrentPos++);
    }

    public int countTokens() {
        int count = 0;
        if (this.myData.length() > 0) {
            int i = 0;
            while (i < this.myLength - 1) {
                if (this.myData.charAt(i) == this.mySeparatorChar) {
                    ++count;
                }
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Override
    public boolean hasMoreElements() throws NoSuchElementException {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() {
        return this.nextToken();
    }
}

