/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.laf.util.NetUtils;
import com.nokia.widgets.text.utils.NumberUtils;
import java.awt.FontMetrics;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public final class TextUtils {
    private static final int ROW_LENGTH_FONT = 500;
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    public static final int DEFAULT_ROW_LENGTH = 80;
    private static DecimalFormatSymbols myDFS = new DecimalFormatSymbols();
    private static char myNegativeChar = myDFS.getMinusSign();
    private static final char myDecimalChar = '.';

    private TextUtils() {
    }

    public static String textWrap(String text, String lineSeparator, int rowLength, String pattern) {
        int spaceIndex;
        StringBuilder line = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        if (rowLength <= 0 || text == null || text.length() <= 0) {
            return "";
        }
        if (text.length() < rowLength) {
            return text;
        }
        ArrayList<String> parts = new ArrayList<String>();
        String toSplit = text;
        while ((spaceIndex = toSplit.indexOf(pattern)) != -1) {
            int index;
            String part = toSplit.substring(0, spaceIndex);
            while ((index = part.indexOf(lineSeparator)) != -1) {
                parts.add(part.substring(0, index));
                parts.add(part.substring(index, index + lineSeparator.length()));
                part = part.substring(index + lineSeparator.length());
            }
            parts.add(part);
            parts.add(toSplit.substring(spaceIndex, spaceIndex + 1));
            toSplit = toSplit.substring(spaceIndex + 1);
        }
        parts.add(toSplit);
        for (String part : parts) {
            if (part.equals(lineSeparator)) {
                sb.append((CharSequence)line);
                sb.append(lineSeparator);
                line.delete(0, line.length());
                continue;
            }
            if (line.length() > 0 && line.length() + part.length() > rowLength) {
                if (line.toString().endsWith(pattern) && !part.equals(pattern)) {
                    line.deleteCharAt(line.lastIndexOf(pattern));
                }
                sb.append((CharSequence)line);
                sb.append(lineSeparator);
                line.delete(0, line.length());
                if (pattern.equals(part)) continue;
            }
            line.append(part);
        }
        return sb.append((CharSequence)line).toString();
    }

    public static String textWrap(String text, String lineSeparator, int rowLength) {
        return TextUtils.textWrap(text, lineSeparator, rowLength, " ");
    }

    public static String textWrap(String text, int rowLength) {
        String lineSeparator = System.getProperty("line.separator");
        return TextUtils.textWrap(text, lineSeparator, rowLength);
    }

    public static String textWrap(String text) {
        String lineSeparator = System.getProperty("line.separator");
        return TextUtils.textWrap(text, lineSeparator, 80);
    }

    public static String textWrapPath(String pathLocation, int rowLength) {
        String lineSeparator = System.getProperty("line.separator");
        int backSlashIndex = pathLocation.lastIndexOf(92);
        int slashIndex = pathLocation.lastIndexOf(47);
        if (backSlashIndex < 0 && slashIndex < 0) {
            return pathLocation;
        }
        String pattern = backSlashIndex >= 0 ? String.valueOf('\\') : String.valueOf('/');
        String doubleBackSlash = String.valueOf(String.valueOf('\\')) + String.valueOf('\\');
        String doubleSlash = String.valueOf(String.valueOf('/')) + String.valueOf('/');
        String placer = "--";
        if (pathLocation.startsWith(doubleBackSlash)) {
            String wrapLocation = TextUtils.textWrap(String.valueOf(placer) + pathLocation.substring(2), String.valueOf(pattern) + lineSeparator, rowLength, pattern);
            return String.valueOf(doubleBackSlash) + wrapLocation.substring(2);
        }
        if (pathLocation.startsWith(doubleSlash)) {
            String wrapLocation = TextUtils.textWrap(String.valueOf(placer) + pathLocation.substring(2), String.valueOf(pattern) + lineSeparator, rowLength, pattern);
            return String.valueOf(doubleSlash) + wrapLocation.substring(2);
        }
        return TextUtils.textWrap(pathLocation, String.valueOf(pattern) + lineSeparator, rowLength, pattern);
    }

    public static String forcedTextWrap(String text, String lineSeparator, int rowLength) {
        int length = text.length();
        if (length < rowLength) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int idx = 0;
        while (idx < length) {
            if (idx % rowLength == 0 && idx > 0) {
                result.append(lineSeparator);
            }
            result.append(text.charAt(idx));
            ++idx;
        }
        return result.toString();
    }

    public static String forcedTextWrap(String text, int rowLength) {
        return TextUtils.forcedTextWrap(text, System.getProperty("line.separator"), rowLength);
    }

    public static String forcedTextWrap(String text) {
        return TextUtils.forcedTextWrap(text, System.getProperty("line.separator"), 80);
    }

    public static String forcedTextWrap(String text, String lineSeparator, int rowLength, int maxRowCount) {
        return TextUtils.forcedTextWrap(text, lineSeparator, rowLength, maxRowCount, null);
    }

    public static String forcedTextWrap(String text, String lineSeparator, int rowLength, int maxRowCount, FontMetrics fontMetrics) {
        if (rowLength <= 0 || text == null || text.length() <= 0) {
            return "";
        }
        if (text.length() < rowLength) {
            return text;
        }
        return TextUtils.handleSplitWords(lineSeparator, rowLength, maxRowCount, TextUtils.getSplitWords(text, lineSeparator), fontMetrics);
    }

    private static String handleSplitWords(String lineSeparator, int rowLength, int maxRowCount, List<String> parts, FontMetrics fontMetrics) {
        StringBuilder line = new StringBuilder();
        StringBuilder wrappedText = new StringBuilder();
        int lineNum = 0;
        boolean bBreak = false;
        for (String part : parts) {
            int adjustedRowLength;
            if (lineNum >= maxRowCount) {
                bBreak = true;
                break;
            }
            if (part.equals(lineSeparator)) {
                wrappedText.append((CharSequence)line);
                wrappedText.append(lineSeparator);
                ++lineNum;
                line.delete(0, line.length());
                continue;
            }
            int currentStringLength = fontMetrics != null ? SwingUtilities.computeStringWidth(fontMetrics, line + part) : line.length() + part.length();
            int n = adjustedRowLength = fontMetrics != null ? 500 : rowLength;
            if (currentStringLength > adjustedRowLength && part.length() <= rowLength) {
                lineNum = TextUtils.getLineNumAfterLineSeparatorAdded(lineSeparator, line, wrappedText, lineNum, part);
                if (" ".equals(part)) {
                    continue;
                }
            } else if (currentStringLength > adjustedRowLength && part.length() > rowLength) {
                if ((lineNum = TextUtils.getLineNumAfterLineSeparatorAdded(lineSeparator, line, wrappedText, lineNum, part)) >= maxRowCount) {
                    bBreak = true;
                    break;
                }
                if ((lineNum = TextUtils.getLineNumAfterBruteAppendPartToLine(lineSeparator, rowLength, line, wrappedText, lineNum, maxRowCount, part)) < maxRowCount) continue;
                bBreak = true;
                break;
            }
            line.append(part);
        }
        return TextUtils.finalizeWrappedText(line, wrappedText, bBreak);
    }

    private static int getLineNumAfterBruteAppendPartToLine(String lineSeparator, int rowLength, StringBuilder line, StringBuilder wrappedText, int lineNum, int maxRowCount, String part) {
        int currentLineNum = lineNum;
        int idx = 0;
        while (idx < part.length()) {
            if (idx % rowLength == 0 && idx > 0) {
                wrappedText.append((CharSequence)line);
                wrappedText.append(lineSeparator);
                line.delete(0, line.length());
                if (++currentLineNum >= maxRowCount) break;
            }
            line.append(part.charAt(idx));
            ++idx;
        }
        return currentLineNum;
    }

    private static int getLineNumAfterLineSeparatorAdded(String lineSeparator, StringBuilder line, StringBuilder wrappedText, int lineNum, String part) {
        if (line.toString().endsWith(" ") && !" ".equals(part)) {
            line.deleteCharAt(line.lastIndexOf(" "));
        }
        if (line.length() > 0) {
            wrappedText.append((CharSequence)line);
            wrappedText.append(lineSeparator);
            line.delete(0, line.length());
            return lineNum + 1;
        }
        return lineNum;
    }

    private static String finalizeWrappedText(StringBuilder line, StringBuilder wrappedText, boolean bBreak) {
        wrappedText.append((CharSequence)line);
        if (bBreak) {
            return wrappedText.append("...").toString();
        }
        return wrappedText.toString();
    }

    private static List<String> getSplitWords(String text, String lineSeparator) {
        int spaceIndex;
        ArrayList<String> parts = new ArrayList<String>();
        String toSplit = text.trim();
        while ((spaceIndex = toSplit.indexOf(" ")) != -1) {
            int index;
            String part = toSplit.substring(0, spaceIndex);
            while ((index = part.indexOf(lineSeparator)) != -1) {
                parts.add(part.substring(0, index));
                parts.add(part.substring(index, index + lineSeparator.length()));
                part = part.substring(index + lineSeparator.length());
            }
            parts.add(part);
            parts.add(toSplit.substring(spaceIndex, spaceIndex + 1));
            toSplit = toSplit.substring(spaceIndex + 1);
        }
        parts.add(toSplit);
        return parts;
    }

    public static String encodeHTML(String text) {
        String tempText = text.replace("%", "%25");
        tempText = tempText.replace(" ", "%20");
        tempText = tempText.replace("!", "%21");
        tempText = tempText.replace("\"", "%22");
        tempText = tempText.replace("#", "%23");
        tempText = tempText.replace("$", "%24");
        tempText = tempText.replace("&", "%26");
        tempText = tempText.replace("'", "%27");
        tempText = tempText.replace("(", "%28");
        tempText = tempText.replace(")", "%29");
        tempText = tempText.replace("*", "%2A");
        tempText = tempText.replace("+", "%2B");
        tempText = tempText.replace(",", "%2C");
        tempText = tempText.replace("-", "%2D");
        tempText = tempText.replace(".", "%2E");
        tempText = tempText.replace(":", "%3A");
        tempText = tempText.replace(";", "%3B");
        tempText = tempText.replace("<", "%3C");
        tempText = tempText.replace("=", "%3D");
        tempText = tempText.replace(">", "%3E");
        tempText = tempText.replace("?", "%3F");
        tempText = tempText.replace("@", "%40");
        tempText = tempText.replace("[", "%5B");
        tempText = tempText.replace("\\", "%5C");
        tempText = tempText.replace("]", "%5D");
        tempText = tempText.replace("^", "%5E");
        tempText = tempText.replace("_", "%5F");
        tempText = tempText.replace("`", "%60");
        tempText = tempText.replace("{", "%7B");
        tempText = tempText.replace("|", "%7C");
        tempText = tempText.replace("}", "%7D");
        tempText = tempText.replace("~", "%7E");
        return tempText;
    }

    public static String encodeToHTMLSourceCode(String text) {
        String tempText = text.replaceAll("&", "&amp;");
        tempText = tempText.replaceAll("'", "&#39;");
        tempText = tempText.replaceAll("\"", "&quot;");
        tempText = tempText.replaceAll("<", "&lt;");
        tempText = tempText.replaceAll(">", "&gt;");
        tempText = tempText.replaceAll("\n", "<br>");
        return tempText;
    }

    public static String decodeHTML(String text) {
        String tempText = text.replace("%20", " ");
        tempText = tempText.replace("%21", "!");
        tempText = tempText.replace("%22", "\"");
        tempText = tempText.replace("%23", "#");
        tempText = tempText.replace("%24", "$");
        tempText = tempText.replace("%26", "&");
        tempText = tempText.replace("%27", "'");
        tempText = tempText.replace("%28", "(");
        tempText = tempText.replace("%29", ")");
        tempText = tempText.replace("%2A", "*");
        tempText = tempText.replace("%2a", "*");
        tempText = tempText.replace("%2B", "+");
        tempText = tempText.replace("%2b", "+");
        tempText = tempText.replace("%2C", ",");
        tempText = tempText.replace("%2c", ",");
        tempText = tempText.replace("%2D", "-");
        tempText = tempText.replace("%2d", "-");
        tempText = tempText.replace("%2E", ".");
        tempText = tempText.replace("%2e", ".");
        tempText = tempText.replace("%3A", ":");
        tempText = tempText.replace("%3a", ":");
        tempText = tempText.replace("%3B", ";");
        tempText = tempText.replace("%3b", ";");
        tempText = tempText.replace("%3C", "<");
        tempText = tempText.replace("%3c", "<");
        tempText = tempText.replace("%3D", "=");
        tempText = tempText.replace("%3d", "=");
        tempText = tempText.replace("%3E", ">");
        tempText = tempText.replace("%3e", ">");
        tempText = tempText.replace("%3F", "?");
        tempText = tempText.replace("%3f", "?");
        tempText = tempText.replace("%40", "@");
        tempText = tempText.replace("%5B", "[");
        tempText = tempText.replace("%5b", "[");
        tempText = tempText.replace("%5C", "\\");
        tempText = tempText.replace("%5c", "\\");
        tempText = tempText.replace("%5D", "]");
        tempText = tempText.replace("%5d", "]");
        tempText = tempText.replace("%5E", "^");
        tempText = tempText.replace("%5e", "^");
        tempText = tempText.replace("%5F", "_");
        tempText = tempText.replace("%5f", "_");
        tempText = tempText.replace("%60", "`");
        tempText = tempText.replace("%7B", "{");
        tempText = tempText.replace("%7b", "{");
        tempText = tempText.replace("%7C", "|");
        tempText = tempText.replace("%7c", "|");
        tempText = tempText.replace("%7D", "}");
        tempText = tempText.replace("%7d", "}");
        tempText = tempText.replace("%7E", "~");
        tempText = tempText.replace("%7e", "~");
        tempText = tempText.replace("%25", "%");
        return tempText;
    }

    public static String parseVersionNumber(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        boolean found = false;
        StringBuilder version = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (Character.isDigit(text.charAt(i)) || text.charAt(i) == '.') {
                version.append(text.charAt(i));
                found = true;
            } else if (found) {
                return version.toString();
            }
            ++i;
        }
        return version.toString();
    }

    public static boolean isNumeric(String value) {
        return NumberUtils.isNumeric(value);
    }

    public static boolean isInteger(String value) {
        if (TextUtils.isNullOrDecimalPoint(value)) {
            return false;
        }
        int i = 0;
        if (value.charAt(0) == myNegativeChar) {
            if (value.length() > 1) {
                ++i;
                if (!Character.isDigit(value.charAt(1))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        int length = value.length();
        int decimalCounter = 0;
        while (i < length) {
            char currentChar = value.charAt(i);
            if (!Character.isDigit(currentChar) && currentChar != '.') {
                return false;
            }
            if (decimalCounter > 0 && (currentChar != '0' || currentChar == '.')) {
                return false;
            }
            if (currentChar == '.' && decimalCounter == 0) {
                ++decimalCounter;
            }
            ++i;
        }
        return true;
    }

    public static String format(String key, Object ... args) {
        String pattern = I18n.getI18n().getBaseBundle().getString(key);
        return MessageFormat.format(pattern, args);
    }

    public static String format(String key, String arg) {
        return TextUtils.format(key, new Object[]{arg});
    }

    public static String capitalizeFirstLetter(String text) {
        return String.valueOf(text.substring(0, 1).toUpperCase()) + text.substring(1);
    }

    public static String getFormatTextByLimitedFontWidth(FontMetrics fontMetrics, String text, int maxWidth) {
        if (maxWidth <= 20) {
            return text;
        }
        String[] lines = NetUtils.breakupLines(text);
        StringBuffer sb = new StringBuffer("");
        boolean isAddBreakChar = false;
        int line = 0;
        while (line < lines.length) {
            String strLine = lines[line];
            int stringWidth = SwingUtilities.computeStringWidth(fontMetrics, strLine);
            if (stringWidth > maxWidth) {
                int i = 0;
                while (i < strLine.length()) {
                    String subStr = strLine.substring(0, i + 1);
                    stringWidth = SwingUtilities.computeStringWidth(fontMetrics, subStr);
                    if (stringWidth > maxWidth) {
                        strLine = TextUtils.generateStrLine(strLine, i);
                        isAddBreakChar = true;
                        break;
                    }
                    ++i;
                }
            }
            sb.append(strLine);
            if (line < lines.length) {
                sb.append(NetUtils.LINE_SEPARATOR);
            }
            ++line;
        }
        if (isAddBreakChar) {
            return TextUtils.getFormatTextByLimitedFontWidth(fontMetrics, sb.toString(), maxWidth);
        }
        String formatText = sb.toString();
        if (formatText.endsWith(NetUtils.LINE_SEPARATOR)) {
            formatText = formatText.substring(0, formatText.length() - NetUtils.LINE_SEPARATOR.length());
        }
        return formatText;
    }

    private static String generateStrLine(String strLine, int maxLengthIndex) {
        if (maxLengthIndex <= 0 || maxLengthIndex >= strLine.length()) {
            return strLine;
        }
        int lastIndexOfSpace = strLine.substring(0, maxLengthIndex).lastIndexOf(32);
        int seperateIndex = lastIndexOfSpace > 0 && strLine.charAt(maxLengthIndex) != ' ' ? lastIndexOfSpace + 1 : maxLengthIndex;
        return String.valueOf(strLine.substring(0, seperateIndex)) + NetUtils.LINE_SEPARATOR + strLine.substring(seperateIndex, strLine.length());
    }

    private static boolean isNullOrDecimalPoint(String value) {
        return value == null || value.length() == 0 || Character.toString('.').equals(value);
    }

    public static String removeLeadingWhiteSpace(String text) {
        return text.replaceAll("^\\s+", "");
    }

    public static String removeExtraSpaces(String text) {
        return text.replaceAll("\\s{2,}", " ").replaceAll("\\s(\\.)", "$1");
    }

    public static boolean isEqual(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }

    public static int getCharacterNumber(RAMLMetaParameter metadata, String str) {
        int number = 0;
        if (metadata.getValidationPattern() != null && metadata.getValidationPattern().contains("UTF8")) {
            try {
                number = str.getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                number = str.length();
            }
        } else {
            number = str.length();
        }
        return number;
    }

    public static boolean isNullOrEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static boolean isNullOrBlank(String input) {
        return TextUtils.isNullOrEmpty(input) || input.trim().length() == 0;
    }
}

