/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util;

import com.nokia.em.poseidon.util.PSettings;
import com.nokia.widgets.util.ScaleUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Area;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public final class ViewUtils {
    private static boolean thePrintTime = true;
    public static final String X_LOCATION_SETTING = ".x";
    public static final String Y_LOCATION_SETTING = ".y";
    public static final String WIDTH_LOCATION_SETTING = ".width";
    public static final String HEIGHT_LOCATION_SETTING = ".height";
    public static final String WINDOW_EXTENDED = ".extended";
    private static PSettings mySettings = PSettings.getInstance();

    private ViewUtils() {
    }

    public static void setSettingsInstance(PSettings settings) {
        mySettings = settings;
    }

    public static void storeSettings(String settingsName, Rectangle bounds) {
        ViewUtils.storeSettings(settingsName, bounds, false);
    }

    public static void storeSettings(String settingsName, Rectangle bounds, boolean scaleByFontSize) {
        mySettings.set(String.valueOf(settingsName) + X_LOCATION_SETTING, bounds.x);
        mySettings.set(String.valueOf(settingsName) + Y_LOCATION_SETTING, bounds.y);
        int width = bounds.width;
        int height = bounds.height;
        if (scaleByFontSize) {
            width = ScaleUtils.reverseScale(width);
            height = ScaleUtils.reverseScale(height);
        }
        mySettings.set(String.valueOf(settingsName) + WIDTH_LOCATION_SETTING, width);
        mySettings.set(String.valueOf(settingsName) + HEIGHT_LOCATION_SETTING, height);
    }

    public static Rectangle restoreSettings(String settingsName, Rectangle defaultBounds) {
        return ViewUtils.restoreSettings(settingsName, defaultBounds, false);
    }

    public static Rectangle restoreSettings(String settingsName, Rectangle defaultBounds, boolean scaleByFontSize) {
        Rectangle restoredBounds = new Rectangle();
        restoredBounds.x = mySettings.get(String.valueOf(settingsName) + X_LOCATION_SETTING, defaultBounds.x);
        restoredBounds.y = mySettings.get(String.valueOf(settingsName) + Y_LOCATION_SETTING, defaultBounds.y);
        restoredBounds.width = mySettings.get(String.valueOf(settingsName) + WIDTH_LOCATION_SETTING, defaultBounds.width);
        restoredBounds.height = mySettings.get(String.valueOf(settingsName) + HEIGHT_LOCATION_SETTING, defaultBounds.height);
        if (scaleByFontSize) {
            restoredBounds.width = ScaleUtils.scale(restoredBounds.width);
            restoredBounds.height = ScaleUtils.scale(restoredBounds.height);
        }
        Rectangle allowed = new Rectangle(restoredBounds.x + 4, restoredBounds.y + 4, restoredBounds.width - 8, restoredBounds.height - 8);
        if (!ViewUtils.getScreenArea().contains(allowed)) {
            restoredBounds = defaultBounds;
        }
        return restoredBounds;
    }

    public static void storeExtendedState(String settingsName, int extendedState) {
        mySettings.set(String.valueOf(settingsName) + WINDOW_EXTENDED, extendedState);
    }

    public static int restoreExtendedState(String settingsName, int defaultExtendedState) {
        return mySettings.get(String.valueOf(settingsName) + WINDOW_EXTENDED, defaultExtendedState);
    }

    public static Rectangle getDefaultBounds(Dimension viewSize, Container parent) {
        Rectangle defaultBounds = new Rectangle();
        Rectangle parentBounds = parent != null && parent.isVisible() ? parent.getBounds() : GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        defaultBounds.x = (parentBounds.width - viewSize.width) / 2 + parentBounds.x;
        defaultBounds.y = (parentBounds.height - viewSize.height) / 2 + parentBounds.y;
        defaultBounds.width = viewSize.width;
        defaultBounds.height = viewSize.height;
        return defaultBounds;
    }

    public static Area getScreenArea() {
        GraphicsDevice[] devices;
        Area area = new Area();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = devices = ge.getScreenDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice device = graphicsDeviceArray[n2];
            GraphicsConfiguration configuration = device.getDefaultConfiguration();
            Logger.getLogger(ViewUtils.class).debug("Graphics device: " + device.getIDstring() + "," + device.getType() + "," + configuration.getBounds());
            area.add(new Area(configuration.getBounds()));
            ++n2;
        }
        Logger.getLogger(ViewUtils.class).info("Total screen area: " + area);
        return area;
    }

    public static void printTime(String description, long time) {
        if (thePrintTime) {
            System.out.println(String.valueOf(description) + ": " + time);
        }
    }

    public static void scrollBarsScrollToLeft(Component c) {
        if (c instanceof JScrollPane) {
            ((JScrollPane)c).getHorizontalScrollBar().setValue(0);
        } else if (c instanceof Container) {
            Component[] componentArray = ((Container)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                ViewUtils.scrollBarsScrollToLeft(comp);
                ++n2;
            }
        }
    }
}

