/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.concurrency;

import com.nokia.em.poseidon.util.concurrency.Invocation;
import com.nokia.em.poseidon.util.concurrency.ObjectPool;
import com.nokia.em.poseidon.util.concurrency.ThreadPool;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceProxyHandler
implements InvocationHandler {
    private static final ObjectPool myObjectPool = new ObjectPool(1);
    private final Map<Class<?>, Boolean> myInterfaceToEdtMap = new HashMap();
    private Object myProxy;
    private Object myTarget;
    private boolean myWaitInvoked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void discardInvocation(Invocation invocation) {
        ObjectPool objectPool = myObjectPool;
        synchronized (objectPool) {
            myObjectPool.put(invocation);
        }
    }

    private static boolean isEqualsMethod(Method method) {
        Class<?>[] ptypes = method.getParameterTypes();
        return ptypes.length == 1 && ptypes[0] == Object.class && "equals".equals(method.getName());
    }

    public InterfaceProxyHandler(Object object) {
        this.myTarget = object;
        List<Class<?>> ifaces = this.getInterfaces();
        this.myProxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), ifaces.toArray(new Class[ifaces.size()]), (InvocationHandler)this);
    }

    public void avoidEdt(Class<?> ... interfaces) {
        Class<?>[] ifs = interfaces;
        if (interfaces.length == 0) {
            List<Class<?>> ifaces = this.getInterfaces();
            ifs = ifaces.toArray(new Class[ifaces.size()]);
        }
        Class<?>[] classArray = ifs;
        int n = ifs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            this.myInterfaceToEdtMap.put(clazz, false);
            ++n2;
        }
    }

    public <T> T getInterface(Class<T> clazz) throws ClassCastException {
        return clazz.cast(this.myProxy);
    }

    public Object getProxy() {
        return this.myProxy;
    }

    public static <T> T toEdt(T object) {
        InterfaceProxyHandler proxy = new InterfaceProxyHandler(object);
        proxy.useEdt(new Class[0]);
        return (T)proxy.getProxy();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (InterfaceProxyHandler.isEqualsMethod(method)) {
            if (args[0] != null && Proxy.isProxyClass(args[0].getClass()) && this.myTarget.equals(((InterfaceProxyHandler)Proxy.getInvocationHandler((Object)args[0])).myTarget)) {
                return true;
            }
            return false;
        }
        Boolean shouldRunInEdt = this.myInterfaceToEdtMap.get(method.getDeclaringClass());
        if (shouldRunInEdt == null && this.isEventNotifierMethod(method)) {
            this.myInterfaceToEdtMap.put(method.getDeclaringClass(), true);
            shouldRunInEdt = Boolean.TRUE;
        }
        if (shouldRunInEdt != null && shouldRunInEdt != SwingUtilities.isEventDispatchThread()) {
            return this.invoke(method, args, shouldRunInEdt);
        }
        try {
            return method.invoke(this.myTarget, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void reset(Class<?> ... interfaces) {
        if (interfaces.length == 0) {
            this.myInterfaceToEdtMap.clear();
        } else {
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> clazz = classArray[n2];
                this.myInterfaceToEdtMap.remove(clazz);
                ++n2;
            }
        }
    }

    public void useEdt(Class<?> ... interfaces) {
        Class<?>[] ifs = interfaces;
        if (interfaces.length == 0) {
            List<Class<?>> ifaces = this.getInterfaces();
            ifs = ifaces.toArray(new Class[ifaces.size()]);
        }
        Class<?>[] classArray = ifs;
        int n = ifs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            this.myInterfaceToEdtMap.put(clazz, true);
            ++n2;
        }
    }

    public void setWaitInvoked(boolean waitInvoked) {
        this.myWaitInvoked = waitInvoked;
    }

    private List<Class<?>> getInterfaces() {
        ArrayList ifaces = new ArrayList();
        Class<?> clazz = this.myTarget.getClass();
        do {
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                if (!ifaces.contains(iface) && Modifier.isPublic(iface.getModifiers())) {
                    ifaces.add(iface);
                }
                ++n2;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return ifaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invocation getInvocation(Method method, Object[] args) {
        ObjectPool objectPool = myObjectPool;
        synchronized (objectPool) {
            Invocation invocation = myObjectPool.get(Invocation.class);
            invocation.setTarget(this.myTarget, method, args);
            return invocation;
        }
    }

    private Object invoke(Method method, Object[] args, boolean useEdt) throws Throwable {
        Invocation invocation = this.getInvocation(method, args);
        boolean mustWait = invocation.hasReturnValue();
        if (useEdt) {
            if (this.myWaitInvoked) {
                SwingUtilities.invokeAndWait(invocation);
            } else {
                SwingUtilities.invokeLater(invocation);
            }
        } else {
            ThreadPool.getInstance().execute(invocation);
        }
        if (mustWait) {
            return this.waitForResult(invocation);
        }
        return null;
    }

    private boolean isEventNotifierMethod(Method method) {
        Class<?>[] params = method.getParameterTypes();
        return params.length == 1 && EventObject.class.isAssignableFrom(params[0]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object waitForResult(Invocation invocation) throws Throwable {
        var2_2 = invocation;
        synchronized (var2_2) {
            while (true) {
                if (invocation.isComplete()) {
                    ** try [egrp 2[TRYBLOCK] [1 : 22->28)] { 
lbl7:
                    // 1 sources

                    break;
                }
                try {
                    invocation.wait();
                }
                catch (InterruptedException var3_3) {
                    // empty catch block
                }
            }
            {
                var4_5 = invocation.getInvocationResult();
                return var4_5;
            }
lbl16:
            // 1 sources

            finally {
                InterfaceProxyHandler.discardInvocation(invocation);
            }
        }
    }
}

