/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.concurrency;

import com.nokia.em.poseidon.util.concurrency.InterfaceProxyHandler;
import com.nokia.em.poseidon.util.concurrency.Reusable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Invocation
implements Reusable,
Runnable {
    private Object[] myArgs;
    private Throwable myError;
    private boolean myIsComplete;
    private Method myMethod;
    private Object myReturnValue;
    private Object myTarget;

    public boolean hasReturnValue() {
        return this.myMethod.getReturnType() != Void.TYPE;
    }

    @Override
    public void reset() {
        this.myArgs = null;
        this.myError = null;
        this.myIsComplete = false;
        this.myMethod = null;
        this.myReturnValue = null;
        this.myTarget = null;
    }

    @Override
    public void run() {
        if (this.hasReturnValue()) {
            this.invokeAndHold();
        } else {
            this.invokeAndDie();
        }
    }

    public void setTarget(Object target, Method method, Object[] args) {
        this.myTarget = target;
        this.myMethod = method;
        this.myArgs = args;
    }

    protected Object getInvocationResult() throws Throwable {
        if (this.myError == null) {
            return this.myReturnValue;
        }
        throw this.myError;
    }

    protected boolean isComplete() {
        return this.myIsComplete;
    }

    private void invokeAndDie() {
        try {
            try {
                this.myMethod.invoke(this.myTarget, this.myArgs);
            }
            catch (InvocationTargetException e) {
                Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e.getCause());
                InterfaceProxyHandler.discardInvocation(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                InterfaceProxyHandler.discardInvocation(this);
            }
        }
        finally {
            InterfaceProxyHandler.discardInvocation(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeAndHold() {
        block14: {
            try {
                try {
                    this.myReturnValue = this.myMethod.invoke(this.myTarget, this.myArgs);
                }
                catch (Throwable error) {
                    this.myError = error instanceof InvocationTargetException ? ((InvocationTargetException)error).getCause() : error;
                    Invocation invocation = this;
                    synchronized (invocation) {
                        this.myIsComplete = true;
                        this.notify();
                        break block14;
                    }
                }
            }
            catch (Throwable throwable) {
                Invocation invocation = this;
                synchronized (invocation) {
                    this.myIsComplete = true;
                    this.notify();
                }
                throw throwable;
            }
            Invocation invocation = this;
            synchronized (invocation) {
                this.myIsComplete = true;
                this.notify();
            }
        }
    }
}

