/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.concurrency;

import com.nokia.em.poseidon.util.concurrency.IterativeOperation;
import com.nokia.em.poseidon.util.timer.SwingIdleTracker;
import com.nokia.em.poseidon.util.timer.TimerService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class IterativeOperationExecutor {
    public static final int DEFAULT_IDLE_WAIT = 1;
    public static final int DEFAULT_MINIMUM_WAIT = 500;
    private static final IterativeOperationExecutor theSingletonInstance = new IterativeOperationExecutor();
    private final Executor myExecutor = new Executor();
    private int myIdleWait = 1;
    private int myLastIndex;
    private int myMinimumWait = 500;
    private List<IterationRunner> myOperations = new ArrayList<IterationRunner>(10);
    private boolean myRunning;

    public static IterativeOperationExecutor getInstance() {
        return theSingletonInstance;
    }

    private IterativeOperationExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IterativeOperation operation) {
        List<IterationRunner> list = this.myOperations;
        synchronized (list) {
            if (operation != null && this.find(operation) < 0) {
                this.myOperations.add(new IterationRunner(operation));
                this.myExecutor.start();
            }
        }
    }

    public void finish(IterativeOperation operation) {
        IterativeOperation.Status status;
        this.remove(operation);
        while ((status = operation.doIteration()) == IterativeOperation.Status.INCOMPLETE) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(IterativeOperation operation) {
        List<IterationRunner> list = this.myOperations;
        synchronized (list) {
            int index = this.find(operation);
            if (index >= 0) {
                this.myOperations.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        List<IterationRunner> list = this.myOperations;
        synchronized (list) {
            this.myRunning = true;
            this.myExecutor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<IterationRunner> list = this.myOperations;
        synchronized (list) {
            this.myRunning = false;
            this.myExecutor.stop();
        }
    }

    private int find(IterativeOperation operation) {
        if (operation != null) {
            int i = this.myOperations.size();
            while (--i >= 0) {
                if (this.myOperations.get(i).getOperation() != operation) continue;
                return i;
            }
        }
        return -1;
    }

    private final class Executor
    implements ActionListener {
        private boolean myExecuting;
        private State myState = State.OFF;

        private Executor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            List list = IterativeOperationExecutor.this.myOperations;
            synchronized (list) {
                if (!IterativeOperationExecutor.this.myRunning || IterativeOperationExecutor.this.myOperations.isEmpty()) {
                    this.stop();
                } else if (!this.myExecuting) {
                    if (this.myState == State.WAITING_FOR_IDLE) {
                        if (IterativeOperationExecutor.this.myLastIndex == 0 || IterativeOperationExecutor.this.myLastIndex > IterativeOperationExecutor.this.myOperations.size()) {
                            IterativeOperationExecutor.this.myLastIndex = IterativeOperationExecutor.this.myOperations.size();
                        }
                        this.myExecuting = true;
                        List list2 = IterativeOperationExecutor.this.myOperations;
                        IterativeOperationExecutor iterativeOperationExecutor = IterativeOperationExecutor.this;
                        int n = iterativeOperationExecutor.myLastIndex - 1;
                        iterativeOperationExecutor.myLastIndex = n;
                        ((IterationRunner)list2.get(n)).execute();
                        do {
                            try {
                                IterativeOperationExecutor.this.myOperations.wait();
                                this.myExecuting = false;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (this.myExecuting);
                        if (this.myState != State.OFF) {
                            this.myState = State.WAITING_MINIMUM_WAIT;
                            TimerService.getInstance().startTimer(this, (long)IterativeOperationExecutor.this.myMinimumWait, false, 1);
                        }
                    } else if (this.myState == State.WAITING_MINIMUM_WAIT) {
                        this.myState = State.WAITING_FOR_IDLE;
                        SwingIdleTracker.getInstance().addTimeOutListener(this, IterativeOperationExecutor.this.myIdleWait);
                    }
                }
            }
        }

        public void start() {
            if (IterativeOperationExecutor.this.myRunning && !IterativeOperationExecutor.this.myOperations.isEmpty() && this.myState == State.OFF) {
                this.myState = State.WAITING_FOR_IDLE;
                if (!this.myExecuting) {
                    SwingIdleTracker.getInstance().addTimeOutListener(this, IterativeOperationExecutor.this.myIdleWait);
                }
            }
        }

        public void stop() {
            this.myState = State.OFF;
            SwingIdleTracker.getInstance().removeTimeOutListener(this);
            TimerService.getInstance().stopTimer(this);
        }
    }

    private final class IterationRunner
    implements Runnable {
        private final IterativeOperation myOperation;
        private long myQueuedTime;

        public IterationRunner(IterativeOperation operation) {
            this.myOperation = operation;
        }

        public void execute() {
            this.myQueuedTime = System.nanoTime();
            SwingUtilities.invokeLater(this);
        }

        public IterativeOperation getOperation() {
            return this.myOperation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                try {
                    try {
                        long edtBusyness = System.nanoTime() - this.myQueuedTime;
                        if (edtBusyness < 10000000L && this.myOperation.doIteration() != IterativeOperation.Status.INCOMPLETE) {
                            IterativeOperationExecutor.this.remove(this.myOperation);
                        }
                    }
                    catch (Throwable ex) {
                        Logger.getLogger(this.getClass()).error("Executing iteration on \"" + this.myOperation.getClass().getName() + "\" failed", ex);
                        IterativeOperationExecutor.this.remove(this.myOperation);
                        List list = IterativeOperationExecutor.this.myOperations;
                        synchronized (list) {
                            IterativeOperationExecutor.this.myOperations.notify();
                            break block15;
                        }
                    }
                }
                catch (Throwable throwable) {
                    List list = IterativeOperationExecutor.this.myOperations;
                    synchronized (list) {
                        IterativeOperationExecutor.this.myOperations.notify();
                    }
                    throw throwable;
                }
                List list = IterativeOperationExecutor.this.myOperations;
                synchronized (list) {
                    IterativeOperationExecutor.this.myOperations.notify();
                }
            }
        }
    }

    private static enum State {
        OFF,
        WAITING_FOR_IDLE,
        WAITING_MINIMUM_WAIT;

    }
}

