/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.concurrency;

import com.nokia.em.poseidon.util.concurrency.Reusable;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class ObjectPool {
    private static final int DEFAULT_OBJECT_TYPE_COUNT = 4;
    private Map<Class<? extends Reusable>, Queue<SoftReference<? extends Reusable>>> myClassToListMap;

    public ObjectPool() {
        this(4);
    }

    public ObjectPool(int numberOfTypesOfObjects) {
        this.myClassToListMap = new HashMap<Class<? extends Reusable>, Queue<SoftReference<? extends Reusable>>>(numberOfTypesOfObjects);
    }

    public void clear() {
        for (Queue<SoftReference<? extends Reusable>> list : this.myClassToListMap.values()) {
            while (list.size() > 0) {
                list.poll().clear();
            }
        }
        this.myClassToListMap.clear();
    }

    public <T extends Reusable> T get(Class<T> clazz) {
        Queue<SoftReference<? extends Reusable>> objList = this.getObjectList(clazz);
        Reusable obj = this.findLiveOne(objList);
        if (obj != null) {
            return (T)((Reusable)clazz.cast(obj));
        }
        try {
            return (T)((Reusable)clazz.newInstance());
        }
        catch (Throwable anyError) {
            throw new Error("ObjectPool can only contain classes that have empty constructor defined");
        }
    }

    public void put(Reusable obj) {
        Queue<SoftReference<? extends Reusable>> objList = this.getObjectList(obj.getClass());
        obj.reset();
        objList.add(new SoftReference<Reusable>(obj));
    }

    private Reusable findLiveOne(Queue<SoftReference<? extends Reusable>> objList) {
        Reusable obj = null;
        while (obj == null && objList.size() > 0) {
            SoftReference<? extends Reusable> ref = objList.poll();
            obj = ref.get();
        }
        return obj;
    }

    private Queue<SoftReference<? extends Reusable>> getObjectList(Class<? extends Reusable> clazz) {
        Queue<SoftReference<? extends Reusable>> objList = this.myClassToListMap.get(clazz);
        if (objList == null) {
            objList = new LinkedList<SoftReference<? extends Reusable>>();
            this.myClassToListMap.put(clazz, objList);
        }
        return objList;
    }
}

