/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.concurrency;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadPool
implements Executor {
    private static ThreadPool myInstance;
    private ExecutorService myExecutorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new PoseidonThreadFactory());

    private ThreadPool() {
    }

    public static synchronized ThreadPool getInstance() {
        if (myInstance == null) {
            myInstance = new ThreadPool();
        }
        return myInstance;
    }

    @Override
    public synchronized void execute(Runnable command) {
        this.myExecutorService.execute(command);
    }

    static class PoseidonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        PoseidonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "PoseidonThreadPool-Thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement();
            Thread t = new Thread(this.group, r, name, 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

