/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import java.util.Map;

public final class DebugUtils {
    private DebugUtils() {
    }

    public static String generateThreadDump() {
        StringBuilder dumpStr = new StringBuilder();
        dumpStr.append("Thread Dump:\n\n");
        Map<Thread, StackTraceElement[]> threadDump = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadDump.entrySet()) {
            Thread t = entry.getKey();
            dumpStr.append("Thread name=" + t.getName() + ", id=" + t.getId() + ", state=" + (Object)((Object)t.getState()) + ", priority=" + t.getPriority() + ", alive=" + t.isAlive() + ", daemon=" + t.isDaemon() + ", interrupted=" + t.isInterrupted() + ", group=" + t.getThreadGroup() + "\n");
            if (t.getStackTrace().length > 0) {
                dumpStr.append("Stack trace:\n");
                StackTraceElement[] stackTraceElementArray = entry.getValue();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    dumpStr.append(element);
                    dumpStr.append("\n");
                    ++n2;
                }
            }
            dumpStr.append("\n");
        }
        return dumpStr.toString();
    }
}

