/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import com.nokia.em.poseidon.util.debugging.TracingEventQueue;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.layout.PButtonRowLayout;
import com.nokia.widgets.table.PTableModelSorter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class EDTTraceDialog
extends JDialog
implements ChangeListener {
    private static final int DEFAULT_WINDOW_HEIGHT = 500;
    private static final int DEFAULT_WINDOW_WIDTH = 650;
    private DefaultTableModel tableModel;
    private JTable table;
    JTextArea textArea;

    public EDTTraceDialog() {
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setSize(650, 500);
        this.setLayout(new GridBagLayout());
        this.createTable();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(25, 25, 25, 25);
        constraints.anchor = 19;
        constraints.weightx = 1.0;
        constraints.weighty = 0.5;
        constraints.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, constraints);
        constraints.insets = new Insets(0, 25, 25, 25);
        constraints.anchor = 10;
        constraints.gridy = 1;
        constraints.weighty = 0.5;
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane scrollPane2 = new JScrollPane(this.textArea);
        this.add((Component)scrollPane2, constraints);
        JPanel buttonPanel = new JPanel(new PButtonRowLayout());
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setBorder(PBorderFactory.getButtonBarBorder());
        ActionListener exitListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracingEventQueue.getInstance().removeProblemListener(EDTTraceDialog.this);
                EDTTraceDialog.this.dispose();
            }
        };
        JButton acceptButton = new JButton("Close");
        acceptButton.addActionListener(exitListener);
        this.getRootPane().setDefaultButton(acceptButton);
        buttonPanel.add(acceptButton);
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 15;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)buttonPanel, constraints);
        TracingEventQueue.getInstance().addProblemListener(this);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
    }

    private void createTable() {
        Object[] columns = new String[]{"Thread", "Timestamp", "Class", "Hashcode", "Notes"};
        this.tableModel = new DefaultTableModel(columns, 0);
        PTableModelSorter sortableModel = new PTableModelSorter(this.tableModel);
        this.table = new JTable(sortableModel);
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setFocusable(false);
        TableColumn column = null;
        int i = 0;
        while (i < 5) {
            column = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(100);
            } else if (i == 2 || i == 4) {
                column.setPreferredWidth(150);
            } else {
                column.setPreferredWidth(50);
            }
            ++i;
        }
        this.table.getSelectionModel().addListSelectionListener(new SelectionListener());
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.refreshTable();
    }

    public void refreshTable() {
        this.tableModel.getDataVector().clear();
        Set<TracingEventQueue.ProblemEvent> collection = TracingEventQueue.getInstance().getProblemEvents();
        for (TracingEventQueue.ProblemEvent info : collection) {
            this.tableModel.addRow(new Object[]{info.threadInfo.getThreadName(), info.timeOnEDT, info.event.getClass().getName(), info.event.hashCode(), "taking too much time on EDT"});
        }
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshTable();
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = EDTTraceDialog.this.table.getSelectedRow();
            if (selectedRow == -1 || selectedRow > EDTTraceDialog.this.table.getRowCount()) {
                return;
            }
            Integer hash = (Integer)EDTTraceDialog.this.table.getModel().getValueAt(EDTTraceDialog.this.table.getSelectedRow(), 3);
            Long time = (Long)EDTTraceDialog.this.table.getModel().getValueAt(EDTTraceDialog.this.table.getSelectedRow(), 1);
            Set<TracingEventQueue.ProblemEvent> collection = TracingEventQueue.getInstance().getProblemEvents();
            for (TracingEventQueue.ProblemEvent event : collection) {
                if (event.event.hashCode() != hash.intValue() || event.timeOnEDT != time) continue;
                StackTraceElement[] stack = event.threadInfo.getStackTrace();
                StringBuffer b = new StringBuffer();
                StackTraceElement[] stackTraceElementArray = stack;
                int n = stack.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement stackEntry = stackTraceElementArray[n2];
                    b.append(String.valueOf(stackEntry.getClassName()) + "." + stackEntry.getMethodName() + " [" + stackEntry.getLineNumber() + "]\n");
                    ++n2;
                }
                EDTTraceDialog.this.textArea.setText(b.toString());
            }
        }
    }
}

