/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.widgets.icons.PArrowIcon;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PHorizontalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class FocusTraversalDialog
extends JDialog {
    private static final int DEFAULT_WINDOW_HEIGHT = 450;
    private static final int DEFAULT_WINDOW_WIDTH = 500;
    protected Map myWindowMap;
    protected JFrame myRootFrame;
    protected Window myCurrentlySelectedWindow;
    protected JComboBox myWindowSelectionComboBox;
    protected Component mySelectedComponent = null;
    protected BorderGlassPane myCurrentGlassPane;
    protected JTextArea myCurrentFocusOwner = new JTextArea(20, 30);

    public FocusTraversalDialog(JFrame rootFrame) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (FocusTraversalDialog.this.myCurrentGlassPane != null) {
                    FocusTraversalDialog.this.cleanCurrentGlassPane();
                    FocusTraversalDialog.this.myCurrentGlassPane.setVisible(false);
                    FocusTraversalDialog.this.myCurrentGlassPane = null;
                }
            }
        });
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        FocusListener listener = new FocusListener();
        focusManager.addPropertyChangeListener("focusOwner", listener);
        focusManager.addPropertyChangeListener("permanentFocusOwner", listener);
        this.myWindowMap = new HashMap();
        this.myRootFrame = rootFrame;
        this.myCurrentlySelectedWindow = this.myRootFrame;
        this.myCurrentFocusOwner.setFocusable(false);
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setSize(500, 450);
        JPanel comboPanel = new JPanel(new FlowLayout(1));
        this.myWindowSelectionComboBox = new JComboBox();
        this.myWindowSelectionComboBox.setFocusable(false);
        this.myWindowSelectionComboBox.setPreferredSize(new Dimension(275, 25));
        this.myWindowSelectionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Window newSelection = (Window)FocusTraversalDialog.this.myWindowMap.get(FocusTraversalDialog.this.myWindowSelectionComboBox.getSelectedItem());
                if (newSelection != null && FocusTraversalDialog.this.myCurrentlySelectedWindow != newSelection) {
                    FocusTraversalDialog.this.cleanCurrentGlassPane();
                    FocusTraversalDialog.this.myCurrentlySelectedWindow = newSelection;
                    FocusTraversalDialog.this.myCurrentGlassPane = FocusTraversalDialog.this.createGlassPaneIfItDoesNotExist();
                    ArrayList roots = new ArrayList();
                    List rootComps = FocusTraversalDialog.this.findCycleRoots(FocusTraversalDialog.this.myCurrentlySelectedWindow, roots);
                    if (FocusTraversalDialog.this.myCurrentGlassPane != null) {
                        FocusTraversalDialog.this.myCurrentGlassPane.setCycleRoots(roots);
                        FocusTraversalDialog.this.myCurrentGlassPane.setCycleComps(FocusTraversalDialog.this.findFocusableCycle(rootComps));
                    }
                    FocusTraversalDialog.this.repaint();
                }
            }
        });
        comboPanel.add(this.myWindowSelectionComboBox);
        JButton refreshButton = new JButton("Refresh windows");
        refreshButton.setFocusable(false);
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FocusTraversalDialog.this.myCurrentGlassPane = FocusTraversalDialog.this.createGlassPaneIfItDoesNotExist();
                FocusTraversalDialog.this.cleanCurrentGlassPane();
                FocusTraversalDialog.this.buildWindowList();
                ArrayList roots = new ArrayList();
                List rootComps = FocusTraversalDialog.this.findCycleRoots(FocusTraversalDialog.this.myCurrentlySelectedWindow, roots);
                FocusTraversalDialog.this.myCurrentGlassPane.setCycleRoots(roots);
                FocusTraversalDialog.this.myCurrentGlassPane.setCycleComps(FocusTraversalDialog.this.findFocusableCycle(rootComps));
            }
        });
        comboPanel.add(refreshButton);
        this.add((Component)comboPanel, "North");
        JPanel focusInfoPanel = new JPanel(new PHorizontalLayout(0));
        focusInfoPanel.add(PLabel.createSystemText("Focus Owner:"));
        focusInfoPanel.add(new JScrollPane(this.myCurrentFocusOwner));
        this.add(focusInfoPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.setFocusable(false);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FocusTraversalDialog.this.myCurrentGlassPane != null) {
                    FocusTraversalDialog.this.cleanCurrentGlassPane();
                    FocusTraversalDialog.this.myCurrentGlassPane.setVisible(false);
                    FocusTraversalDialog.this.myCurrentGlassPane = null;
                }
                FocusTraversalDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.buildWindowList();
    }

    protected void markComponentBorder(Component component) {
        if (component != null) {
            this.drawBorder(component);
        }
        if (component instanceof Container) {
            Component[] children = ((Container)component).getComponents();
            int counter = 0;
            while (counter < children.length) {
                Component child = children[counter];
                this.markComponentBorder(child);
                ++counter;
            }
        }
    }

    protected void drawBorder(Component component) {
        if (component != null && SwingUtilities.getWindowAncestor(component) != this && SwingUtilities.getRootPane(component) != null && this.myCurrentGlassPane != null) {
            Rectangle rect = this.getRect(component);
            this.myCurrentGlassPane.setHighlightedRect(rect);
        }
    }

    private Rectangle getRect(Component component) {
        Point compLoc = new Point();
        Point windowLoc = new Point();
        if (component == null) {
            return new Rectangle();
        }
        SwingUtilities.convertPointToScreen(compLoc, component);
        SwingUtilities.convertPointToScreen(windowLoc, SwingUtilities.getRootPane(component));
        int x = compLoc.x - windowLoc.x;
        int y = compLoc.y - windowLoc.y;
        Rectangle rect = new Rectangle(x, y, component.getBounds().width, component.getBounds().height);
        return rect;
    }

    protected void buildComponentTree() {
        this.setTitle("Focus Traversal: " + (String)this.myWindowSelectionComboBox.getSelectedItem());
        this.repaint();
    }

    protected void buildWindowList() {
        this.myWindowMap.clear();
        Window[] children = this.myRootFrame.getOwnedWindows();
        int counter = 0;
        while (counter < children.length) {
            Window child = children[counter];
            if (child != this && child != JOptionPane.getRootFrame()) {
                String title = child.getName();
                if (child instanceof Dialog) {
                    title = ((Dialog)child).getTitle();
                } else if (child instanceof JFrame) {
                    title = ((JFrame)child).getTitle();
                }
                if (title != null && title.trim().length() > 0) {
                    String clazzName = child.getClass().getName();
                    this.myWindowMap.put(String.valueOf(title) + " [" + clazzName + "]", child);
                }
            }
            ++counter;
        }
        this.myWindowMap.put(String.valueOf(this.myRootFrame.getTitle()) + " [" + this.myRootFrame.getClass().getName() + "]", this.myRootFrame);
        this.myWindowSelectionComboBox.removeAllItems();
        for (String windowName : this.myWindowMap.keySet()) {
            if (this.myWindowMap.get(windowName) == this.myRootFrame) {
                this.myWindowSelectionComboBox.insertItemAt(windowName, 0);
                continue;
            }
            this.myWindowSelectionComboBox.addItem(windowName);
        }
        this.myWindowSelectionComboBox.setSelectedIndex(0);
        this.myCurrentlySelectedWindow = this.myRootFrame;
        this.buildComponentTree();
    }

    private Map findFocusableCycle(List cycleRoots) {
        HashMap resultMap = new HashMap();
        for (Container container : cycleRoots) {
            ArrayList<Rectangle> result = new ArrayList<Rectangle>();
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            Component comp = policy.getFirstComponent(container);
            if (comp == null) {
                resultMap.put(container, result);
                continue;
            }
            Rectangle rect = this.getRect(comp);
            HashSet<Component> addedComponents = new HashSet<Component>();
            addedComponents.add(comp);
            result.add(rect);
            Component nextComp = null;
            try {
                nextComp = policy.getComponentAfter(container, comp);
            }
            catch (RuntimeException runtimeException) {}
            while (nextComp != comp) {
                result.add(this.getRect(nextComp));
                addedComponents.add(nextComp);
                try {
                    nextComp = policy.getComponentAfter(container, nextComp);
                    if (nextComp != null && !addedComponents.contains(nextComp)) continue;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            resultMap.put(container, result);
        }
        return resultMap;
    }

    protected BorderGlassPane createGlassPaneIfItDoesNotExist() {
        BorderGlassPane glassPane = null;
        if (this.myCurrentlySelectedWindow instanceof JDialog) {
            JDialog dialog = (JDialog)this.myCurrentlySelectedWindow;
            if (dialog.getGlassPane() == null || !(dialog.getGlassPane() instanceof BorderGlassPane)) {
                glassPane = new BorderGlassPane(dialog);
                dialog.setGlassPane(glassPane);
                glassPane.setVisible(true);
            } else {
                glassPane = (BorderGlassPane)dialog.getGlassPane();
                glassPane.setVisible(true);
            }
        } else if (this.myCurrentlySelectedWindow instanceof JFrame) {
            JFrame frame = (JFrame)this.myCurrentlySelectedWindow;
            if (frame.getGlassPane() == null || !(frame.getGlassPane() instanceof BorderGlassPane)) {
                glassPane = new BorderGlassPane(frame);
                frame.setGlassPane(glassPane);
                glassPane.setVisible(true);
            } else {
                glassPane = (BorderGlassPane)frame.getGlassPane();
                glassPane.setVisible(true);
            }
        }
        if (glassPane != null) {
            glassPane.clearBorders();
        }
        return glassPane;
    }

    protected void cleanCurrentGlassPane() {
        if (this.myCurrentGlassPane != null) {
            this.myCurrentGlassPane.clearBorders();
            this.myCurrentlySelectedWindow.repaint();
        }
    }

    private List findCycleRoots(Container container, List roots) {
        ArrayList<Container> result = new ArrayList<Container>();
        if (container.isFocusCycleRoot()) {
            result.add(container);
            roots.add(this.getRect(container));
        }
        Component[] comps = container.getComponents();
        int counter = 0;
        while (counter < comps.length) {
            Component comp = comps[counter];
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                if (cont.isFocusCycleRoot()) {
                    result.add(cont);
                    roots.add(this.getRect(cont));
                }
                result.addAll(this.findCycleRoots(cont, roots));
            }
            ++counter;
        }
        return result;
    }

    class BorderGlassPane
    extends JComponent {
        protected Rectangle myCurrentlyFocusedBounds;
        protected List myCycleRoots = new ArrayList();
        protected Map myCycleComps = new HashMap();

        public BorderGlassPane(Window window) {
            this.myCurrentlyFocusedBounds = new Rectangle();
            this.setSize(window.getSize());
        }

        public Map getCycleComps() {
            return this.myCycleComps;
        }

        public void setCycleComps(Map cycleComps) {
            this.myCycleComps = cycleComps;
            this.repaint();
        }

        public void setCycleRoots(List roots) {
            this.myCycleRoots = roots;
            this.repaint();
        }

        public void clearBorders() {
            this.myCurrentlyFocusedBounds = new Rectangle();
            this.myCycleComps.clear();
            this.myCycleRoots.clear();
            this.repaint();
        }

        public void setHighlightedRect(Rectangle rect) {
            this.myCurrentlyFocusedBounds = rect;
            this.repaint();
        }

        private Container getContainer(Rectangle bounds) {
            for (Container container : this.myCycleComps.keySet()) {
                if (SwingUtilities.getRootPane(container) == null || container == null || !FocusTraversalDialog.this.getRect(container).equals(bounds)) continue;
                return container;
            }
            return null;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.RED);
            if (this.myCurrentlyFocusedBounds != null && !this.myCurrentlyFocusedBounds.equals(new Rectangle(0, 0, 0, 0))) {
                g.drawRect(this.myCurrentlyFocusedBounds.x, this.myCurrentlyFocusedBounds.y, Math.max(this.myCurrentlyFocusedBounds.width, 7) - 1, Math.max(this.myCurrentlyFocusedBounds.height, 7) - 1);
            }
            g.setFont(new Font("Dialog", 0, 10));
            g.setColor(Color.RED);
            for (Rectangle rect : this.myCycleRoots) {
                g.setColor(Color.CYAN);
                g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                String text = "Focus cycle root";
                Container cont = this.getContainer(rect);
                if (cont != null) {
                    text = String.valueOf(text) + ": " + cont.getClass().getName();
                }
                g.fillRect(rect.x + 4, rect.y - 6, g.getFontMetrics().stringWidth(text) + 3, 10);
                g.setColor(Color.black);
                g.drawString(text, rect.x + 4, rect.y + 2);
            }
            Rectangle prevRect = null;
            for (Container cont : this.myCycleComps.keySet()) {
                List cycleComps = (List)this.myCycleComps.get(cont);
                if (cycleComps == null) continue;
                Iterator cycleIter = cycleComps.iterator();
                while (cycleIter.hasNext()) {
                    Rectangle rect = (Rectangle)cycleIter.next();
                    g.setColor(Color.GREEN);
                    int xPos = rect.x + rect.width / 2;
                    int yPos = rect.y + rect.height / 2;
                    if (prevRect != null) {
                        int xPosPrev = prevRect.x + prevRect.width / 2;
                        int yPosPrev = prevRect.y + prevRect.height / 2;
                        g.drawLine(xPosPrev, yPosPrev, xPos, yPos);
                        double xDiff = xPos - xPosPrev;
                        double yDiff = yPos - yPosPrev;
                        PArrowIcon icon = new PArrowIcon(5, 5, Color.GREEN, 3);
                        g.translate(xPosPrev + (int)xDiff / 2, yPosPrev + (int)yDiff / 2);
                        if (!GeneralUtils.isEqual(xDiff, 0.0)) {
                            ((Graphics2D)g).rotate(Math.atan2(yDiff, xDiff));
                        } else {
                            ((Graphics2D)g).rotate(1.5707963267948966);
                        }
                        icon.paintIcon(null, g, 0, -1);
                        if (!GeneralUtils.isEqual(xDiff, 0.0)) {
                            ((Graphics2D)g).rotate(-Math.atan2(yDiff, xDiff));
                        } else {
                            ((Graphics2D)g).rotate(-1.5707963267948966);
                        }
                        g.translate(-xPosPrev - (int)xDiff / 2, -yPosPrev - (int)yDiff / 2);
                        g.setColor(Color.RED);
                        g.fillOval(xPosPrev - 4, yPosPrev - 4, 8, 8);
                        g.setColor(Color.GREEN);
                        g.fillOval(xPosPrev - 3, yPosPrev - 3, 6, 6);
                    }
                    prevRect = cycleIter.hasNext() ? rect : null;
                    g.setColor(Color.red);
                    int size = 8;
                    int selectedMidX = this.myCurrentlyFocusedBounds.x + this.myCurrentlyFocusedBounds.width / 2;
                    int selectedMidY = this.myCurrentlyFocusedBounds.y + this.myCurrentlyFocusedBounds.height / 2;
                    if (selectedMidX == xPos && selectedMidY == yPos) {
                        size = 12;
                    }
                    g.fillOval(xPos - size / 2, yPos - size / 2, size, size);
                    g.setColor(Color.GREEN);
                    g.fillOval(xPos - 3, yPos - 3, 6, 6);
                }
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    class FocusListener
    implements PropertyChangeListener {
        FocusListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!(evt.getNewValue() instanceof JComponent)) {
                return;
            }
            if (!(evt.getOldValue() instanceof JComponent) && evt.getOldValue() != null) {
                return;
            }
            JComponent newComp = (JComponent)evt.getNewValue();
            JComponent oldComp = (JComponent)evt.getOldValue();
            if (newComp != null && SwingUtilities.getWindowAncestor(newComp) == FocusTraversalDialog.this) {
                return;
            }
            if ("focusOwner".equals(evt.getPropertyName()) || "permanentFocusOwner".equals(evt.getPropertyName())) {
                if (FocusTraversalDialog.this.myCurrentFocusOwner != null && newComp != null) {
                    StringBuffer sb = new StringBuffer(newComp.toString());
                    int i = 1;
                    while (i <= newComp.toString().length() / 40) {
                        sb.insert(i * 40 + 1, "\n");
                        ++i;
                    }
                    FocusTraversalDialog.this.myCurrentFocusOwner.setText(sb.toString());
                    FocusTraversalDialog.this.myCurrentFocusOwner.scrollRectToVisible(new Rectangle(5, 5, 1, 1));
                    FocusTraversalDialog.this.myCurrentFocusOwner.repaint();
                }
                FocusTraversalDialog.this.drawBorder(newComp);
                if (SwingUtilities.getRootPane(oldComp) != null && FocusTraversalDialog.this.myCurrentGlassPane != null) {
                    Window w = null;
                    if (oldComp != null) {
                        w = FocusTraversalDialog.this.myCurrentlySelectedWindow;
                    }
                    if (w == null) {
                        return;
                    }
                    ArrayList roots = new ArrayList();
                    List rootComps = FocusTraversalDialog.this.findCycleRoots(w, roots);
                    FocusTraversalDialog.this.myCurrentGlassPane.setCycleRoots(roots);
                    FocusTraversalDialog.this.myCurrentGlassPane.setCycleComps(FocusTraversalDialog.this.findFocusableCycle(rootComps));
                }
            }
        }
    }
}

