/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class MemoryStatusDialog
extends JDialog {
    private static final long MB_DIVIDER = 0x100000L;
    private JButton myGcButton;
    private JButton myCloseButton;
    private JProgressBar myMemoryStatus;
    private Font myProgressFont;
    private Timer myUpdateTimer;
    private Runtime myRuntime;

    public MemoryStatusDialog() {
        this.initUI();
        this.myRuntime = Runtime.getRuntime();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myUpdateTimer != null) {
            this.myUpdateTimer.stop();
        }
    }

    private void initUI() {
        this.setTitle("Memory Status");
        this.setLocationRelativeTo(null);
        this.setModal(false);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add((Component)panel2, "South");
        this.myGcButton = new JButton();
        this.myGcButton.setText("Run GC");
        this.myGcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        panel2.add(this.myGcButton);
        this.myCloseButton = new JButton();
        this.myCloseButton.setText("Close");
        this.myCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryStatusDialog.this.dispose();
            }
        });
        panel2.add(this.myCloseButton);
        this.myMemoryStatus = new JProgressBar();
        this.myMemoryStatus.setBackground(new Color(-1));
        this.myMemoryStatus.setForeground(new Color(-6710785));
        this.myMemoryStatus.setStringPainted(true);
        this.myProgressFont = new Font("Dialog", 0, 12);
        this.myMemoryStatus.setFont(this.myProgressFont);
        this.getContentPane().add((Component)this.myMemoryStatus, "Center");
        this.myUpdateTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int maxMem = (int)(MemoryStatusDialog.this.myRuntime.maxMemory() / 0x100000L);
                int currentMem = (int)((MemoryStatusDialog.this.myRuntime.totalMemory() - MemoryStatusDialog.this.myRuntime.freeMemory()) / 0x100000L);
                MemoryStatusDialog.this.myMemoryStatus.setMinimum(0);
                MemoryStatusDialog.this.myMemoryStatus.setMaximum(maxMem);
                MemoryStatusDialog.this.myMemoryStatus.setValue(currentMem);
                MemoryStatusDialog.this.myMemoryStatus.setString(String.valueOf(currentMem) + "Mb of " + maxMem + "Mb used");
            }
        });
        this.myUpdateTimer.start();
        this.pack();
    }
}

