/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import com.nokia.laf.NetTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public class MigLayoutDebugDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    protected BorderGlassPane myCurrentGlassPane;
    protected Map myWindowMap;
    protected JFrame myRootFrame;
    protected Window myCurrentlySelectedWindow;
    protected boolean myShowPrefWidths = false;
    protected boolean myShowConstraints = true;
    JCheckBox showConstraints;

    public MigLayoutDebugDialog(JFrame rootFrame) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        this.myCurrentGlassPane = new BorderGlassPane();
        this.myCurrentGlassPane.setVisible(true);
        rootFrame.setGlassPane(this.myCurrentGlassPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MigLayoutDebugDialog.this.myCurrentGlassPane != null) {
                    MigLayoutDebugDialog.this.cleanCurrentGlassPane();
                    MigLayoutDebugDialog.this.myCurrentGlassPane.setVisible(false);
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(MigLayoutDebugDialog.this);
                    MigLayoutDebugDialog.this.myCurrentGlassPane = null;
                }
            }
        });
        this.myRootFrame = rootFrame;
        this.myCurrentlySelectedWindow = this.myRootFrame;
        this.setTitle("Toggle MigLayout debug mode");
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.setAlwaysOnTop(true);
        this.setDialogModality();
        JButton button = new JButton("Toggle MigLayout debug mode");
        button.addActionListener(this);
        this.getContentPane().setLayout((LayoutManager)new MigLayout(""));
        JLabel label = new JLabel("<html>Debug mode displays component bounds <br>in <font color=blue>blue</font>,cell bounds in <font color=red>red</font>");
        this.getContentPane().add((Component)button, "wrap");
        JCheckBox showPrefSizes = new JCheckBox("Show preferred sizes");
        showPrefSizes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MigLayoutDebugDialog.this.myShowPrefWidths = !MigLayoutDebugDialog.this.myShowPrefWidths;
                MigLayoutDebugDialog.this.myCurrentGlassPane.repaint();
            }
        });
        this.showConstraints = new JCheckBox("Show component layout constraints");
        this.showConstraints.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MigLayoutDebugDialog.this.myShowConstraints = !MigLayoutDebugDialog.this.myShowConstraints;
                MigLayoutDebugDialog.this.myCurrentGlassPane.repaint();
            }
        });
        this.showConstraints.setSelected(true);
        this.getContentPane().add((Component)this.showConstraints, "wrap");
        this.getContentPane().add((Component)showPrefSizes, "wrap");
        this.getContentPane().add((Component)label, "wrap");
        Object[][] rowData = new Object[][]{{"related,rel,r", "12, 0"}, {"unrelated,unrel,u", "12, 12"}, {"indent,ind,i", "12, 12"}, {"paragraph,para,p", "9, 9"}};
        Object[] columnNames = new Object[]{"Keyword", "horizontal, vertical"};
        JTable table = new JTable(rowData, columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.getColumnModel().getColumn(0).setPreferredWidth(110);
        table.getColumnModel().getColumn(1).setPreferredWidth(120);
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(230, 230));
        this.getContentPane().add((Component)scroll, "wrap, grow, push");
        this.pack();
    }

    protected void cleanCurrentGlassPane() {
        if (this.myCurrentGlassPane != null) {
            this.myCurrentlySelectedWindow.repaint();
        }
    }

    protected void setDialogModality() {
        try {
            Class<?> clazz = Class.forName("java.awt.Dialog$ModalExclusionType");
            Object valueOf = Enum.valueOf(clazz, "APPLICATION_EXCLUDE");
            Method m = this.getClass().getMethod("setModalExclusionType", clazz);
            m.invoke((Object)this, valueOf);
        }
        catch (RuntimeException clazz) {
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to set dialog modality. This tool may not work correctly.", "Modality error", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Frame[] frames = Frame.getFrames();
        this.myCurrentGlassPane.myConstraints.clear();
        int idx = 0;
        while (idx < frames.length) {
            if (frames[idx] instanceof RootPaneContainer) {
                this.toggleDebugMode(((RootPaneContainer)((Object)frames[idx])).getContentPane());
            }
            Window[] windows = frames[idx].getOwnedWindows();
            int jdx = 0;
            while (jdx < windows.length) {
                if (windows[jdx] instanceof RootPaneContainer) {
                    this.toggleDebugMode(((RootPaneContainer)((Object)windows[jdx])).getContentPane());
                }
                ++jdx;
            }
            ++idx;
        }
    }

    private void toggleDebugMode(Container container) {
        boolean isdebugOn = false;
        if (container.getLayout() instanceof MigLayout) {
            MigLayout layout = (MigLayout)container.getLayout();
            try {
                Field field = layout.getClass().getDeclaredField("lc");
                field.setAccessible(true);
                LC lc = (LC)field.get(layout);
                isdebugOn = lc.getDebugMillis() > 1;
                lc.setDebugMillis(isdebugOn ? 0 : 500);
                container.invalidate();
                container.validate();
                container.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Component[] children = container.getComponents();
        int idx = 0;
        while (idx < children.length) {
            block9: {
                block8: {
                    Component comp = children[idx];
                    if (!(container.getLayout() instanceof MigLayout) || isdebugOn) break block8;
                    MigLayout layout = (MigLayout)container.getLayout();
                    if (!comp.isShowing()) break block9;
                    this.myCurrentGlassPane.myConstraints.put(comp, layout.getComponentConstraints(children[idx]));
                }
                if (children[idx] instanceof Container) {
                    this.toggleDebugMode((Container)children[idx]);
                }
            }
            ++idx;
        }
        this.myCurrentGlassPane.setVisible(true);
        this.myCurrentGlassPane.setSize(this.myCurrentlySelectedWindow.getSize());
        this.myCurrentGlassPane.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("activeWindow".equals(evt.getPropertyName()) && evt.getNewValue() != null && evt.getNewValue() != this) {
            this.myCurrentlySelectedWindow = (Window)evt.getNewValue();
            if (this.myCurrentlySelectedWindow instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)this.myCurrentlySelectedWindow)).setGlassPane(this.myCurrentGlassPane);
            }
        }
    }

    class BorderGlassPane
    extends JComponent {
        Map<Component, Object> myConstraints = new HashMap<Component, Object>();

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setFont(NetTheme.FONT_NORMAL.deriveFont(11.0f));
            Set<Component> points = this.myConstraints.keySet();
            for (Component comp : points) {
                String text;
                Point point = SwingUtilities.convertPoint(comp.getParent(), comp.getLocation(), this);
                g.setColor(Color.YELLOW);
                Object constraint = this.myConstraints.get(comp);
                String string = text = MigLayoutDebugDialog.this.myShowConstraints && constraint != null ? constraint.toString() : "";
                if (MigLayoutDebugDialog.this.myShowPrefWidths) {
                    text = String.valueOf(text) + " [" + comp.getPreferredSize().width + "," + comp.getPreferredSize().height + "]";
                }
                int stringWidth = g.getFontMetrics(g.getFont()).stringWidth(text);
                int xPos = point.x + comp.getWidth() / 2 - stringWidth / 2;
                int yPos = point.y + comp.getHeight() / 2 - 4;
                g.fillRect(xPos, yPos, stringWidth, 9);
                g.setColor(Color.BLACK);
                g.drawString(text, xPos, yPos + 7);
            }
        }
    }
}

