/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.util.debugging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MnemonicFinderDialog
extends JDialog {
    private String theOcupied = "FVOSTLHENBA";
    private static final Color CONFLICT_MENU_BACKGROUND = new Color(235, 135, 135);
    private static final int DEFAULT_WINDOW_HEIGHT = 500;
    private static final int DEFAULT_WINDOW_WIDTH = 450;
    protected Map myWindowMap = new HashMap();
    protected JFrame myRootFrame;
    protected Window myCurrentlySelectedWindow;
    protected JComboBox myWindowSelectionComboBox;
    protected JList myMnemonicList;
    protected JList myConflictList;
    private JLabel myAvaiableMnemonicLabel;
    protected Component mySelectedComponent = null;
    private transient ChangeListener tabListener;
    private BorderGlassPane myCurrentGlassPane;

    public MnemonicFinderDialog(JFrame rootFrame) {
        super(rootFrame);
        this.myRootFrame = rootFrame;
        this.myCurrentlySelectedWindow = this.myRootFrame;
        this.myCurrentGlassPane = this.createGlassPane();
        this.tabListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (MnemonicFinderDialog.this.myCurrentGlassPane != null) {
                    MnemonicFinderDialog.this.myCurrentGlassPane.clearBorders();
                }
                MnemonicFinderDialog.this.updateViewMnemonics();
                MnemonicFinderDialog.this.repaint();
            }
        };
        this.setModal(false);
        this.setDefaultCloseOperation(2);
        this.setTitle("Mnemonic finder");
        this.setLocationByPlatform(true);
        this.setAlwaysOnTop(true);
        this.setDialogModality();
        this.setSize(450, 500);
        JPanel comboPanel = new JPanel(new FlowLayout(1));
        this.myWindowSelectionComboBox = new JComboBox();
        this.myWindowSelectionComboBox.setPrototypeDisplayValue("########################");
        this.myWindowSelectionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MnemonicFinderDialog.this.myWindowSelectionComboBox.getSelectedItem() instanceof String) {
                    String mySelectedWindowName = (String)MnemonicFinderDialog.this.myWindowSelectionComboBox.getSelectedItem();
                    Window newSelection = (Window)MnemonicFinderDialog.this.myWindowMap.get(mySelectedWindowName);
                    MnemonicFinderDialog.this.addTabListeners(MnemonicFinderDialog.this.myCurrentlySelectedWindow);
                    if (newSelection != null && MnemonicFinderDialog.this.myCurrentlySelectedWindow != newSelection) {
                        MnemonicFinderDialog.this.myCurrentlySelectedWindow = newSelection;
                        if (MnemonicFinderDialog.this.myCurrentGlassPane != null) {
                            MnemonicFinderDialog.this.myCurrentGlassPane.clearBorders();
                        }
                        MnemonicFinderDialog.this.myCurrentGlassPane = MnemonicFinderDialog.this.createGlassPane();
                        MnemonicFinderDialog.this.updateViewMnemonics();
                        MnemonicFinderDialog.this.repaint();
                    }
                }
            }
        });
        comboPanel.add(this.myWindowSelectionComboBox);
        JButton refreshButton = new JButton("Refresh windows");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MnemonicFinderDialog.this.buildWindowList();
            }
        });
        comboPanel.add(refreshButton);
        JButton updateButton = new JButton("Refresh mnemonics");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MnemonicFinderDialog.this.myCurrentGlassPane != null) {
                    MnemonicFinderDialog.this.myCurrentGlassPane.clearBorders();
                }
                MnemonicFinderDialog.this.updateViewMnemonics();
                MnemonicFinderDialog.this.repaint();
            }
        });
        comboPanel.add(updateButton);
        this.add((Component)comboPanel, "North");
        JPanel mnemonicPanel = new JPanel();
        mnemonicPanel.setLayout(new BoxLayout(mnemonicPanel, 1));
        JLabel allMnemonicsLabel = new JLabel("All mnemonics:");
        allMnemonicsLabel.setAlignmentX(0.5f);
        mnemonicPanel.add(allMnemonicsLabel);
        this.myMnemonicList = new JList();
        this.myMnemonicList.setCellRenderer(new MnemonicListRenderer());
        mnemonicPanel.add(new JScrollPane(this.myMnemonicList));
        JLabel conflictsLabel = new JLabel("Mnemonic conflicts:");
        conflictsLabel.setAlignmentX(0.5f);
        mnemonicPanel.add(conflictsLabel);
        this.myConflictList = new JList();
        this.myConflictList.setCellRenderer(new MnemonicListRenderer());
        mnemonicPanel.add(new JScrollPane(this.myConflictList));
        JPanel mnemonAvailPanel = new JPanel();
        JLabel available = new JLabel("Available mnemoic:");
        this.myAvaiableMnemonicLabel = new JLabel("");
        this.myAvaiableMnemonicLabel.setLabelFor(available);
        mnemonAvailPanel.add(available);
        mnemonAvailPanel.add(this.myAvaiableMnemonicLabel);
        mnemonicPanel.add(mnemonAvailPanel);
        this.add((Component)mnemonicPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MnemonicFinderDialog.this.myCurrentGlassPane.clearBorders();
                MnemonicFinderDialog.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.buildWindowList();
        this.pack();
    }

    protected void updateViewMnemonics() {
        this.mySelectedComponent = this.myCurrentlySelectedWindow;
        ArrayList<MnemonicComponent> mnemonics = new ArrayList<MnemonicComponent>();
        this.traverseMnemonics((Container)this.mySelectedComponent, mnemonics);
        Collections.sort(mnemonics);
        int i = 0;
        while (i < mnemonics.size() - 1) {
            MnemonicComponent mnemonic1 = (MnemonicComponent)mnemonics.get(i);
            MnemonicComponent mnemonic2 = (MnemonicComponent)mnemonics.get(i + 1);
            if (mnemonic1.getMnemonic().equals(mnemonic2.getMnemonic()) && mnemonic1.isVisible() && mnemonic2.isVisible()) {
                mnemonic1.isDuplicate(true);
                mnemonic2.isDuplicate(true);
            }
            ++i;
        }
        DefaultListModel<MnemonicComponent> mnemonicModel = new DefaultListModel<MnemonicComponent>();
        DefaultListModel<MnemonicComponent> conflictModel = new DefaultListModel<MnemonicComponent>();
        for (MnemonicComponent mnemonic : mnemonics) {
            JMenuItem menuItem;
            mnemonicModel.addElement(mnemonic);
            if (mnemonic.getComponent() instanceof JMenuItem && (menuItem = (JMenuItem)mnemonic.getComponent()).getBackground().equals(CONFLICT_MENU_BACKGROUND)) {
                menuItem.setBackground(UIManager.getColor("MenuItem.background"));
                menuItem.setBorder((Border)UIManager.get("MenuItem.border"));
            }
            if (!mnemonic.isDuplicate()) continue;
            conflictModel.addElement(mnemonic);
            if (mnemonic.getComponent() instanceof JTabbedPane) {
                JTabbedPane pane = (JTabbedPane)mnemonic.getComponent();
                int index = 0;
                int i2 = 0;
                while (i2 < pane.getTabCount()) {
                    if (pane.getTitleAt(i2).equals(mnemonic.getText())) {
                        index = i2;
                        break;
                    }
                    ++i2;
                }
                Point compLoc = new Point();
                Point windowLoc = new Point();
                SwingUtilities.convertPointToScreen(compLoc, pane);
                SwingUtilities.convertPointToScreen(windowLoc, SwingUtilities.getRootPane(pane));
                int x = compLoc.x - windowLoc.x;
                int y = compLoc.y - windowLoc.y;
                Rectangle rect = pane.getBoundsAt(index);
                if (rect == null) continue;
                rect.x += x;
                rect.y += y;
                this.myCurrentGlassPane.addRectangle(rect);
                continue;
            }
            if (mnemonic.getComponent() instanceof JMenuItem) {
                menuItem = (JMenuItem)mnemonic.getComponent();
                menuItem.setBackground(CONFLICT_MENU_BACKGROUND);
                Color CONFLICT_MENU_BORDER = new Color(125, 50, 50);
                menuItem.setBorder(BorderFactory.createLineBorder(CONFLICT_MENU_BORDER, 2));
                continue;
            }
            this.addOverlaidComponent(mnemonic.getComponent());
        }
        this.myMnemonicList.setModel(mnemonicModel);
        this.myConflictList.setModel(conflictModel);
        this.showAvailableMnemonic(mnemonics);
    }

    private void showAvailableMnemonic(List<MnemonicComponent> lists) {
        HashSet<String> shortCutsMap = new HashSet<String>();
        char ch = 'a';
        int i = 0;
        while (i < 26) {
            if (!this.theOcupied.contains(String.valueOf(ch).toUpperCase())) {
                shortCutsMap.add(String.valueOf(ch));
            }
            ch = (char)(ch + '\u0001');
            ++i;
        }
        String mn = null;
        Component cp = null;
        for (MnemonicComponent mnemonicComponent : lists) {
            mn = mnemonicComponent.getMnemonic().toLowerCase();
            cp = mnemonicComponent.getComponent();
            if (!cp.isShowing() || !shortCutsMap.contains(mn) || cp instanceof JMenuItem) continue;
            shortCutsMap.remove(mn);
        }
        StringBuffer availableMn = new StringBuffer();
        String[] stringArray = shortCutsMap.toArray(new String[26]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str != null) {
                availableMn.append(" | ");
                availableMn.append(str);
            }
            ++n2;
        }
        this.myAvaiableMnemonicLabel.setText(availableMn.toString().trim());
    }

    protected void addOverlaidComponent(Component component) {
        if (SwingUtilities.getRootPane(component) != null) {
            Point compLoc = new Point();
            Point windowLoc = new Point();
            SwingUtilities.convertPointToScreen(compLoc, component);
            SwingUtilities.convertPointToScreen(windowLoc, SwingUtilities.getRootPane(component));
            int x = compLoc.x - windowLoc.x;
            int y = compLoc.y - windowLoc.y;
            Rectangle rect = new Rectangle(x, y, component.getBounds().width - 1, component.getBounds().height - 1);
            this.myCurrentGlassPane.addRectangle(rect);
        }
    }

    private void addTabListeners(Container container) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            JTabbedPane tabbedPane;
            Component component = componentArray[n2];
            if (component instanceof JTabbedPane && !Arrays.asList((tabbedPane = (JTabbedPane)component).getChangeListeners()).contains(this.tabListener)) {
                tabbedPane.addChangeListener(this.tabListener);
            }
            if (component instanceof Container) {
                this.addTabListeners((Container)component);
            }
            ++n2;
        }
    }

    private void traverseMnemonics(Container container, List<MnemonicComponent> mnemonics) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof AbstractButton) {
                int mnemonicKey;
                if (component instanceof JMenu) {
                    JMenu menu = (JMenu)component;
                    Component[] componentArray2 = menu.getMenuComponents();
                    int n3 = componentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Component comp = componentArray2[n4];
                        if (comp instanceof JMenuItem) {
                            JMenuItem menuItem = (JMenuItem)comp;
                            if (menuItem.getAccelerator() != null) {
                                String modifier = KeyEvent.getKeyModifiersText(menuItem.getAccelerator().getModifiers());
                                String key = KeyEvent.getKeyText(menuItem.getAccelerator().getKeyCode());
                                String mnemonic = String.valueOf(modifier) + " + " + key;
                                String text = menuItem.getText();
                                mnemonics.add(new MnemonicComponent(menuItem, mnemonic, text, true, true));
                            } else {
                                int mnemonicKey2 = menuItem.getMnemonic();
                                if (mnemonicKey2 != 0) {
                                    String mnemonic = KeyEvent.getKeyText(mnemonicKey2);
                                    String text = menuItem.getText();
                                    mnemonics.add(new MnemonicComponent(menuItem, mnemonic, text, true, true));
                                }
                            }
                        }
                        ++n4;
                    }
                }
                if ((mnemonicKey = ((AbstractButton)component).getMnemonic()) != 0) {
                    String mnemonic = KeyEvent.getKeyText(mnemonicKey);
                    String text = ((AbstractButton)component).getText();
                    boolean isVisible = component.isShowing();
                    boolean isEnabled = component.isEnabled();
                    mnemonics.add(new MnemonicComponent(component, mnemonic, text, isVisible, isEnabled));
                }
            } else if (component instanceof JLabel) {
                int mnemonicKey = ((JLabel)component).getDisplayedMnemonic();
                if (mnemonicKey != 0) {
                    String mnemonic = KeyEvent.getKeyText(mnemonicKey);
                    String text = ((JLabel)component).getText();
                    boolean isVisible = component.isShowing();
                    boolean isEnabled = component.isEnabled();
                    mnemonics.add(new MnemonicComponent(component, mnemonic, text, isVisible, isEnabled));
                }
            } else if (component instanceof JTabbedPane) {
                JTabbedPane tabbedPane = (JTabbedPane)component;
                int i = 0;
                while (i < tabbedPane.getTabCount()) {
                    int mnemonicKey = tabbedPane.getMnemonicAt(i);
                    if (mnemonicKey != 0 && mnemonicKey != -1) {
                        String mnemonic = KeyEvent.getKeyText(mnemonicKey);
                        String text = tabbedPane.getTitleAt(i);
                        boolean isVisible = component.isShowing();
                        boolean isEnabled = component.isEnabled();
                        mnemonics.add(new MnemonicComponent(component, mnemonic, text, isVisible, isEnabled));
                    }
                    ++i;
                }
            }
            if (component instanceof Container) {
                this.traverseMnemonics((Container)component, mnemonics);
            }
            ++n2;
        }
    }

    protected void setDialogModality() {
        try {
            Class<?> clazz = Class.forName("java.awt.Dialog$ModalExclusionType");
            Object valueOf = Enum.valueOf(clazz, "APPLICATION_EXCLUDE");
            Method m = this.getClass().getMethod("setModalExclusionType", clazz);
            m.invoke((Object)this, valueOf);
        }
        catch (RuntimeException clazz) {
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Failed to set dialog modality. This tool may not work correctly.", "Modality error", 0);
        }
    }

    protected void buildWindowList() {
        this.myWindowMap.clear();
        int i = 0;
        while (i < this.myRootFrame.getOwnedWindows().length) {
            Window child = this.myRootFrame.getOwnedWindows()[i];
            if (child != this && child != JOptionPane.getRootFrame()) {
                String title = child.getName();
                if (child instanceof Dialog) {
                    title = ((Dialog)child).getTitle();
                } else if (child instanceof JFrame) {
                    title = ((JFrame)child).getTitle();
                }
                if (title != null && title.trim().length() > 0) {
                    String clazzName = child.getClass().getName();
                    this.myWindowMap.put(String.valueOf(title) + " [" + clazzName + "]", child);
                }
            }
            ++i;
        }
        this.myWindowMap.put(String.valueOf(this.myRootFrame.getTitle()) + " [" + this.myRootFrame.getClass().getName() + "]", this.myRootFrame);
        this.myWindowSelectionComboBox.removeAllItems();
        for (String windowName : this.myWindowMap.keySet()) {
            if (this.myWindowMap.get(windowName) == this.myRootFrame) {
                this.myWindowSelectionComboBox.insertItemAt(windowName, 0);
                continue;
            }
            this.myWindowSelectionComboBox.addItem(windowName);
        }
        this.myWindowSelectionComboBox.setSelectedIndex(0);
        this.myCurrentlySelectedWindow = this.myRootFrame;
    }

    protected BorderGlassPane createGlassPane() {
        BorderGlassPane glassPane = null;
        if (this.myCurrentlySelectedWindow instanceof JDialog) {
            JDialog dialog = (JDialog)this.myCurrentlySelectedWindow;
            if (dialog.getGlassPane() == null || !(dialog.getGlassPane() instanceof BorderGlassPane)) {
                glassPane = new BorderGlassPane(dialog);
                dialog.setGlassPane(glassPane);
                glassPane.setVisible(true);
            } else {
                glassPane = (BorderGlassPane)dialog.getGlassPane();
            }
        } else if (this.myCurrentlySelectedWindow instanceof JFrame) {
            JFrame frame = (JFrame)this.myCurrentlySelectedWindow;
            if (frame.getGlassPane() == null || !(frame.getGlassPane() instanceof BorderGlassPane)) {
                glassPane = new BorderGlassPane(frame);
                frame.setGlassPane(glassPane);
                glassPane.setVisible(true);
            } else {
                glassPane = (BorderGlassPane)frame.getGlassPane();
            }
        }
        if (glassPane != null) {
            glassPane.clearBorders();
        }
        return glassPane;
    }

    protected void cleanCurrentGlassPane() {
        if (this.myCurrentGlassPane != null) {
            this.myCurrentGlassPane.clearBorders();
            this.myCurrentlySelectedWindow.repaint();
        }
    }

    private static class BorderGlassPane
    extends JComponent {
        protected List<Rectangle> myBorders = new LinkedList<Rectangle>();

        public BorderGlassPane(Window window) {
            this.setSize(window.getSize());
        }

        public void clearBorders() {
            this.myBorders.clear();
        }

        public void addRectangle(Rectangle rect) {
            this.myBorders.add(rect);
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.RED);
            for (Rectangle rect : this.myBorders) {
                g.setColor(new Color(255, 50, 50, 125));
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(new Color(125, 50, 50));
                g.drawRect(rect.x + 1, rect.y + 1, rect.width - 1, rect.height - 1);
                g.drawRect(rect.x, rect.y, rect.width + 1, rect.height + 1);
            }
        }
    }

    private static class MnemonicComponent
    implements Comparable {
        private Component myComponent;
        private String myMnemonic;
        private String myText;
        private boolean myVisible;
        private boolean myEnabled;
        private boolean myDuplicate;

        public MnemonicComponent(Component component, String mnemonic, String text, boolean visible, boolean enabled) {
            this.myComponent = component;
            this.myMnemonic = mnemonic;
            this.myText = text;
            this.myVisible = visible;
            this.myEnabled = enabled;
        }

        public Component getComponent() {
            return this.myComponent;
        }

        public String getMnemonic() {
            return this.myMnemonic;
        }

        public String getText() {
            return this.myText;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public void isDuplicate(boolean duplicate) {
            this.myDuplicate = duplicate;
        }

        public boolean isDuplicate() {
            return this.myDuplicate;
        }

        public boolean equals(Object value) {
            if (!(value instanceof MnemonicComponent)) {
                return false;
            }
            MnemonicComponent mnemonic = (MnemonicComponent)value;
            return this.myMnemonic.equals(mnemonic.getMnemonic());
        }

        public int hashCode() {
            return this.myMnemonic.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.myMnemonic);
            sb.append(" - ");
            sb.append(this.myComponent.getClass().toString().substring(this.myComponent.getClass().toString().lastIndexOf(".") + 1));
            sb.append(" \"");
            sb.append(String.valueOf(this.myText) + "\"");
            return sb.toString();
        }

        public int compareTo(Object obj) {
            MnemonicComponent mnemonic = (MnemonicComponent)obj;
            int i = this.getMnemonic().compareTo(mnemonic.getMnemonic());
            if (i != 0) {
                return i;
            }
            i = Boolean.valueOf(this.isVisible()).compareTo(mnemonic.isVisible());
            return i;
        }
    }

    private static class MnemonicListRenderer
    extends JLabel
    implements ListCellRenderer {
        private MnemonicListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            if (value instanceof MnemonicComponent) {
                if (isSelected) {
                    this.setBackground(Color.DARK_GRAY);
                }
                MnemonicComponent mnemonic = (MnemonicComponent)value;
                this.setText(mnemonic.toString());
                if (!mnemonic.isVisible() || !mnemonic.isEnabled()) {
                    this.setForeground(Color.LIGHT_GRAY);
                } else {
                    this.setForeground(new Color(75, 175, 75));
                }
                if (mnemonic.isDuplicate()) {
                    this.setForeground(new Color(100, 25, 25));
                }
                this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
                return this;
            }
            return null;
        }
    }
}

